/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheClient;
import org.apache.commons.jcs.engine.CacheAdaptor;
import org.apache.commons.jcs.engine.CacheEventQueueFactory;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheNoWait<K, V>
extends AbstractAuxiliaryCache<K, V> {
    private static final Log log = LogFactory.getLog(RemoteCacheNoWait.class);
    private final IRemoteCacheClient<K, V> remoteCacheClient;
    private ICacheEventQueue<K, V> cacheEventQueue;
    private int getCount = 0;
    private int getMatchingCount = 0;
    private int getMultipleCount = 0;
    private int removeCount = 0;
    private int putCount = 0;

    public RemoteCacheNoWait(IRemoteCacheClient<K, V> cache) {
        this.remoteCacheClient = cache;
        this.cacheEventQueue = this.createCacheEventQueue(cache);
        if (this.remoteCacheClient.getStatus() == CacheStatus.ERROR) {
            this.cacheEventQueue.destroy();
        }
    }

    private ICacheEventQueue<K, V> createCacheEventQueue(IRemoteCacheClient<K, V> client) {
        CacheEventQueueFactory<K, V> factory = new CacheEventQueueFactory<K, V>();
        ICacheEventQueue ceq = factory.createCacheEventQueue(new CacheAdaptor<K, V>(client), client.getListenerId(), client.getCacheName(), client.getAuxiliaryCacheAttributes().getEventQueuePoolName(), client.getAuxiliaryCacheAttributes().getEventQueueType());
        return ceq;
    }

    @Override
    public void update(ICacheElement<K, V> element) throws IOException {
        ++this.putCount;
        try {
            this.cacheEventQueue.addPutEvent(element);
        }
        catch (IOException e2) {
            log.error("Problem adding putEvent to queue.", e2);
            this.cacheEventQueue.destroy();
            throw e2;
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) throws IOException {
        ++this.getCount;
        try {
            return this.remoteCacheClient.get(key);
        }
        catch (UnmarshalException ue) {
            if (log.isDebugEnabled()) {
                log.debug("Retrying the get owing to UnmarshalException.");
            }
            try {
                return this.remoteCacheClient.get(key);
            }
            catch (IOException ex) {
                if (log.isInfoEnabled()) {
                    log.info("Failed in retrying the get for the second time. " + ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) throws IOException {
        ++this.getMatchingCount;
        try {
            return this.remoteCacheClient.getMatching(pattern);
        }
        catch (UnmarshalException ue) {
            if (log.isDebugEnabled()) {
                log.debug("Retrying the getMatching owing to UnmarshalException.");
            }
            try {
                return this.remoteCacheClient.getMatching(pattern);
            }
            catch (IOException ex) {
                if (log.isInfoEnabled()) {
                    log.info("Failed in retrying the getMatching for the second time. " + ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) throws IOException {
        ++this.getMultipleCount;
        try {
            return this.remoteCacheClient.getMultiple(keys);
        }
        catch (UnmarshalException ue) {
            if (log.isDebugEnabled()) {
                log.debug("Retrying the getMultiple owing to UnmarshalException...");
            }
            try {
                return this.remoteCacheClient.getMultiple(keys);
            }
            catch (IOException ex) {
                if (log.isInfoEnabled()) {
                    log.info("Failed in retrying the getMultiple for the second time. " + ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        return new HashMap();
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        return this.remoteCacheClient.getKeySet();
    }

    @Override
    public boolean remove(K key) throws IOException {
        ++this.removeCount;
        try {
            this.cacheEventQueue.addRemoveEvent(key);
        }
        catch (IOException e2) {
            log.error("Problem adding RemoveEvent to queue.", e2);
            this.cacheEventQueue.destroy();
            throw e2;
        }
        return false;
    }

    @Override
    public void removeAll() throws IOException {
        try {
            this.cacheEventQueue.addRemoveAllEvent();
        }
        catch (IOException e2) {
            log.error("Problem adding RemoveAllEvent to queue.", e2);
            this.cacheEventQueue.destroy();
            throw e2;
        }
    }

    @Override
    public void dispose() {
        try {
            this.cacheEventQueue.addDisposeEvent();
        }
        catch (IOException e2) {
            log.error("Problem adding DisposeEvent to queue.", e2);
            this.cacheEventQueue.destroy();
        }
    }

    @Override
    public int getSize() {
        return this.remoteCacheClient.getSize();
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.REMOTE_CACHE;
    }

    @Override
    public CacheStatus getStatus() {
        return this.cacheEventQueue.isWorking() ? this.remoteCacheClient.getStatus() : CacheStatus.ERROR;
    }

    @Override
    public String getCacheName() {
        return this.remoteCacheClient.getCacheName();
    }

    public void fixCache(ICacheServiceNonLocal<?, ?> remote) {
        this.remoteCacheClient.fixCache(remote);
        this.resetEventQ();
    }

    public void resetEventQ() {
        ICacheEventQueue<K, V> previousQueue = this.cacheEventQueue;
        this.cacheEventQueue = this.createCacheEventQueue(this.remoteCacheClient);
        if (previousQueue.isWorking()) {
            if (log.isInfoEnabled()) {
                log.info("resetEventQ, previous queue has [" + previousQueue.size() + "] items queued up.");
            }
            previousQueue.destroy();
        }
    }

    protected IRemoteCacheClient<K, V> getRemoteCache() {
        return this.remoteCacheClient;
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.remoteCacheClient.getAuxiliaryCacheAttributes();
    }

    protected ICacheEventQueue<K, V> getCacheEventQueue() {
        return this.cacheEventQueue;
    }

    public String toString() {
        return this.getStats() + "\n" + this.remoteCacheClient.toString();
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<CacheStatus>("Status", this.getStatus()));
        IStats cStats = this.remoteCacheClient.getStatistics();
        if (cStats != null) {
            elems.addAll(cStats.getStatElements());
        }
        IStats eqStats = this.cacheEventQueue.getStatistics();
        elems.addAll(eqStats.getStatElements());
        elems.add(new StatElement<Integer>("Get Count", this.getCount));
        elems.add(new StatElement<Integer>("GetMatching Count", this.getMatchingCount));
        elems.add(new StatElement<Integer>("GetMultiple Count", this.getMultipleCount));
        elems.add(new StatElement<Integer>("Remove Count", this.removeCount));
        elems.add(new StatElement<Integer>("Put Count", this.putCount));
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return "Remote Cache No Wait";
    }
}

