/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheElementSerialized;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.utils.net.HostNameUtil;
import org.apache.commons.jcs.utils.serialization.SerializationConversionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRemoteCacheListener<K, V>
implements IRemoteCacheListener<K, V> {
    private static final Log log = LogFactory.getLog(AbstractRemoteCacheListener.class);
    private static String localHostName = null;
    private ICompositeCacheManager cacheMgr;
    private final IRemoteCacheAttributes irca;
    private long listenerId = 0L;
    private IElementSerializer elementSerializer;

    public AbstractRemoteCacheListener(IRemoteCacheAttributes irca, ICompositeCacheManager cacheMgr, IElementSerializer elementSerializer) {
        this.irca = irca;
        this.cacheMgr = cacheMgr;
        this.elementSerializer = elementSerializer;
    }

    @Override
    public void setListenerId(long id) throws IOException {
        this.listenerId = id;
        if (log.isInfoEnabled()) {
            log.info("set listenerId = [" + id + "]");
        }
    }

    @Override
    public long getListenerId() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("get listenerId = [" + this.listenerId + "]");
        }
        return this.listenerId;
    }

    @Override
    public RemoteType getRemoteType() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("getRemoteType = [" + (Object)((Object)this.irca.getRemoteType()) + "]");
        }
        return this.irca.getRemoteType();
    }

    @Override
    public void handlePut(ICacheElement<K, V> cb) throws IOException {
        if (this.irca.getRemoveUponRemotePut()) {
            if (log.isDebugEnabled()) {
                log.debug("PUTTING ELEMENT FROM REMOTE, (  invalidating ) ");
            }
            this.handleRemove(cb.getCacheName(), cb.getKey());
        } else {
            if (log.isDebugEnabled()) {
                log.debug("PUTTING ELEMENT FROM REMOTE, ( updating ) ");
                log.debug("cb = " + cb);
            }
            if (cb instanceof ICacheElementSerialized) {
                if (log.isDebugEnabled()) {
                    log.debug("Object needs to be deserialized.");
                }
                try {
                    cb = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)cb, this.elementSerializer);
                    if (log.isDebugEnabled()) {
                        log.debug("Deserialized result = " + cb);
                    }
                }
                catch (IOException e2) {
                    throw e2;
                }
                catch (ClassNotFoundException e3) {
                    log.error("Received a serialized version of a class that we don't know about.", e3);
                }
            }
            this.getCacheManager().getCache(cb.getCacheName()).localUpdate(cb);
        }
    }

    @Override
    public void handleRemove(String cacheName, K key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("handleRemove> cacheName=" + cacheName + ", key=" + key);
        }
        this.getCacheManager().getCache(cacheName).localRemove(key);
    }

    @Override
    public void handleRemoveAll(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("handleRemoveAll> cacheName=" + cacheName);
        }
        this.getCacheManager().getCache(cacheName).localRemoveAll();
    }

    @Override
    public void handleDispose(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("handleDispose> cacheName=" + cacheName);
        }
    }

    protected ICompositeCacheManager getCacheManager() {
        if (this.cacheMgr == null) {
            try {
                this.cacheMgr = CompositeCacheManager.getInstance();
                if (log.isDebugEnabled()) {
                    log.debug("had to get cacheMgr");
                    log.debug("cacheMgr = " + this.cacheMgr);
                }
            }
            catch (CacheException e2) {
                log.error("Could not get cacheMgr", e2);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("already got cacheMgr = " + this.cacheMgr);
        }
        return this.cacheMgr;
    }

    @Override
    public synchronized String getLocalHostAddress() throws IOException {
        if (localHostName == null) {
            try {
                localHostName = HostNameUtil.getLocalHostAddress();
            }
            catch (UnknownHostException uhe) {
                localHostName = "unknown";
            }
        }
        return localHostName;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n AbstractRemoteCacheListener: ");
        buf.append("\n RemoteHost = " + this.irca.getRemoteLocation().toString());
        buf.append("\n ListenerId = " + this.listenerId);
        return buf.toString();
    }
}

