/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral.socket.tcp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheFactory;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.LateralCache;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheMonitor;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPDiscoveryListener;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPListener;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPService;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs.engine.CacheWatchRepairable;
import org.apache.commons.jcs.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs.engine.ZombieCacheWatch;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryManager;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralTCPCacheFactory
extends AbstractAuxiliaryCacheFactory {
    private static final Log log = LogFactory.getLog(LateralTCPCacheFactory.class);
    private ConcurrentHashMap<String, ICacheServiceNonLocal<?, ?>> csnlInstances;
    private ReentrantLock csnlLock;
    private ConcurrentHashMap<String, LateralTCPDiscoveryListener> lTCPDLInstances;
    private LateralCacheMonitor monitor;
    private CacheWatchRepairable lateralWatch;

    public <K, V> LateralCacheNoWaitFacade<K, V> createCache(AuxiliaryCacheAttributes iaca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        ITCPLateralCacheAttributes lac = (ITCPLateralCacheAttributes)iaca;
        ArrayList<LateralCacheNoWait<K, V>> noWaits = new ArrayList<LateralCacheNoWait<K, V>>();
        if (lac.getTcpServers() != null) {
            StringTokenizer it = new StringTokenizer(lac.getTcpServers(), ",");
            if (log.isDebugEnabled()) {
                log.debug("Configured for [" + it.countTokens() + "]  servers.");
            }
            while (it.hasMoreElements()) {
                String server = (String)it.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug("tcp server = " + server);
                }
                ITCPLateralCacheAttributes lacC = (ITCPLateralCacheAttributes)lac.clone();
                lacC.setTcpServer(server);
                LateralCacheNoWait<K, V> lateralNoWait = this.createCacheNoWait(lacC, cacheEventLogger, elementSerializer);
                this.addListenerIfNeeded(lacC, cacheMgr);
                this.monitor.addCache(lateralNoWait);
                noWaits.add(lateralNoWait);
            }
        }
        ILateralCacheListener<K, V> listener = this.createListener(lac, cacheMgr);
        LateralCacheNoWait[] lcnwArray = noWaits.toArray(new LateralCacheNoWait[0]);
        LateralCacheNoWaitFacade<K, V> lcnwf = new LateralCacheNoWaitFacade<K, V>(listener, lcnwArray, lac);
        this.createDiscoveryService(lac, lcnwf, cacheMgr, cacheEventLogger, elementSerializer);
        return lcnwf;
    }

    protected <K, V> LateralCacheNoWait<K, V> createCacheNoWait(ITCPLateralCacheAttributes lca, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        ICacheServiceNonLocal<K, V> lateralService = this.getCSNLInstance(lca);
        LateralCache<K, V> cache = new LateralCache<K, V>(lca, lateralService, this.monitor);
        cache.setCacheEventLogger(cacheEventLogger);
        cache.setElementSerializer(elementSerializer);
        if (log.isDebugEnabled()) {
            log.debug("Created cache for noWait, cache [" + cache + "]");
        }
        LateralCacheNoWait<K, V> lateralNoWait = new LateralCacheNoWait<K, V>(cache);
        lateralNoWait.setCacheEventLogger(cacheEventLogger);
        lateralNoWait.setElementSerializer(elementSerializer);
        if (log.isInfoEnabled()) {
            log.info("Created LateralCacheNoWait for [" + lca + "] LateralCacheNoWait = [" + lateralNoWait + "]");
        }
        return lateralNoWait;
    }

    @Override
    public void initialize() {
        this.csnlInstances = new ConcurrentHashMap();
        this.csnlLock = new ReentrantLock();
        this.lTCPDLInstances = new ConcurrentHashMap();
        this.monitor = new LateralCacheMonitor(this);
        this.monitor.setDaemon(true);
        this.monitor.start();
        this.lateralWatch = new CacheWatchRepairable();
        this.lateralWatch.setCacheWatch(new ZombieCacheWatch());
    }

    @Override
    public void dispose() {
        for (ICacheServiceNonLocal<?, ?> service : this.csnlInstances.values()) {
            try {
                service.dispose("");
            }
            catch (IOException e2) {
                log.error("Could not dispose service " + service, e2);
            }
        }
        this.csnlInstances.clear();
        this.lTCPDLInstances.clear();
        if (this.monitor != null) {
            this.monitor.notifyShutdown();
            try {
                this.monitor.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.monitor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> ICacheServiceNonLocal<K, V> getCSNLInstance(ITCPLateralCacheAttributes lca) {
        ICacheServiceNonLocal<?, ?> service;
        block8: {
            String key = lca.getTcpServer();
            service = this.csnlInstances.get(key);
            if (service == null || service instanceof ZombieCacheServiceNonLocal) {
                this.csnlLock.lock();
                try {
                    service = this.csnlInstances.get(key);
                    if (service instanceof ZombieCacheServiceNonLocal) {
                        service = null;
                        log.info("Disposing of zombie service instance for [" + key + "]");
                    }
                    if (service != null) break block8;
                    log.info("Instance for [" + key + "] is null, creating");
                    try {
                        if (log.isInfoEnabled()) {
                            log.info("Creating TCP service, lca = " + lca);
                        }
                        service = new LateralTCPService(lca);
                    }
                    catch (IOException ex) {
                        log.error("Failure, lateral instance will use zombie service", ex);
                        service = new ZombieCacheServiceNonLocal(lca.getZombieQueueMaxSize());
                        this.monitor.notifyError();
                    }
                    this.csnlInstances.put(key, service);
                }
                finally {
                    this.csnlLock.unlock();
                }
            }
        }
        return service;
    }

    private LateralTCPDiscoveryListener getDiscoveryListener(ITCPLateralCacheAttributes ilca, ICompositeCacheManager cacheManager) {
        String key = ilca.getUdpDiscoveryAddr() + ":" + ilca.getUdpDiscoveryPort();
        LateralTCPDiscoveryListener ins = null;
        LateralTCPDiscoveryListener newListener = new LateralTCPDiscoveryListener(this.getName(), cacheManager);
        ins = this.lTCPDLInstances.putIfAbsent(key, newListener);
        if (ins == null) {
            ins = newListener;
            if (log.isInfoEnabled()) {
                log.info("Created new discovery listener for " + key + " cacheName for request " + ilca.getCacheName());
            }
        }
        return ins;
    }

    private void addListenerIfNeeded(ITCPLateralCacheAttributes iaca, ICompositeCacheManager cacheMgr) {
        if (iaca.isReceive()) {
            try {
                this.addLateralCacheListener(iaca.getCacheName(), LateralTCPListener.getInstance(iaca, cacheMgr));
            }
            catch (IOException ioe) {
                log.error("Problem creating lateral listener", ioe);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Not creating a listener since we are not receiving.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> void addLateralCacheListener(String cacheName, ILateralCacheListener<K, V> listener) throws IOException {
        CacheWatchRepairable cacheWatchRepairable = this.lateralWatch;
        synchronized (cacheWatchRepairable) {
            this.lateralWatch.addCacheListener(cacheName, listener);
        }
    }

    private <K, V> ILateralCacheListener<K, V> createListener(ITCPLateralCacheAttributes attr, ICompositeCacheManager cacheMgr) {
        LateralTCPListener listener = null;
        if (attr.isReceive()) {
            if (log.isInfoEnabled()) {
                log.info("Getting listener for " + attr);
            }
            listener = LateralTCPListener.getInstance(attr, cacheMgr);
            cacheMgr.registerShutdownObserver(listener);
        } else if (log.isDebugEnabled()) {
            log.debug("Not creating a listener since we are not receiving.");
        }
        return listener;
    }

    private synchronized <K, V> UDPDiscoveryService createDiscoveryService(ITCPLateralCacheAttributes lac, LateralCacheNoWaitFacade<K, V> lcnwf, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        UDPDiscoveryService discovery = null;
        if (lac.isUdpDiscoveryEnabled()) {
            LateralTCPDiscoveryListener discoveryListener = this.getDiscoveryListener(lac, cacheMgr);
            discoveryListener.addNoWaitFacade(lac.getCacheName(), lcnwf);
            discovery = UDPDiscoveryManager.getInstance().getService(lac.getUdpDiscoveryAddr(), lac.getUdpDiscoveryPort(), lac.getTcpListenerPort(), cacheMgr);
            discovery.addParticipatingCacheName(lac.getCacheName());
            discovery.addDiscoveryListener(discoveryListener);
            if (log.isInfoEnabled()) {
                log.info("Registered TCP lateral cache [" + lac.getCacheName() + "] with UDPDiscoveryService.");
            }
        }
        return discovery;
    }
}

