/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc;

import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheFactory;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.ShrinkerThread;
import org.apache.commons.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.jcs.auxiliary.disk.jdbc.dsfactory.JndiDataSourceFactory;
import org.apache.commons.jcs.auxiliary.disk.jdbc.dsfactory.SharedPoolDataSourceFactory;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCDiskCacheFactory
extends AbstractAuxiliaryCacheFactory
implements IRequireScheduler {
    private static final Log log = LogFactory.getLog(JDBCDiskCacheFactory.class);
    private ConcurrentMap<String, TableState> tableStates;
    protected ScheduledExecutorService scheduler;
    private ConcurrentMap<String, ShrinkerThread> shrinkerThreadMap;
    private ConcurrentMap<String, DataSourceFactory> dsFactories;
    private ReentrantLock dsFactoryLock;
    protected static final String POOL_CONFIGURATION_PREFIX = "jcs.jdbcconnectionpool.";
    protected static final String ATTRIBUTE_PREFIX = ".attributes";

    public <K, V> JDBCDiskCache<K, V> createCache(AuxiliaryCacheAttributes rawAttr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) throws SQLException {
        JDBCDiskCacheAttributes cattr = (JDBCDiskCacheAttributes)rawAttr;
        TableState tableState = this.getTableState(cattr.getTableName());
        DataSourceFactory dsFactory = this.getDataSourceFactory(cattr, compositeCacheManager.getConfigurationProperties());
        JDBCDiskCache cache = new JDBCDiskCache(cattr, dsFactory, tableState, compositeCacheManager);
        cache.setCacheEventLogger(cacheEventLogger);
        cache.setElementSerializer(elementSerializer);
        this.createShrinkerWhenNeeded(cattr, cache);
        return cache;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.tableStates = new ConcurrentHashMap<String, TableState>();
        this.shrinkerThreadMap = new ConcurrentHashMap<String, ShrinkerThread>();
        this.dsFactories = new ConcurrentHashMap<String, DataSourceFactory>();
        this.dsFactoryLock = new ReentrantLock();
    }

    @Override
    public void dispose() {
        this.tableStates.clear();
        for (DataSourceFactory dsFactory : this.dsFactories.values()) {
            try {
                dsFactory.close();
            }
            catch (SQLException e2) {
                log.error("Could not close data source factory " + dsFactory.getName(), e2);
            }
        }
        this.dsFactories.clear();
        this.shrinkerThreadMap.clear();
        super.dispose();
    }

    protected TableState getTableState(String tableName) {
        TableState newTableState = new TableState(tableName);
        TableState tableState = this.tableStates.putIfAbsent(tableName, newTableState);
        if (tableState == null) {
            tableState = newTableState;
        }
        return tableState;
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutor) {
        this.scheduler = scheduledExecutor;
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduler;
    }

    protected void createShrinkerWhenNeeded(JDBCDiskCacheAttributes cattr, JDBCDiskCache<?, ?> raf) {
        if (cattr.isUseDiskShrinker()) {
            ScheduledExecutorService shrinkerService = this.getScheduledExecutorService();
            ShrinkerThread newShrinkerThread = new ShrinkerThread();
            ShrinkerThread shrinkerThread = this.shrinkerThreadMap.putIfAbsent(cattr.getTableName(), newShrinkerThread);
            if (shrinkerThread == null) {
                shrinkerThread = newShrinkerThread;
                long intervalMillis = Math.max(999, cattr.getShrinkerIntervalSeconds() * 1000);
                if (log.isInfoEnabled()) {
                    log.info("Setting the shrinker to run every [" + intervalMillis + "] ms. for table [" + cattr.getTableName() + "]");
                }
                shrinkerService.scheduleAtFixedRate(shrinkerThread, 0L, intervalMillis, TimeUnit.MILLISECONDS);
            }
            shrinkerThread.addDiskCacheToShrinkList(raf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSourceFactory getDataSourceFactory(JDBCDiskCacheAttributes cattr, Properties configProps) throws SQLException {
        String poolName = null;
        poolName = cattr.getConnectionPoolName() == null ? cattr.getCacheName() + "." + "jcs" : cattr.getConnectionPoolName();
        DataSourceFactory dsFactory = (DataSourceFactory)this.dsFactories.get(poolName);
        if (dsFactory == null) {
            this.dsFactoryLock.lock();
            try {
                dsFactory = (DataSourceFactory)this.dsFactories.get(poolName);
                if (dsFactory == null) {
                    JDBCDiskCacheAttributes dsConfig = null;
                    if (cattr.getConnectionPoolName() == null) {
                        dsConfig = cattr;
                    } else {
                        dsConfig = new JDBCDiskCacheAttributes();
                        String dsConfigAttributePrefix = POOL_CONFIGURATION_PREFIX + poolName + ATTRIBUTE_PREFIX;
                        PropertySetter.setProperties(dsConfig, configProps, dsConfigAttributePrefix + ".");
                        dsConfig.setConnectionPoolName(poolName);
                    }
                    dsFactory = dsConfig.getJndiPath() != null ? new JndiDataSourceFactory() : new SharedPoolDataSourceFactory();
                    dsFactory.initialize(dsConfig);
                    this.dsFactories.put(poolName, dsFactory);
                }
            }
            finally {
                this.dsFactoryLock.unlock();
            }
        }
        return dsFactory;
    }
}

