/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.KeyValue;

public final class StaticBucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 255;
    private Node[] m_buckets;
    private Lock[] m_locks;

    public StaticBucketMap() {
        this(255);
    }

    public StaticBucketMap(int numBuckets) {
        int size = Math.max(17, numBuckets);
        if (size % 2 == 0) {
            --size;
        }
        this.m_buckets = new Node[size];
        this.m_locks = new Lock[size];
        for (int i2 = 0; i2 < size; ++i2) {
            this.m_locks[i2] = new Lock();
        }
    }

    private final int getHash(Object key) {
        if (key == null) {
            return 0;
        }
        int hash = key.hashCode();
        hash += ~(hash << 15);
        hash ^= hash >>> 10;
        hash += hash << 3;
        hash ^= hash >>> 6;
        hash += ~(hash << 11);
        hash ^= hash >>> 16;
        return (hash %= this.m_buckets.length) < 0 ? hash * -1 : hash;
    }

    public Set keySet() {
        return new KeySet();
    }

    public int size() {
        int cnt = 0;
        for (int i2 = 0; i2 < this.m_buckets.length; ++i2) {
            cnt += this.m_locks[i2].size;
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        int hash = this.getHash(key);
        Lock lock = this.m_locks[hash];
        synchronized (lock) {
            Node n2 = this.m_buckets[hash];
            if (n2 == null) {
                n2 = new Node();
                n2.key = key;
                n2.value = value;
                this.m_buckets[hash] = n2;
                ++this.m_locks[hash].size;
                return null;
            }
            Node next = n2;
            while (next != null) {
                n2 = next;
                if (n2.key == key || n2.key != null && n2.key.equals(key)) {
                    Object returnVal = n2.value;
                    n2.value = value;
                    return returnVal;
                }
                next = next.next;
            }
            Node newNode = new Node();
            newNode.key = key;
            newNode.value = value;
            n2.next = newNode;
            ++this.m_locks[hash].size;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        int hash = this.getHash(key);
        Lock lock = this.m_locks[hash];
        synchronized (lock) {
            Node n2 = this.m_buckets[hash];
            while (n2 != null) {
                if (n2.key == key || n2.key != null && n2.key.equals(key)) {
                    return n2.value;
                }
                n2 = n2.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        int hash = this.getHash(key);
        Lock lock = this.m_locks[hash];
        synchronized (lock) {
            Node n2 = this.m_buckets[hash];
            while (n2 != null) {
                if (n2.key == key || n2.key != null && n2.key.equals(key)) {
                    return true;
                }
                n2 = n2.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        for (int i2 = 0; i2 < this.m_buckets.length; ++i2) {
            Lock lock = this.m_locks[i2];
            synchronized (lock) {
                Node n2 = this.m_buckets[i2];
                while (n2 != null) {
                    if (n2.value == value || n2.value != null && n2.value.equals(value)) {
                        return true;
                    }
                    n2 = n2.next;
                }
                continue;
            }
        }
        return false;
    }

    public Collection values() {
        return new Values();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public void putAll(Map other) {
        Iterator i2 = other.keySet().iterator();
        while (i2.hasNext()) {
            Object key = i2.next();
            this.put(key, other.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        int hash = this.getHash(key);
        Lock lock = this.m_locks[hash];
        synchronized (lock) {
            Node n2 = this.m_buckets[hash];
            Node prev = null;
            while (n2 != null) {
                if (n2.key == key || n2.key != null && n2.key.equals(key)) {
                    if (null == prev) {
                        this.m_buckets[hash] = n2.next;
                    } else {
                        prev.next = n2.next;
                    }
                    --this.m_locks[hash].size;
                    return n2.value;
                }
                prev = n2;
                n2 = n2.next;
            }
        }
        return null;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        for (int i2 = 0; i2 < this.m_buckets.length; ++i2) {
            Lock lock;
            Lock lock2 = lock = this.m_locks[i2];
            synchronized (lock2) {
                this.m_buckets[i2] = null;
                lock.size = 0;
                continue;
            }
        }
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        return ((Object)this.entrySet()).equals(other.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        int hashCode = 0;
        for (int i2 = 0; i2 < this.m_buckets.length; ++i2) {
            Lock lock = this.m_locks[i2];
            synchronized (lock) {
                Node n2 = this.m_buckets[i2];
                while (n2 != null) {
                    hashCode += n2.hashCode();
                    n2 = n2.next;
                }
                continue;
            }
        }
        return hashCode;
    }

    public void atomic(Runnable r2) {
        if (r2 == null) {
            throw new NullPointerException();
        }
        this.atomic(r2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atomic(Runnable r2, int bucket) {
        if (bucket >= this.m_buckets.length) {
            r2.run();
            return;
        }
        Lock lock = this.m_locks[bucket];
        synchronized (lock) {
            this.atomic(r2, bucket + 1);
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new ValueIterator();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public boolean contains(Object o2) {
            return StaticBucketMap.this.containsKey(o2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o2) {
            int hash = StaticBucketMap.this.getHash(o2);
            Lock lock = StaticBucketMap.this.m_locks[hash];
            synchronized (lock) {
                Node n2 = StaticBucketMap.this.m_buckets[hash];
                while (n2 != null) {
                    Object k2 = n2.getKey();
                    if (k2 == o2 || k2 != null && k2.equals(o2)) {
                        StaticBucketMap.this.remove(k2);
                        return true;
                    }
                    n2 = n2.next;
                }
            }
            return false;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object o2) {
            Map.Entry entry = (Map.Entry)o2;
            int hash = StaticBucketMap.this.getHash(entry.getKey());
            Lock lock = StaticBucketMap.this.m_locks[hash];
            synchronized (lock) {
                Node n2 = StaticBucketMap.this.m_buckets[hash];
                while (n2 != null) {
                    if (n2.equals(entry)) {
                        return true;
                    }
                    n2 = n2.next;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            int hash = StaticBucketMap.this.getHash(entry.getKey());
            Lock lock = StaticBucketMap.this.m_locks[hash];
            synchronized (lock) {
                Node n2 = StaticBucketMap.this.m_buckets[hash];
                while (n2 != null) {
                    if (n2.equals(entry)) {
                        StaticBucketMap.this.remove(n2.getKey());
                        return true;
                    }
                    n2 = n2.next;
                }
            }
            return false;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private class EntryIterator
    implements Iterator {
        private ArrayList current = new ArrayList();
        private int bucket;
        private Map.Entry last;

        private EntryIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            if (this.current.size() > 0) {
                return true;
            }
            while (this.bucket < StaticBucketMap.this.m_buckets.length) {
                Lock lock = StaticBucketMap.this.m_locks[this.bucket];
                synchronized (lock) {
                    Node n2 = StaticBucketMap.this.m_buckets[this.bucket];
                    while (n2 != null) {
                        this.current.add(n2);
                        n2 = n2.next;
                    }
                    ++this.bucket;
                    if (this.current.size() > 0) {
                        return true;
                    }
                }
            }
            return false;
        }

        protected Map.Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = (Map.Entry)this.current.remove(this.current.size() - 1);
            return this.last;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            StaticBucketMap.this.remove(this.last.getKey());
            this.last = null;
        }
    }

    private static final class Lock {
        public int size;

        private Lock() {
        }
    }

    private static final class Node
    implements Map.Entry,
    KeyValue {
        protected Object key;
        protected Object value;
        protected Node next;

        private Node() {
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object o2) {
            if (o2 == null) {
                return false;
            }
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return (this.key == null ? e2.getKey() == null : this.key.equals(e2.getKey())) && (this.value == null ? e2.getValue() == null : this.value.equals(e2.getValue()));
        }

        public Object setValue(Object val) {
            Object retVal = this.value;
            this.value = val;
            return retVal;
        }
    }
}

