/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.PBKDF2;

import net.lingala.zip4j.crypto.PBKDF2.BinTools;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;

class PBKDF2HexFormatter {
    PBKDF2HexFormatter() {
    }

    public boolean fromString(PBKDF2Parameters p2, String s2) {
        if (p2 == null || s2 == null) {
            return true;
        }
        String[] pSplit = s2.split(":");
        if (pSplit.length != 3) {
            return true;
        }
        byte[] salt = BinTools.hex2bin(pSplit[0]);
        int iterationCount = Integer.parseInt(pSplit[1]);
        byte[] bDK = BinTools.hex2bin(pSplit[2]);
        p2.setSalt(salt);
        p2.setIterationCount(iterationCount);
        p2.setDerivedKey(bDK);
        return false;
    }

    public String toString(PBKDF2Parameters p2) {
        String s2 = BinTools.bin2hex(p2.getSalt()) + ":" + String.valueOf(p2.getIterationCount()) + ":" + BinTools.bin2hex(p2.getDerivedKey());
        return s2;
    }
}

