/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.CellReferenceHelper;
import jxl.CellType;
import jxl.CellView;
import jxl.HeaderFooter;
import jxl.Hyperlink;
import jxl.Image;
import jxl.LabelCell;
import jxl.Range;
import jxl.Sheet;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.AutoFilter;
import jxl.biff.CellFinder;
import jxl.biff.ConditionalFormat;
import jxl.biff.DVParser;
import jxl.biff.DataValidation;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.IndexMapping;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.ComboBox;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.common.Assert;
import jxl.common.Logger;
import jxl.format.CellFormat;
import jxl.format.Font;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.write.Blank;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableCellFormat;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HyperlinkRecord;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.SheetCopier;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.Styles;
import jxl.write.biff.WritableSheetCopier;
import jxl.write.biff.WritableWorkbookImpl;

class WritableSheetImpl
implements WritableSheet {
    private static Logger logger = Logger.getLogger(WritableSheetImpl.class);
    private String name;
    private File outputFile;
    private RowRecord[] rows;
    private FormattingRecords formatRecords;
    private SharedStrings sharedStrings;
    private TreeSet columnFormats;
    private TreeSet autosizedColumns;
    private ArrayList hyperlinks;
    private MergedCells mergedCells;
    private int numRows;
    private int numColumns;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private boolean chartOnly;
    private DataValidation dataValidation;
    private ArrayList rowBreaks;
    private ArrayList columnBreaks;
    private ArrayList drawings;
    private ArrayList images;
    private ArrayList conditionalFormats;
    private AutoFilter autoFilter;
    private ArrayList validatedCells;
    private ComboBox comboBox;
    private boolean drawingsModified;
    private int maxRowOutlineLevel;
    private int maxColumnOutlineLevel;
    private SheetSettings settings;
    private SheetWriter sheetWriter;
    private WorkbookSettings workbookSettings;
    private WritableWorkbookImpl workbook;
    private static final int rowGrowSize = 10;
    private static final int numRowsPerSheet = 65536;
    private static final int maxSheetNameLength = 31;
    private static final char[] illegalSheetNameCharacters = new char[]{'*', ':', '?', '\\'};
    private static final String[] imageTypes = new String[]{"png"};

    public WritableSheetImpl(String n2, File of, FormattingRecords fr, SharedStrings ss, WorkbookSettings ws, WritableWorkbookImpl ww) {
        this.name = this.validateName(n2);
        this.outputFile = of;
        this.rows = new RowRecord[0];
        this.numRows = 0;
        this.numColumns = 0;
        this.chartOnly = false;
        this.workbook = ww;
        this.formatRecords = fr;
        this.sharedStrings = ss;
        this.workbookSettings = ws;
        this.drawingsModified = false;
        this.columnFormats = new TreeSet(new ColumnInfoComparator());
        this.autosizedColumns = new TreeSet();
        this.hyperlinks = new ArrayList();
        this.mergedCells = new MergedCells(this);
        this.rowBreaks = new ArrayList();
        this.columnBreaks = new ArrayList();
        this.drawings = new ArrayList();
        this.images = new ArrayList();
        this.conditionalFormats = new ArrayList();
        this.validatedCells = new ArrayList();
        this.settings = new SheetSettings(this);
        this.sheetWriter = new SheetWriter(this.outputFile, this, this.workbookSettings);
    }

    @Override
    public Cell getCell(String loc) {
        return this.getCell(CellReferenceHelper.getColumn(loc), CellReferenceHelper.getRow(loc));
    }

    @Override
    public Cell getCell(int column, int row) {
        return this.getWritableCell(column, row);
    }

    @Override
    public WritableCell getWritableCell(String loc) {
        return this.getWritableCell(CellReferenceHelper.getColumn(loc), CellReferenceHelper.getRow(loc));
    }

    @Override
    public WritableCell getWritableCell(int column, int row) {
        WritableCell c2 = null;
        if (row < this.rows.length && this.rows[row] != null) {
            c2 = this.rows[row].getCell(column);
        }
        if (c2 == null) {
            c2 = new EmptyCell(column, row);
        }
        return c2;
    }

    @Override
    public int getRows() {
        return this.numRows;
    }

    @Override
    public int getColumns() {
        return this.numColumns;
    }

    @Override
    public Cell findCell(String contents) {
        CellFinder cellFinder = new CellFinder(this);
        return cellFinder.findCell(contents);
    }

    @Override
    public Cell findCell(String contents, int firstCol, int firstRow, int lastCol, int lastRow, boolean reverse) {
        CellFinder cellFinder = new CellFinder(this);
        return cellFinder.findCell(contents, firstCol, firstRow, lastCol, lastRow, reverse);
    }

    @Override
    public Cell findCell(Pattern pattern, int firstCol, int firstRow, int lastCol, int lastRow, boolean reverse) {
        CellFinder cellFinder = new CellFinder(this);
        return cellFinder.findCell(pattern, firstCol, firstRow, lastCol, lastRow, reverse);
    }

    @Override
    public LabelCell findLabelCell(String contents) {
        CellFinder cellFinder = new CellFinder(this);
        return cellFinder.findLabelCell(contents);
    }

    @Override
    public Cell[] getRow(int row) {
        boolean found = false;
        int col = this.numColumns - 1;
        while (col >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --col;
        }
        Cell[] cells = new Cell[col + 1];
        for (int i2 = 0; i2 <= col; ++i2) {
            cells[i2] = this.getCell(i2, row);
        }
        return cells;
    }

    @Override
    public Cell[] getColumn(int col) {
        boolean found = false;
        int row = this.numRows - 1;
        while (row >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --row;
        }
        Cell[] cells = new Cell[row + 1];
        for (int i2 = 0; i2 <= row; ++i2) {
            cells[i2] = this.getCell(col, i2);
        }
        return cells;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void insertRow(int row) {
        if (row < 0 || row >= this.numRows) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = this.numRows == this.rows.length ? new RowRecord[oldRows.length + 10] : new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row, this.rows, row + 1, this.numRows - row);
        for (int i2 = row + 1; i2 <= this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].incrementRow();
        }
        HyperlinkRecord hr2 = null;
        for (HyperlinkRecord hr2 : this.hyperlinks) {
            hr2.insertRow(row);
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertRow(row);
        }
        if (this.validatedCells != null && this.validatedCells.size() > 0) {
            for (CellValue cv : this.validatedCells) {
                CellFeatures cf = cv.getCellFeatures();
                if (cf.getDVParser() == null) continue;
                cf.getDVParser().insertRow(row);
            }
        }
        this.mergedCells.insertRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        Iterator ri = this.rowBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val >= row) {
                ++val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        for (ConditionalFormat cf : this.conditionalFormats) {
            cf.insertRow(row);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowInserted(this, row);
        }
        ++this.numRows;
    }

    @Override
    public void insertColumn(int col) {
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].insertColumn(col);
        }
        HyperlinkRecord hr2 = null;
        for (HyperlinkRecord hr2 : this.hyperlinks) {
            hr2.insertColumn(col);
        }
        for (ColumnInfoRecord cir : this.columnFormats) {
            if (cir.getColumn() < col) continue;
            cir.incrementColumn();
        }
        if (this.autosizedColumns.size() > 0) {
            TreeSet<Integer> newAutosized = new TreeSet<Integer>();
            for (Integer colnumber : this.autosizedColumns) {
                if (colnumber >= col) {
                    newAutosized.add(new Integer(colnumber + 1));
                    continue;
                }
                newAutosized.add(colnumber);
            }
            this.autosizedColumns = newAutosized;
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertColumn(col);
        }
        if (this.validatedCells != null && this.validatedCells.size() > 0) {
            for (CellValue cv : this.validatedCells) {
                CellFeatures cf = cv.getCellFeatures();
                if (cf.getDVParser() == null) continue;
                cf.getDVParser().insertColumn(col);
            }
        }
        this.mergedCells.insertColumn(col);
        ArrayList<Integer> newColumnBreaks = new ArrayList<Integer>();
        Iterator ri = this.columnBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val >= col) {
                ++val;
            }
            newColumnBreaks.add(new Integer(val));
        }
        this.columnBreaks = newColumnBreaks;
        for (ConditionalFormat cf : this.conditionalFormats) {
            cf.insertColumn(col);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnInserted(this, col);
        }
        ++this.numColumns;
    }

    @Override
    public void removeColumn(int col) {
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].removeColumn(col);
        }
        HyperlinkRecord hr = null;
        Iterator i3 = this.hyperlinks.iterator();
        while (i3.hasNext()) {
            hr = (HyperlinkRecord)i3.next();
            if (hr.getColumn() == col && hr.getLastColumn() == col) {
                i3.remove();
                continue;
            }
            hr.removeColumn(col);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeColumn(col);
        }
        if (this.validatedCells != null && this.validatedCells.size() > 0) {
            for (CellValue cv : this.validatedCells) {
                CellFeatures cf = cv.getCellFeatures();
                if (cf.getDVParser() == null) continue;
                cf.getDVParser().removeColumn(col);
            }
        }
        this.mergedCells.removeColumn(col);
        ArrayList<Integer> newColumnBreaks = new ArrayList<Integer>();
        Iterator ri = this.columnBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val == col) continue;
            if (val > col) {
                --val;
            }
            newColumnBreaks.add(new Integer(val));
        }
        this.columnBreaks = newColumnBreaks;
        i3 = this.columnFormats.iterator();
        ColumnInfoRecord removeColumn = null;
        while (i3.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i3.next();
            if (cir.getColumn() == col) {
                removeColumn = cir;
                continue;
            }
            if (cir.getColumn() <= col) continue;
            cir.decrementColumn();
        }
        if (removeColumn != null) {
            this.columnFormats.remove(removeColumn);
        }
        if (this.autosizedColumns.size() > 0) {
            TreeSet<Integer> newAutosized = new TreeSet<Integer>();
            for (Integer colnumber : this.autosizedColumns) {
                if (colnumber == col) continue;
                if (colnumber > col) {
                    newAutosized.add(new Integer(colnumber - 1));
                    continue;
                }
                newAutosized.add(colnumber);
            }
            this.autosizedColumns = newAutosized;
        }
        for (ConditionalFormat cf : this.conditionalFormats) {
            cf.removeColumn(col);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnRemoved(this, col);
        }
        --this.numColumns;
    }

    @Override
    public void removeRow(int row) {
        if (row < 0 || row >= this.numRows) {
            if (this.workbookSettings.getFormulaAdjust()) {
                this.workbook.rowRemoved(this, row);
            }
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row + 1, this.rows, row, this.numRows - (row + 1));
        for (int i2 = row; i2 < this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].decrementRow();
        }
        HyperlinkRecord hr = null;
        Iterator i3 = this.hyperlinks.iterator();
        while (i3.hasNext()) {
            hr = (HyperlinkRecord)i3.next();
            if (hr.getRow() == row && hr.getLastRow() == row) {
                i3.remove();
                continue;
            }
            hr.removeRow(row);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeRow(row);
        }
        if (this.validatedCells != null && this.validatedCells.size() > 0) {
            for (CellValue cv : this.validatedCells) {
                CellFeatures cf = cv.getCellFeatures();
                if (cf.getDVParser() == null) continue;
                cf.getDVParser().removeRow(row);
            }
        }
        this.mergedCells.removeRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        Iterator ri = this.rowBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val == row) continue;
            if (val > row) {
                --val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        for (ConditionalFormat cf : this.conditionalFormats) {
            cf.removeRow(row);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowRemoved(this, row);
        }
        --this.numRows;
    }

    @Override
    public void addCell(WritableCell cell) throws WriteException, RowsExceededException {
        boolean curSharedValidation;
        if (cell.getType() == CellType.EMPTY && cell != null && cell.getCellFormat() == null) {
            return;
        }
        CellValue cv = (CellValue)cell;
        if (cv.isReferenced()) {
            throw new JxlWriteException(JxlWriteException.cellReferenced);
        }
        int row = cell.getRow();
        RowRecord rowrec = this.getRowRecord(row);
        CellValue curcell = rowrec.getCell(cv.getColumn());
        boolean bl = curSharedValidation = curcell != null && curcell.getCellFeatures() != null && curcell.getCellFeatures().getDVParser() != null && curcell.getCellFeatures().getDVParser().extendedCellsValidation();
        if (cell.getCellFeatures() != null && cell.getCellFeatures().hasDataValidation() && curSharedValidation) {
            DVParser dvp = curcell.getCellFeatures().getDVParser();
            logger.warn("Cannot add cell at " + CellReferenceHelper.getCellReference(cv) + " because it is part of the shared cell validation group " + CellReferenceHelper.getCellReference(dvp.getFirstColumn(), dvp.getFirstRow()) + "-" + CellReferenceHelper.getCellReference(dvp.getLastColumn(), dvp.getLastRow()));
            return;
        }
        if (curSharedValidation) {
            WritableCellFeatures wcf = cell.getWritableCellFeatures();
            if (wcf == null) {
                wcf = new WritableCellFeatures();
                cell.setCellFeatures(wcf);
            }
            wcf.shareDataValidation(curcell.getCellFeatures());
        }
        rowrec.addCell(cv);
        this.numRows = Math.max(row + 1, this.numRows);
        this.numColumns = Math.max(this.numColumns, rowrec.getMaxColumn());
        cv.setCellDetails(this.formatRecords, this.sharedStrings, this);
    }

    RowRecord getRowRecord(int row) throws RowsExceededException {
        RowRecord rowrec;
        if (row >= 65536) {
            throw new RowsExceededException();
        }
        if (row >= this.rows.length) {
            RowRecord[] oldRows = this.rows;
            this.rows = new RowRecord[Math.max(oldRows.length + 10, row + 1)];
            System.arraycopy(oldRows, 0, this.rows, 0, oldRows.length);
            oldRows = null;
        }
        if ((rowrec = this.rows[row]) == null) {
            this.rows[row] = rowrec = new RowRecord(row, this);
        }
        return rowrec;
    }

    RowRecord getRowInfo(int r2) {
        if (r2 < 0 || r2 > this.rows.length) {
            return null;
        }
        return this.rows[r2];
    }

    ColumnInfoRecord getColumnInfo(int c2) {
        Iterator i2 = this.columnFormats.iterator();
        ColumnInfoRecord cir = null;
        boolean stop = false;
        while (i2.hasNext() && !stop) {
            cir = (ColumnInfoRecord)i2.next();
            if (cir.getColumn() < c2) continue;
            stop = true;
        }
        if (!stop) {
            return null;
        }
        return cir.getColumn() == c2 ? cir : null;
    }

    @Override
    public void setName(String n2) {
        this.name = n2;
    }

    @Override
    public void setHidden(boolean h2) {
        this.settings.setHidden(h2);
    }

    @Override
    public void setProtected(boolean prot) {
        this.settings.setProtected(prot);
    }

    public void setSelected() {
        this.settings.setSelected();
    }

    @Override
    public boolean isHidden() {
        return this.settings.isHidden();
    }

    @Override
    public void setColumnView(int col, int width) {
        CellView cv = new CellView();
        cv.setSize(width * 256);
        this.setColumnView(col, cv);
    }

    @Override
    public void setColumnView(int col, int width, CellFormat format) {
        CellView cv = new CellView();
        cv.setSize(width * 256);
        cv.setFormat(format);
        this.setColumnView(col, cv);
    }

    @Override
    public void setColumnView(int col, CellView view) {
        block8: {
            XFRecord xfr = (XFRecord)view.getFormat();
            if (xfr == null) {
                Styles styles = this.getWorkbook().getStyles();
                xfr = styles.getNormalStyle();
            }
            try {
                int width;
                if (!xfr.isInitialized()) {
                    this.formatRecords.addStyle(xfr);
                }
                int n2 = width = view.depUsed() ? view.getDimension() * 256 : view.getSize();
                if (view.isAutosize()) {
                    this.autosizedColumns.add(new Integer(col));
                }
                ColumnInfoRecord cir = new ColumnInfoRecord(col, width, xfr);
                if (view.isHidden()) {
                    cir.setHidden(true);
                }
                if (!this.columnFormats.contains(cir)) {
                    this.columnFormats.add(cir);
                } else {
                    this.columnFormats.remove(cir);
                    this.columnFormats.add(cir);
                }
            }
            catch (NumFormatRecordsException e2) {
                logger.warn("Maximum number of format records exceeded.  Using default format.");
                ColumnInfoRecord cir = new ColumnInfoRecord(col, view.getDimension() * 256, WritableWorkbook.NORMAL_STYLE);
                if (this.columnFormats.contains(cir)) break block8;
                this.columnFormats.add(cir);
            }
        }
    }

    @Override
    public void setRowView(int row, int height) throws RowsExceededException {
        CellView cv = new CellView();
        cv.setSize(height);
        cv.setHidden(false);
        this.setRowView(row, cv);
    }

    @Override
    public void setRowView(int row, boolean collapsed) throws RowsExceededException {
        CellView cv = new CellView();
        cv.setHidden(collapsed);
        this.setRowView(row, cv);
    }

    @Override
    public void setRowView(int row, int height, boolean collapsed) throws RowsExceededException {
        CellView cv = new CellView();
        cv.setSize(height);
        cv.setHidden(collapsed);
        this.setRowView(row, cv);
    }

    @Override
    public void setRowView(int row, CellView view) throws RowsExceededException {
        RowRecord rowrec = this.getRowRecord(row);
        XFRecord xfr = (XFRecord)view.getFormat();
        try {
            if (xfr != null && !xfr.isInitialized()) {
                this.formatRecords.addStyle(xfr);
            }
        }
        catch (NumFormatRecordsException e2) {
            logger.warn("Maximum number of format records exceeded.  Using default format.");
            xfr = null;
        }
        rowrec.setRowDetails(view.getSize(), false, view.isHidden(), 0, false, xfr);
        this.numRows = Math.max(this.numRows, row + 1);
    }

    public void write() throws IOException {
        boolean dmod = this.drawingsModified;
        if (this.workbook.getDrawingGroup() != null) {
            dmod |= this.workbook.getDrawingGroup().hasDrawingsOmitted();
        }
        if (this.autosizedColumns.size() > 0) {
            this.autosizeColumns();
        }
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.columnBreaks, this.hyperlinks, this.mergedCells, this.columnFormats, this.maxRowOutlineLevel, this.maxColumnOutlineLevel);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.setSettings(this.settings);
        this.sheetWriter.setPLS(this.plsRecord);
        this.sheetWriter.setDrawings(this.drawings, dmod);
        this.sheetWriter.setButtonPropertySet(this.buttonPropertySet);
        this.sheetWriter.setDataValidation(this.dataValidation, this.validatedCells);
        this.sheetWriter.setConditionalFormats(this.conditionalFormats);
        this.sheetWriter.setAutoFilter(this.autoFilter);
        this.sheetWriter.write();
    }

    void copy(Sheet s2) {
        this.settings = new SheetSettings(s2.getSettings(), this);
        SheetCopier si = new SheetCopier(s2, this);
        si.setColumnFormats(this.columnFormats);
        si.setFormatRecords(this.formatRecords);
        si.setHyperlinks(this.hyperlinks);
        si.setMergedCells(this.mergedCells);
        si.setRowBreaks(this.rowBreaks);
        si.setColumnBreaks(this.columnBreaks);
        si.setSheetWriter(this.sheetWriter);
        si.setDrawings(this.drawings);
        si.setImages(this.images);
        si.setConditionalFormats(this.conditionalFormats);
        si.setValidatedCells(this.validatedCells);
        si.copySheet();
        this.dataValidation = si.getDataValidation();
        this.comboBox = si.getComboBox();
        this.plsRecord = si.getPLSRecord();
        this.chartOnly = si.isChartOnly();
        this.buttonPropertySet = si.getButtonPropertySet();
        this.numRows = si.getRows();
        this.autoFilter = si.getAutoFilter();
        this.maxRowOutlineLevel = si.getMaxRowOutlineLevel();
        this.maxColumnOutlineLevel = si.getMaxColumnOutlineLevel();
    }

    void copy(WritableSheet s2) {
        this.settings = new SheetSettings(s2.getSettings(), this);
        WritableSheetImpl si = (WritableSheetImpl)s2;
        WritableSheetCopier sc = new WritableSheetCopier(s2, this);
        sc.setColumnFormats(si.columnFormats, this.columnFormats);
        sc.setMergedCells(si.mergedCells, this.mergedCells);
        sc.setRows(si.rows);
        sc.setRowBreaks(si.rowBreaks, this.rowBreaks);
        sc.setColumnBreaks(si.columnBreaks, this.columnBreaks);
        sc.setDataValidation(si.dataValidation);
        sc.setSheetWriter(this.sheetWriter);
        sc.setDrawings(si.drawings, this.drawings, this.images);
        sc.setWorkspaceOptions(si.getWorkspaceOptions());
        sc.setPLSRecord(si.plsRecord);
        sc.setButtonPropertySetRecord(si.buttonPropertySet);
        sc.setHyperlinks(si.hyperlinks, this.hyperlinks);
        sc.setValidatedCells(this.validatedCells);
        sc.copySheet();
        this.dataValidation = sc.getDataValidation();
        this.plsRecord = sc.getPLSRecord();
        this.buttonPropertySet = sc.getButtonPropertySet();
    }

    final HeaderRecord getHeader() {
        return this.sheetWriter.getHeader();
    }

    final FooterRecord getFooter() {
        return this.sheetWriter.getFooter();
    }

    @Override
    public boolean isProtected() {
        return this.settings.isProtected();
    }

    @Override
    public Hyperlink[] getHyperlinks() {
        Hyperlink[] hl = new Hyperlink[this.hyperlinks.size()];
        for (int i2 = 0; i2 < this.hyperlinks.size(); ++i2) {
            hl[i2] = (Hyperlink)this.hyperlinks.get(i2);
        }
        return hl;
    }

    @Override
    public Range[] getMergedCells() {
        return this.mergedCells.getMergedCells();
    }

    @Override
    public WritableHyperlink[] getWritableHyperlinks() {
        WritableHyperlink[] hl = new WritableHyperlink[this.hyperlinks.size()];
        for (int i2 = 0; i2 < this.hyperlinks.size(); ++i2) {
            hl[i2] = (WritableHyperlink)this.hyperlinks.get(i2);
        }
        return hl;
    }

    @Override
    public void removeHyperlink(WritableHyperlink h2) {
        this.removeHyperlink(h2, false);
    }

    @Override
    public void removeHyperlink(WritableHyperlink h2, boolean preserveLabel) {
        this.hyperlinks.remove(this.hyperlinks.indexOf(h2));
        if (!preserveLabel) {
            Assert.verify(this.rows.length > h2.getRow() && this.rows[h2.getRow()] != null);
            this.rows[h2.getRow()].removeCell(h2.getColumn());
        }
    }

    @Override
    public void addHyperlink(WritableHyperlink h2) throws WriteException, RowsExceededException {
        Label l2;
        String cnts;
        Cell c2 = this.getCell(h2.getColumn(), h2.getRow());
        String contents = null;
        if (h2.isFile() || h2.isUNC()) {
            cnts = h2.getContents();
            contents = cnts == null ? h2.getFile().getPath() : cnts;
        } else if (h2.isURL()) {
            cnts = h2.getContents();
            contents = cnts == null ? h2.getURL().toString() : cnts;
        } else if (h2.isLocation()) {
            contents = h2.getContents();
        }
        if (c2.getType() == CellType.LABEL) {
            l2 = (Label)c2;
            l2.setString(contents);
            WritableCellFormat wcf = new WritableCellFormat(l2.getCellFormat());
            wcf.setFont(WritableWorkbook.HYPERLINK_FONT);
            l2.setCellFormat(wcf);
        } else {
            l2 = new Label(h2.getColumn(), h2.getRow(), contents, (CellFormat)WritableWorkbook.HYPERLINK_STYLE);
            this.addCell(l2);
        }
        for (int i2 = h2.getRow(); i2 <= h2.getLastRow(); ++i2) {
            for (int j2 = h2.getColumn(); j2 <= h2.getLastColumn(); ++j2) {
                if (i2 == h2.getRow() || j2 == h2.getColumn() || this.rows.length >= h2.getLastColumn() || this.rows[i2] == null) continue;
                this.rows[i2].removeCell(j2);
            }
        }
        h2.initialize(this);
        this.hyperlinks.add(h2);
    }

    @Override
    public Range mergeCells(int col1, int row1, int col2, int row2) throws WriteException, RowsExceededException {
        if (col2 < col1 || row2 < row1) {
            logger.warn("Cannot merge cells - top left and bottom right incorrectly specified");
        }
        if (col2 >= this.numColumns || row2 >= this.numRows) {
            this.addCell(new Blank(col2, row2));
        }
        SheetRangeImpl range = new SheetRangeImpl(this, col1, row1, col2, row2);
        this.mergedCells.add(range);
        return range;
    }

    @Override
    public void setRowGroup(int row1, int row2, boolean collapsed) throws WriteException, RowsExceededException {
        if (row2 < row1) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        for (int i2 = row1; i2 <= row2; ++i2) {
            RowRecord row = this.getRowRecord(i2);
            this.numRows = Math.max(i2 + 1, this.numRows);
            row.incrementOutlineLevel();
            row.setCollapsed(collapsed);
            this.maxRowOutlineLevel = Math.max(this.maxRowOutlineLevel, row.getOutlineLevel());
        }
    }

    @Override
    public void unsetRowGroup(int row1, int row2) throws WriteException, RowsExceededException {
        int i2;
        if (row2 < row1) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        if (row2 >= this.numRows) {
            logger.warn("" + row2 + " is greater than the sheet bounds");
            row2 = this.numRows - 1;
        }
        for (i2 = row1; i2 <= row2; ++i2) {
            this.rows[i2].decrementOutlineLevel();
        }
        this.maxRowOutlineLevel = 0;
        i2 = this.rows.length;
        while (i2-- > 0) {
            this.maxRowOutlineLevel = Math.max(this.maxRowOutlineLevel, this.rows[i2].getOutlineLevel());
        }
    }

    @Override
    public void setColumnGroup(int col1, int col2, boolean collapsed) throws WriteException, RowsExceededException {
        if (col2 < col1) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        for (int i2 = col1; i2 <= col2; ++i2) {
            ColumnInfoRecord cir = this.getColumnInfo(i2);
            if (cir == null) {
                this.setColumnView(i2, new CellView());
                cir = this.getColumnInfo(i2);
            }
            cir.incrementOutlineLevel();
            cir.setCollapsed(collapsed);
            this.maxColumnOutlineLevel = Math.max(this.maxColumnOutlineLevel, cir.getOutlineLevel());
        }
    }

    @Override
    public void unsetColumnGroup(int col1, int col2) throws WriteException, RowsExceededException {
        if (col2 < col1) {
            logger.warn("Cannot merge cells - top and bottom rows incorrectly specified");
        }
        for (int i2 = col1; i2 <= col2; ++i2) {
            ColumnInfoRecord cir = this.getColumnInfo(i2);
            cir.decrementOutlineLevel();
        }
        this.maxColumnOutlineLevel = 0;
        for (ColumnInfoRecord cir : this.columnFormats) {
            this.maxColumnOutlineLevel = Math.max(this.maxColumnOutlineLevel, cir.getOutlineLevel());
        }
    }

    @Override
    public void unmergeCells(Range r2) {
        this.mergedCells.unmergeCells(r2);
    }

    @Override
    public void setHeader(String l2, String c2, String r2) {
        HeaderFooter header = new HeaderFooter();
        header.getLeft().append(l2);
        header.getCentre().append(c2);
        header.getRight().append(r2);
        this.settings.setHeader(header);
    }

    @Override
    public void setFooter(String l2, String c2, String r2) {
        HeaderFooter footer = new HeaderFooter();
        footer.getLeft().append(l2);
        footer.getCentre().append(c2);
        footer.getRight().append(r2);
        this.settings.setFooter(footer);
    }

    @Override
    public void setPageSetup(PageOrientation p2) {
        this.settings.setOrientation(p2);
    }

    @Override
    public void setPageSetup(PageOrientation p2, double hm, double fm) {
        this.settings.setOrientation(p2);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    @Override
    public void setPageSetup(PageOrientation p2, PaperSize ps, double hm, double fm) {
        this.settings.setPaperSize(ps);
        this.settings.setOrientation(p2);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    @Override
    public SheetSettings getSettings() {
        return this.settings;
    }

    WorkbookSettings getWorkbookSettings() {
        return this.workbookSettings;
    }

    @Override
    public void addRowPageBreak(int row) {
        Iterator i2 = this.rowBreaks.iterator();
        boolean found = false;
        while (i2.hasNext() && !found) {
            if ((Integer)i2.next() != row) continue;
            found = true;
        }
        if (!found) {
            this.rowBreaks.add(new Integer(row));
        }
    }

    @Override
    public void addColumnPageBreak(int col) {
        Iterator i2 = this.columnBreaks.iterator();
        boolean found = false;
        while (i2.hasNext() && !found) {
            if ((Integer)i2.next() != col) continue;
            found = true;
        }
        if (!found) {
            this.columnBreaks.add(new Integer(col));
        }
    }

    Chart[] getCharts() {
        return this.sheetWriter.getCharts();
    }

    private DrawingGroupObject[] getDrawings() {
        DrawingGroupObject[] dr = new DrawingGroupObject[this.drawings.size()];
        dr = this.drawings.toArray(dr);
        return dr;
    }

    void checkMergedBorders() {
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.columnBreaks, this.hyperlinks, this.mergedCells, this.columnFormats, this.maxRowOutlineLevel, this.maxColumnOutlineLevel);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.checkMergedBorders();
    }

    private WorkspaceInformationRecord getWorkspaceOptions() {
        return this.sheetWriter.getWorkspaceOptions();
    }

    void rationalize(IndexMapping xfMapping, IndexMapping fontMapping, IndexMapping formatMapping) {
        for (ColumnInfoRecord cir : this.columnFormats) {
            cir.rationalize(xfMapping);
        }
        for (int i2 = 0; i2 < this.rows.length; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].rationalize(xfMapping);
        }
        Chart[] charts = this.getCharts();
        for (int c2 = 0; c2 < charts.length; ++c2) {
            charts[c2].rationalize(xfMapping, fontMapping, formatMapping);
        }
    }

    WritableWorkbookImpl getWorkbook() {
        return this.workbook;
    }

    @Override
    public CellFormat getColumnFormat(int col) {
        return this.getColumnView(col).getFormat();
    }

    @Override
    public int getColumnWidth(int col) {
        return this.getColumnView(col).getDimension();
    }

    @Override
    public int getRowHeight(int row) {
        return this.getRowView(row).getDimension();
    }

    boolean isChartOnly() {
        return this.chartOnly;
    }

    @Override
    public CellView getRowView(int row) {
        CellView cv = new CellView();
        try {
            RowRecord rr = this.getRowRecord(row);
            if (rr == null || rr.isDefaultHeight()) {
                cv.setDimension(this.settings.getDefaultRowHeight());
                cv.setSize(this.settings.getDefaultRowHeight());
            } else if (rr.isCollapsed()) {
                cv.setHidden(true);
            } else {
                cv.setDimension(rr.getRowHeight());
                cv.setSize(rr.getRowHeight());
            }
            return cv;
        }
        catch (RowsExceededException e2) {
            cv.setDimension(this.settings.getDefaultRowHeight());
            cv.setSize(this.settings.getDefaultRowHeight());
            return cv;
        }
    }

    @Override
    public CellView getColumnView(int col) {
        ColumnInfoRecord cir = this.getColumnInfo(col);
        CellView cv = new CellView();
        if (cir != null) {
            cv.setDimension(cir.getWidth() / 256);
            cv.setSize(cir.getWidth());
            cv.setHidden(cir.getHidden());
            cv.setFormat(cir.getCellFormat());
        } else {
            cv.setDimension(this.settings.getDefaultColumnWidth() / 256);
            cv.setSize(this.settings.getDefaultColumnWidth() * 256);
        }
        return cv;
    }

    @Override
    public void addImage(WritableImage image) {
        boolean supported = false;
        java.io.File imageFile = image.getImageFile();
        String fileType = "?";
        if (imageFile != null) {
            String fileName = imageFile.getName();
            int fileTypeIndex = fileName.lastIndexOf(46);
            fileType = fileTypeIndex != -1 ? fileName.substring(fileTypeIndex + 1) : "";
            for (int i2 = 0; i2 < imageTypes.length && !supported; ++i2) {
                if (!fileType.equalsIgnoreCase(imageTypes[i2])) continue;
                supported = true;
            }
        } else {
            supported = true;
        }
        if (supported) {
            this.workbook.addDrawing(image);
            this.drawings.add(image);
            this.images.add(image);
        } else {
            StringBuffer message = new StringBuffer("Image type ");
            message.append(fileType);
            message.append(" not supported.  Supported types are ");
            message.append(imageTypes[0]);
            for (int i3 = 1; i3 < imageTypes.length; ++i3) {
                message.append(", ");
                message.append(imageTypes[i3]);
            }
            logger.warn(message.toString());
        }
    }

    @Override
    public int getNumberOfImages() {
        return this.images.size();
    }

    @Override
    public WritableImage getImage(int i2) {
        return (WritableImage)this.images.get(i2);
    }

    @Override
    public Image getDrawing(int i2) {
        return (Image)this.images.get(i2);
    }

    @Override
    public void removeImage(WritableImage wi) {
        this.drawings.remove(wi);
        this.images.remove(wi);
        this.drawingsModified = true;
        this.workbook.removeDrawing(wi);
    }

    private String validateName(String n2) {
        if (n2.length() > 31) {
            logger.warn("Sheet name " + n2 + " too long - truncating");
            n2 = n2.substring(0, 31);
        }
        if (n2.charAt(0) == '\'') {
            logger.warn("Sheet naming cannot start with ' - removing");
            n2 = n2.substring(1);
        }
        for (int i2 = 0; i2 < illegalSheetNameCharacters.length; ++i2) {
            String newname = n2.replace(illegalSheetNameCharacters[i2], '@');
            if (n2 != newname) {
                logger.warn(illegalSheetNameCharacters[i2] + " is not a valid character within a sheet name - replacing");
            }
            n2 = newname;
        }
        return n2;
    }

    void addDrawing(DrawingGroupObject o2) {
        this.drawings.add(o2);
        Assert.verify(!(o2 instanceof Drawing));
    }

    void removeDrawing(DrawingGroupObject o2) {
        int origSize = this.drawings.size();
        this.drawings.remove(o2);
        int newSize = this.drawings.size();
        this.drawingsModified = true;
        Assert.verify(newSize == origSize - 1);
    }

    void removeDataValidation(CellValue cv) {
        boolean result;
        if (this.dataValidation != null) {
            this.dataValidation.removeDataValidation(cv.getColumn(), cv.getRow());
        }
        if (this.validatedCells != null && !(result = this.validatedCells.remove(cv))) {
            logger.warn("Could not remove validated cell " + CellReferenceHelper.getCellReference(cv));
        }
    }

    @Override
    public int[] getRowPageBreaks() {
        int[] rb = new int[this.rowBreaks.size()];
        int pos = 0;
        Iterator i2 = this.rowBreaks.iterator();
        while (i2.hasNext()) {
            rb[pos] = (Integer)i2.next();
            ++pos;
        }
        return rb;
    }

    @Override
    public int[] getColumnPageBreaks() {
        int[] rb = new int[this.columnBreaks.size()];
        int pos = 0;
        Iterator i2 = this.columnBreaks.iterator();
        while (i2.hasNext()) {
            rb[pos] = (Integer)i2.next();
            ++pos;
        }
        return rb;
    }

    void addValidationCell(CellValue cv) {
        this.validatedCells.add(cv);
    }

    ComboBox getComboBox() {
        return this.comboBox;
    }

    void setComboBox(ComboBox cb) {
        this.comboBox = cb;
    }

    public DataValidation getDataValidation() {
        return this.dataValidation;
    }

    private void autosizeColumns() {
        for (Integer col : this.autosizedColumns) {
            this.autosizeColumn(col);
        }
    }

    private void autosizeColumn(int col) {
        int maxWidth = 0;
        ColumnInfoRecord cir = this.getColumnInfo(col);
        Font columnFont = cir.getCellFormat().getFont();
        Font defaultFont = WritableWorkbook.NORMAL_STYLE.getFont();
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            Cell cell = null;
            if (this.rows[i2] != null) {
                cell = this.rows[i2].getCell(col);
            }
            if (cell == null) continue;
            String contents = cell.getContents();
            Font font = cell.getCellFormat().getFont();
            Font activeFont = font.equals(defaultFont) ? columnFont : font;
            int pointSize = activeFont.getPointSize();
            int numChars = contents.length();
            if (activeFont.isItalic() || activeFont.getBoldWeight() > 400) {
                numChars += 2;
            }
            int points = numChars * pointSize;
            maxWidth = Math.max(maxWidth, points * 256);
        }
        cir.setWidth(maxWidth / defaultFont.getPointSize());
    }

    void importSheet(Sheet s2) {
        this.settings = new SheetSettings(s2.getSettings(), this);
        SheetCopier si = new SheetCopier(s2, this);
        si.setColumnFormats(this.columnFormats);
        si.setFormatRecords(this.formatRecords);
        si.setHyperlinks(this.hyperlinks);
        si.setMergedCells(this.mergedCells);
        si.setRowBreaks(this.rowBreaks);
        si.setColumnBreaks(this.columnBreaks);
        si.setSheetWriter(this.sheetWriter);
        si.setDrawings(this.drawings);
        si.setImages(this.images);
        si.setValidatedCells(this.validatedCells);
        si.importSheet();
        this.dataValidation = si.getDataValidation();
        this.comboBox = si.getComboBox();
        this.plsRecord = si.getPLSRecord();
        this.chartOnly = si.isChartOnly();
        this.buttonPropertySet = si.getButtonPropertySet();
        this.numRows = si.getRows();
        this.maxRowOutlineLevel = si.getMaxRowOutlineLevel();
        this.maxColumnOutlineLevel = si.getMaxColumnOutlineLevel();
    }

    @Override
    public void applySharedDataValidation(WritableCell c2, int extraCols, int extraRows) throws WriteException {
        if (c2.getWritableCellFeatures() == null || !c2.getWritableCellFeatures().hasDataValidation()) {
            logger.warn("Cannot extend data validation for " + CellReferenceHelper.getCellReference(c2.getColumn(), c2.getRow()) + " as it has no data validation");
            return;
        }
        int startColumn = c2.getColumn();
        int startRow = c2.getRow();
        int endRow = Math.min(this.numRows - 1, startRow + extraRows);
        for (int y = startRow; y <= endRow; ++y) {
            if (this.rows[y] == null) continue;
            int endCol = Math.min(this.rows[y].getMaxColumn() - 1, startColumn + extraCols);
            for (int x = startColumn; x <= endCol; ++x) {
                CellValue c22;
                if (x == startColumn && y == startRow || (c22 = this.rows[y].getCell(x)) == null || c22.getWritableCellFeatures() == null || !c22.getWritableCellFeatures().hasDataValidation()) continue;
                logger.warn("Cannot apply data validation from " + CellReferenceHelper.getCellReference(startColumn, startRow) + " to " + CellReferenceHelper.getCellReference(startColumn + extraCols, startRow + extraRows) + " as cell " + CellReferenceHelper.getCellReference(x, y) + " already has a data validation");
                return;
            }
        }
        WritableCellFeatures sourceDataValidation = c2.getWritableCellFeatures();
        sourceDataValidation.getDVParser().extendCellValidation(extraCols, extraRows);
        for (int y = startRow; y <= startRow + extraRows; ++y) {
            RowRecord rowrec = this.getRowRecord(y);
            for (int x = startColumn; x <= startColumn + extraCols; ++x) {
                if (x == startColumn && y == startRow) continue;
                CellValue c23 = rowrec.getCell(x);
                if (c23 == null) {
                    Blank b2 = new Blank(x, y);
                    WritableCellFeatures validation = new WritableCellFeatures();
                    validation.shareDataValidation(sourceDataValidation);
                    b2.setCellFeatures(validation);
                    this.addCell(b2);
                    continue;
                }
                WritableCellFeatures validation = c23.getWritableCellFeatures();
                if (validation != null) {
                    validation.shareDataValidation(sourceDataValidation);
                    continue;
                }
                validation = new WritableCellFeatures();
                validation.shareDataValidation(sourceDataValidation);
                c23.setCellFeatures(validation);
            }
        }
    }

    @Override
    public void removeSharedDataValidation(WritableCell cell) throws WriteException {
        WritableCellFeatures wcf = cell.getWritableCellFeatures();
        if (wcf == null || !wcf.hasDataValidation()) {
            return;
        }
        DVParser dvp = wcf.getDVParser();
        if (!dvp.extendedCellsValidation()) {
            wcf.removeDataValidation();
            return;
        }
        if (dvp.extendedCellsValidation() && (cell.getColumn() != dvp.getFirstColumn() || cell.getRow() != dvp.getFirstRow())) {
            logger.warn("Cannot remove data validation from " + CellReferenceHelper.getCellReference(dvp.getFirstColumn(), dvp.getFirstRow()) + "-" + CellReferenceHelper.getCellReference(dvp.getLastColumn(), dvp.getLastRow()) + " because the selected cell " + CellReferenceHelper.getCellReference(cell) + " is not the top left cell in the range");
            return;
        }
        for (int y = dvp.getFirstRow(); y <= dvp.getLastRow(); ++y) {
            for (int x = dvp.getFirstColumn(); x <= dvp.getLastColumn(); ++x) {
                CellValue c2 = this.rows[y].getCell(x);
                if (c2 == null) continue;
                c2.getWritableCellFeatures().removeSharedDataValidation();
                c2.removeCellFeatures();
            }
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeSharedDataValidation(dvp.getFirstColumn(), dvp.getFirstRow(), dvp.getLastColumn(), dvp.getLastRow());
        }
    }

    private static class ColumnInfoComparator
    implements Comparator {
        private ColumnInfoComparator() {
        }

        @Override
        public boolean equals(Object o2) {
            return o2 == this;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            Assert.verify(o1 instanceof ColumnInfoRecord);
            Assert.verify(o2 instanceof ColumnInfoRecord);
            ColumnInfoRecord ci1 = (ColumnInfoRecord)o1;
            ColumnInfoRecord ci2 = (ColumnInfoRecord)o2;
            return ci1.getColumn() - ci2.getColumn();
        }
    }
}

