/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import java.util.Stack;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Function;
import jxl.biff.formula.Operator;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;
import jxl.common.Assert;
import jxl.common.Logger;

class BuiltInFunction
extends Operator
implements ParsedThing {
    private static Logger logger = Logger.getLogger(BuiltInFunction.class);
    private Function function;
    private WorkbookSettings settings;

    public BuiltInFunction(WorkbookSettings ws) {
        this.settings = ws;
    }

    public BuiltInFunction(Function f2, WorkbookSettings ws) {
        this.function = f2;
        this.settings = ws;
    }

    @Override
    public int read(byte[] data, int pos) {
        int index = IntegerHelper.getInt(data[pos], data[pos + 1]);
        this.function = Function.getFunction(index);
        Assert.verify(this.function != Function.UNKNOWN, "function code " + index);
        return 2;
    }

    @Override
    public void getOperands(Stack s2) {
        int i2;
        ParseItem[] items = new ParseItem[this.function.getNumArgs()];
        for (i2 = this.function.getNumArgs() - 1; i2 >= 0; --i2) {
            ParseItem pi;
            items[i2] = pi = (ParseItem)s2.pop();
        }
        for (i2 = 0; i2 < this.function.getNumArgs(); ++i2) {
            this.add(items[i2]);
        }
    }

    @Override
    public void getString(StringBuffer buf) {
        buf.append(this.function.getName(this.settings));
        buf.append('(');
        int numArgs = this.function.getNumArgs();
        if (numArgs > 0) {
            ParseItem[] operands = this.getOperands();
            operands[0].getString(buf);
            for (int i2 = 1; i2 < numArgs; ++i2) {
                buf.append(',');
                operands[i2].getString(buf);
            }
        }
        buf.append(')');
    }

    @Override
    public void adjustRelativeCellReferences(int colAdjust, int rowAdjust) {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].adjustRelativeCellReferences(colAdjust, rowAdjust);
        }
    }

    @Override
    void columnInserted(int sheetIndex, int col, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].columnInserted(sheetIndex, col, currentSheet);
        }
    }

    @Override
    void columnRemoved(int sheetIndex, int col, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].columnRemoved(sheetIndex, col, currentSheet);
        }
    }

    @Override
    void rowInserted(int sheetIndex, int row, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].rowInserted(sheetIndex, row, currentSheet);
        }
    }

    @Override
    void rowRemoved(int sheetIndex, int row, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].rowRemoved(sheetIndex, row, currentSheet);
        }
    }

    @Override
    void handleImportedCellReferences() {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].handleImportedCellReferences();
        }
    }

    @Override
    byte[] getBytes() {
        ParseItem[] operands = this.getOperands();
        byte[] data = new byte[]{};
        for (int i2 = 0; i2 < operands.length; ++i2) {
            byte[] opdata = operands[i2].getBytes();
            byte[] newdata = new byte[data.length + opdata.length];
            System.arraycopy(data, 0, newdata, 0, data.length);
            System.arraycopy(opdata, 0, newdata, data.length, opdata.length);
            data = newdata;
        }
        byte[] newdata = new byte[data.length + 3];
        System.arraycopy(data, 0, newdata, 0, data.length);
        newdata[data.length] = !this.useAlternateCode() ? Token.FUNCTION.getCode() : Token.FUNCTION.getCode2();
        IntegerHelper.getTwoBytes(this.function.getCode(), newdata, data.length + 1);
        return newdata;
    }

    @Override
    int getPrecedence() {
        return 3;
    }
}

