/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.io.UnsupportedEncodingException;
import jxl.WorkbookSettings;
import jxl.common.Logger;

public final class StringHelper {
    private static Logger logger = Logger.getLogger(StringHelper.class);
    public static String UNICODE_ENCODING = "UnicodeLittle";

    private StringHelper() {
    }

    public static byte[] getBytes(String s2) {
        return s2.getBytes();
    }

    public static byte[] getBytes(String s2, WorkbookSettings ws) {
        try {
            return s2.getBytes(ws.getEncoding());
        }
        catch (UnsupportedEncodingException e2) {
            return null;
        }
    }

    public static byte[] getUnicodeBytes(String s2) {
        try {
            byte[] b2 = s2.getBytes(UNICODE_ENCODING);
            if (b2.length == s2.length() * 2 + 2) {
                byte[] b22 = new byte[b2.length - 2];
                System.arraycopy(b2, 2, b22, 0, b22.length);
                b2 = b22;
            }
            return b2;
        }
        catch (UnsupportedEncodingException e2) {
            return null;
        }
    }

    public static void getBytes(String s2, byte[] d2, int pos) {
        byte[] b2 = StringHelper.getBytes(s2);
        System.arraycopy(b2, 0, d2, pos, b2.length);
    }

    public static void getUnicodeBytes(String s2, byte[] d2, int pos) {
        byte[] b2 = StringHelper.getUnicodeBytes(s2);
        System.arraycopy(b2, 0, d2, pos, b2.length);
    }

    public static String getString(byte[] d2, int length, int pos, WorkbookSettings ws) {
        if (length == 0) {
            return "";
        }
        try {
            return new String(d2, pos, length, ws.getEncoding());
        }
        catch (UnsupportedEncodingException e2) {
            logger.warn(e2.toString());
            return "";
        }
    }

    public static String getUnicodeString(byte[] d2, int length, int pos) {
        try {
            byte[] b2 = new byte[length * 2];
            System.arraycopy(d2, pos, b2, 0, length * 2);
            return new String(b2, UNICODE_ENCODING);
        }
        catch (UnsupportedEncodingException e2) {
            return "";
        }
    }

    public static final String replace(String input, String search, String replace) {
        String fmtstr = input;
        int pos = fmtstr.indexOf(search);
        while (pos != -1) {
            StringBuffer tmp = new StringBuffer(fmtstr.substring(0, pos));
            tmp.append(replace);
            tmp.append(fmtstr.substring(pos + search.length()));
            fmtstr = tmp.toString();
            pos = fmtstr.indexOf(search, pos + replace.length());
        }
        return fmtstr;
    }
}

