/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.FontRecord;
import jxl.biff.IndexMapping;
import jxl.common.Assert;
import jxl.write.biff.File;

public class Fonts {
    private ArrayList fonts = new ArrayList();
    private static final int numDefaultFonts = 4;

    public void addFont(FontRecord f2) {
        if (!f2.isInitialized()) {
            int pos = this.fonts.size();
            if (pos >= 4) {
                ++pos;
            }
            f2.initialize(pos);
            this.fonts.add(f2);
        }
    }

    public FontRecord getFont(int index) {
        if (index > 4) {
            --index;
        }
        return (FontRecord)this.fonts.get(index);
    }

    public void write(File outputFile) throws IOException {
        Iterator i2 = this.fonts.iterator();
        FontRecord font = null;
        while (i2.hasNext()) {
            font = (FontRecord)i2.next();
            outputFile.write(font);
        }
    }

    IndexMapping rationalize() {
        IndexMapping mapping = new IndexMapping(this.fonts.size() + 1);
        ArrayList<FontRecord> newfonts = new ArrayList<FontRecord>();
        FontRecord fr3 = null;
        int numremoved = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            fr3 = (FontRecord)this.fonts.get(i2);
            newfonts.add(fr3);
            mapping.setMapping(fr3.getFontIndex(), fr3.getFontIndex());
        }
        Iterator it = null;
        FontRecord fr2 = null;
        boolean duplicate = false;
        for (int i3 = 4; i3 < this.fonts.size(); ++i3) {
            fr3 = (FontRecord)this.fonts.get(i3);
            duplicate = false;
            it = newfonts.iterator();
            while (it.hasNext() && !duplicate) {
                fr2 = (FontRecord)it.next();
                if (!fr3.equals(fr2)) continue;
                duplicate = true;
                mapping.setMapping(fr3.getFontIndex(), mapping.getNewIndex(fr2.getFontIndex()));
                ++numremoved;
            }
            if (duplicate) continue;
            newfonts.add(fr3);
            int newindex = fr3.getFontIndex() - numremoved;
            Assert.verify(newindex > 4);
            mapping.setMapping(fr3.getFontIndex(), newindex);
        }
        for (FontRecord fr3 : newfonts) {
            fr3.initialize(mapping.getNewIndex(fr3.getFontIndex()));
        }
        this.fonts = newfonts;
        return mapping;
    }
}

