/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.BASE64MailboxDecoder;
import java.util.Vector;

public class Namespaces {
    public Namespace[] personal;
    public Namespace[] otherUsers;
    public Namespace[] shared;

    public Namespaces(Response r2) throws ProtocolException {
        this.personal = this.getNamespaces(r2);
        this.otherUsers = this.getNamespaces(r2);
        this.shared = this.getNamespaces(r2);
    }

    private Namespace[] getNamespaces(Response r2) throws ProtocolException {
        r2.skipSpaces();
        if (r2.peekByte() == 40) {
            Vector<Namespace> v = new Vector<Namespace>();
            r2.readByte();
            do {
                Namespace ns = new Namespace(r2);
                v.addElement(ns);
            } while (r2.peekByte() != 41);
            r2.readByte();
            Object[] nsa = new Namespace[v.size()];
            v.copyInto(nsa);
            return nsa;
        }
        String s2 = r2.readAtom();
        if (s2 == null) {
            throw new ProtocolException("Expected NIL, got null");
        }
        if (!s2.equalsIgnoreCase("NIL")) {
            throw new ProtocolException("Expected NIL, got " + s2);
        }
        return null;
    }

    public static class Namespace {
        public String prefix;
        public char delimiter;

        public Namespace(Response r2) throws ProtocolException {
            if (r2.readByte() != 40) {
                throw new ProtocolException("Missing '(' at start of Namespace");
            }
            this.prefix = BASE64MailboxDecoder.decode(r2.readString());
            r2.skipSpaces();
            if (r2.peekByte() == 34) {
                r2.readByte();
                this.delimiter = (char)r2.readByte();
                if (this.delimiter == '\\') {
                    this.delimiter = (char)r2.readByte();
                }
                if (r2.readByte() != 34) {
                    throw new ProtocolException("Missing '\"' at end of QUOTED_CHAR");
                }
            } else {
                String s2 = r2.readAtom();
                if (s2 == null) {
                    throw new ProtocolException("Expected NIL, got null");
                }
                if (!s2.equalsIgnoreCase("NIL")) {
                    throw new ProtocolException("Expected NIL, got " + s2);
                }
                this.delimiter = '\u0000';
            }
            if (r2.peekByte() != 41) {
                r2.skipSpaces();
                r2.readString();
                r2.skipSpaces();
                r2.readStringList();
            }
            if (r2.readByte() != 41) {
                throw new ProtocolException("Missing ')' at end of Namespace");
            }
        }
    }
}

