/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.FLAGS;
import com.sun.mail.imap.protocol.IMAPResponse;
import javax.mail.Flags;

public class MailboxInfo {
    public Flags availableFlags = null;
    public Flags permanentFlags = null;
    public int total = -1;
    public int recent = -1;
    public int first = -1;
    public long uidvalidity = -1L;
    public long uidnext = -1L;
    public int mode;

    public MailboxInfo(Response[] r2) throws ParsingException {
        for (int i2 = 0; i2 < r2.length; ++i2) {
            if (r2[i2] == null || !(r2[i2] instanceof IMAPResponse)) continue;
            IMAPResponse ir = (IMAPResponse)r2[i2];
            if (ir.keyEquals("EXISTS")) {
                this.total = ir.getNumber();
                r2[i2] = null;
                continue;
            }
            if (ir.keyEquals("RECENT")) {
                this.recent = ir.getNumber();
                r2[i2] = null;
                continue;
            }
            if (ir.keyEquals("FLAGS")) {
                this.availableFlags = new FLAGS(ir);
                r2[i2] = null;
                continue;
            }
            if (!ir.isUnTagged() || !ir.isOK()) continue;
            ir.skipSpaces();
            if (ir.readByte() != 91) {
                ir.reset();
                continue;
            }
            boolean handled = true;
            String s2 = ir.readAtom();
            if (s2.equalsIgnoreCase("UNSEEN")) {
                this.first = ir.readNumber();
            } else if (s2.equalsIgnoreCase("UIDVALIDITY")) {
                this.uidvalidity = ir.readLong();
            } else if (s2.equalsIgnoreCase("PERMANENTFLAGS")) {
                this.permanentFlags = new FLAGS(ir);
            } else if (s2.equalsIgnoreCase("UIDNEXT")) {
                this.uidnext = ir.readLong();
            } else {
                handled = false;
            }
            if (handled) {
                r2[i2] = null;
                continue;
            }
            ir.reset();
        }
        if (this.permanentFlags == null) {
            this.permanentFlags = this.availableFlags != null ? new Flags(this.availableFlags) : new Flags();
        }
    }
}

