/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.util.ASCIIUtility;
import java.io.IOException;
import java.util.Vector;

public class IMAPResponse
extends Response {
    private String key;
    private int number;

    public IMAPResponse(Protocol c2) throws IOException, ProtocolException {
        super(c2);
        this.init();
    }

    private void init() throws IOException, ProtocolException {
        if (!(!this.isUnTagged() || this.isOK() || this.isNO() || this.isBAD() || this.isBYE())) {
            this.key = this.readAtom();
            try {
                this.number = Integer.parseInt(this.key);
                this.key = this.readAtom();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public IMAPResponse(IMAPResponse r2) {
        super(r2);
        this.key = r2.key;
        this.number = r2.number;
    }

    public IMAPResponse(String r2) throws IOException, ProtocolException {
        super(r2);
        this.init();
    }

    public String[] readSimpleList() {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            return null;
        }
        ++this.index;
        Vector<String> v = new Vector<String>();
        int start = this.index;
        while (this.buffer[this.index] != 41) {
            if (this.buffer[this.index] == 32) {
                v.addElement(ASCIIUtility.toString(this.buffer, start, this.index));
                start = this.index + 1;
            }
            ++this.index;
        }
        if (this.index > start) {
            v.addElement(ASCIIUtility.toString(this.buffer, start, this.index));
        }
        ++this.index;
        int size = v.size();
        if (size > 0) {
            Object[] s2 = new String[size];
            v.copyInto(s2);
            return s2;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public boolean keyEquals(String k2) {
        return this.key != null && this.key.equalsIgnoreCase(k2);
    }

    public int getNumber() {
        return this.number;
    }
}

