/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser.clipper;

import com.itextpdf.text.pdf.parser.clipper.Point;
import com.itextpdf.text.pdf.parser.clipper.PolyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
extends ArrayList<Point.LongPoint> {
    private static final long serialVersionUID = -7120161578077546673L;

    private static OutPt excludeOp(OutPt op) {
        OutPt result = op.prev;
        result.next = op.next;
        op.next.prev = result;
        result.idx = 0;
        return result;
    }

    public Path() {
    }

    public Path(Point.LongPoint[] points) {
        this();
        for (Point.LongPoint point : points) {
            this.add(point);
        }
    }

    public Path(int cnt) {
        super(cnt);
    }

    public Path(Collection<? extends Point.LongPoint> c2) {
        super(c2);
    }

    public double area() {
        int cnt = this.size();
        if (cnt < 3) {
            return 0.0;
        }
        double a2 = 0.0;
        int i2 = 0;
        int j2 = cnt - 1;
        while (i2 < cnt) {
            a2 += ((double)((Point.LongPoint)this.get(j2)).getX() + (double)((Point.LongPoint)this.get(i2)).getX()) * ((double)((Point.LongPoint)this.get(j2)).getY() - (double)((Point.LongPoint)this.get(i2)).getY());
            j2 = i2++;
        }
        return -a2 * 0.5;
    }

    public Path cleanPolygon() {
        return this.cleanPolygon(1.415);
    }

    public Path cleanPolygon(double distance) {
        int i2;
        int cnt = this.size();
        if (cnt == 0) {
            return new Path();
        }
        OutPt[] outPts = new OutPt[cnt];
        for (i2 = 0; i2 < cnt; ++i2) {
            outPts[i2] = new OutPt();
        }
        for (i2 = 0; i2 < cnt; ++i2) {
            outPts[i2].pt = (Point.LongPoint)this.get(i2);
            outPts[i2].next = outPts[(i2 + 1) % cnt];
            outPts[i2].next.prev = outPts[i2];
            outPts[i2].idx = 0;
        }
        double distSqrd = distance * distance;
        OutPt op = outPts[0];
        while (op.idx == 0 && op.next != op.prev) {
            if (Point.arePointsClose(op.pt, op.prev.pt, distSqrd)) {
                op = Path.excludeOp(op);
                --cnt;
                continue;
            }
            if (Point.arePointsClose(op.prev.pt, op.next.pt, distSqrd)) {
                Path.excludeOp(op.next);
                op = Path.excludeOp(op);
                cnt -= 2;
                continue;
            }
            if (Point.slopesNearCollinear(op.prev.pt, op.pt, op.next.pt, distSqrd)) {
                op = Path.excludeOp(op);
                --cnt;
                continue;
            }
            op.idx = 1;
            op = op.next;
        }
        if (cnt < 3) {
            cnt = 0;
        }
        Path result = new Path(cnt);
        for (int i3 = 0; i3 < cnt; ++i3) {
            result.add(op.pt);
            op = op.next;
        }
        outPts = null;
        return result;
    }

    public int isPointInPolygon(Point.LongPoint pt) {
        int result = 0;
        int cnt = this.size();
        if (cnt < 3) {
            return 0;
        }
        Point.LongPoint ip = (Point.LongPoint)this.get(0);
        for (int i2 = 1; i2 <= cnt; ++i2) {
            Point.LongPoint ipNext;
            Point.LongPoint longPoint = ipNext = i2 == cnt ? (Point.LongPoint)this.get(0) : (Point.LongPoint)this.get(i2);
            if (ipNext.getY() == pt.getY() && (ipNext.getX() == pt.getX() || ip.getY() == pt.getY() && ipNext.getX() > pt.getX() == ip.getX() < pt.getX())) {
                return -1;
            }
            if (ip.getY() < pt.getY() != ipNext.getY() < pt.getY()) {
                double d2;
                if (ip.getX() >= pt.getX()) {
                    if (ipNext.getX() > pt.getX()) {
                        result = 1 - result;
                    } else {
                        d2 = (double)(ip.getX() - pt.getX()) * (double)(ipNext.getY() - pt.getY()) - (double)(ipNext.getX() - pt.getX()) * (double)(ip.getY() - pt.getY());
                        if (d2 == 0.0) {
                            return -1;
                        }
                        if (d2 > 0.0 == ipNext.getY() > ip.getY()) {
                            result = 1 - result;
                        }
                    }
                } else if (ipNext.getX() > pt.getX()) {
                    d2 = (double)(ip.getX() - pt.getX()) * (double)(ipNext.getY() - pt.getY()) - (double)(ipNext.getX() - pt.getX()) * (double)(ip.getY() - pt.getY());
                    if (d2 == 0.0) {
                        return -1;
                    }
                    if (d2 > 0.0 == ipNext.getY() > ip.getY()) {
                        result = 1 - result;
                    }
                }
            }
            ip = ipNext;
        }
        return result;
    }

    public boolean orientation() {
        return this.area() >= 0.0;
    }

    public void reverse() {
        Collections.reverse(this);
    }

    public Path TranslatePath(Point.LongPoint delta) {
        Path outPath = new Path(this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            outPath.add(new Point.LongPoint(((Point.LongPoint)this.get(i2)).getX() + delta.getX(), ((Point.LongPoint)this.get(i2)).getY() + delta.getY()));
        }
        return outPath;
    }

    static class OutRec {
        int Idx;
        boolean isHole;
        boolean isOpen;
        OutRec firstLeft;
        protected OutPt pts;
        OutPt bottomPt;
        PolyNode polyNode;

        OutRec() {
        }

        public double area() {
            OutPt op = this.pts;
            if (op == null) {
                return 0.0;
            }
            double a2 = 0.0;
            do {
                a2 += (double)(op.prev.getPt().getX() + op.getPt().getX()) * (double)(op.prev.getPt().getY() - op.getPt().getY());
            } while ((op = op.next) != this.pts);
            return a2 * 0.5;
        }

        public void fixHoleLinkage() {
            if (this.firstLeft == null || this.isHole != this.firstLeft.isHole && this.firstLeft.pts != null) {
                return;
            }
            OutRec orfl = this.firstLeft;
            while (orfl != null && (orfl.isHole == this.isHole || orfl.pts == null)) {
                orfl = orfl.firstLeft;
            }
            this.firstLeft = orfl;
        }

        public OutPt getPoints() {
            return this.pts;
        }

        public OutRec parseFirstLeft() {
            OutRec ret = this;
            while (ret != null && ret.pts == null) {
                ret = ret.firstLeft;
            }
            return ret;
        }

        public void setPoints(OutPt pts) {
            this.pts = pts;
        }
    }

    protected static class Maxima {
        protected long X;
        protected Maxima Next;
        protected Maxima Prev;

        protected Maxima() {
        }
    }

    static class OutPt {
        int idx;
        protected Point.LongPoint pt;
        OutPt next;
        OutPt prev;

        OutPt() {
        }

        public static OutRec getLowerMostRec(OutRec outRec1, OutRec outRec2) {
            if (outRec1.bottomPt == null) {
                outRec1.bottomPt = outRec1.pts.getBottomPt();
            }
            if (outRec2.bottomPt == null) {
                outRec2.bottomPt = outRec2.pts.getBottomPt();
            }
            OutPt bPt1 = outRec1.bottomPt;
            OutPt bPt2 = outRec2.bottomPt;
            if (bPt1.getPt().getY() > bPt2.getPt().getY()) {
                return outRec1;
            }
            if (bPt1.getPt().getY() < bPt2.getPt().getY()) {
                return outRec2;
            }
            if (bPt1.getPt().getX() < bPt2.getPt().getX()) {
                return outRec1;
            }
            if (bPt1.getPt().getX() > bPt2.getPt().getX()) {
                return outRec2;
            }
            if (bPt1.next == bPt1) {
                return outRec2;
            }
            if (bPt2.next == bPt2) {
                return outRec1;
            }
            if (OutPt.isFirstBottomPt(bPt1, bPt2)) {
                return outRec1;
            }
            return outRec2;
        }

        private static boolean isFirstBottomPt(OutPt btmPt1, OutPt btmPt2) {
            OutPt p2 = btmPt1.prev;
            while (p2.getPt().equals(btmPt1.getPt()) && !p2.equals(btmPt1)) {
                p2 = p2.prev;
            }
            double dx1p = Math.abs(Point.LongPoint.getDeltaX(btmPt1.getPt(), p2.getPt()));
            p2 = btmPt1.next;
            while (p2.getPt().equals(btmPt1.getPt()) && !p2.equals(btmPt1)) {
                p2 = p2.next;
            }
            double dx1n = Math.abs(Point.LongPoint.getDeltaX(btmPt1.getPt(), p2.getPt()));
            p2 = btmPt2.prev;
            while (p2.getPt().equals(btmPt2.getPt()) && !p2.equals(btmPt2)) {
                p2 = p2.prev;
            }
            double dx2p = Math.abs(Point.LongPoint.getDeltaX(btmPt2.getPt(), p2.getPt()));
            p2 = btmPt2.next;
            while (p2.getPt().equals(btmPt2.getPt()) && p2.equals(btmPt2)) {
                p2 = p2.next;
            }
            double dx2n = Math.abs(Point.LongPoint.getDeltaX(btmPt2.getPt(), p2.getPt()));
            return dx1p >= dx2p && dx1p >= dx2n || dx1n >= dx2p && dx1n >= dx2n;
        }

        public OutPt duplicate(boolean InsertAfter) {
            OutPt result = new OutPt();
            result.setPt(new Point.LongPoint(this.getPt()));
            result.idx = this.idx;
            if (InsertAfter) {
                result.next = this.next;
                result.prev = this;
                this.next.prev = result;
                this.next = result;
            } else {
                result.prev = this.prev;
                result.next = this;
                this.prev.next = result;
                this.prev = result;
            }
            return result;
        }

        OutPt getBottomPt() {
            OutPt dups = null;
            OutPt p2 = this.next;
            OutPt pp = this;
            while (p2 != pp) {
                if (p2.getPt().getY() > pp.getPt().getY()) {
                    pp = p2;
                    dups = null;
                } else if (p2.getPt().getY() == pp.getPt().getY() && p2.getPt().getX() <= pp.getPt().getX()) {
                    if (p2.getPt().getX() < pp.getPt().getX()) {
                        dups = null;
                        pp = p2;
                    } else if (p2.next != pp && p2.prev != pp) {
                        dups = p2;
                    }
                }
                p2 = p2.next;
            }
            if (dups != null) {
                while (dups != p2) {
                    if (!OutPt.isFirstBottomPt(p2, dups)) {
                        pp = dups;
                    }
                    dups = dups.next;
                    while (!dups.getPt().equals(pp.getPt())) {
                        dups = dups.next;
                    }
                }
            }
            return pp;
        }

        public int getPointCount() {
            int result = 0;
            OutPt p2 = this;
            do {
                ++result;
            } while ((p2 = p2.next) != this && p2 != null);
            return result;
        }

        public Point.LongPoint getPt() {
            return this.pt;
        }

        public void reversePolyPtLinks() {
            OutPt pp2;
            OutPt pp1 = this;
            do {
                pp2 = pp1.next;
                pp1.next = pp1.prev;
                pp1.prev = pp2;
            } while ((pp1 = pp2) != this);
        }

        public void setPt(Point.LongPoint pt) {
            this.pt = pt;
        }
    }

    static class Join {
        OutPt outPt1;
        OutPt outPt2;
        private Point.LongPoint offPt;

        Join() {
        }

        public Point.LongPoint getOffPt() {
            return this.offPt;
        }

        public void setOffPt(Point.LongPoint offPt) {
            this.offPt = offPt;
        }
    }
}

