/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.AccessibleElementId;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.api.Indentable;
import com.itextpdf.text.api.Spaceable;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paragraph
extends Phrase
implements Indentable,
Spaceable,
IAccessibleElement {
    private static final long serialVersionUID = 7852314969733375514L;
    protected int alignment = -1;
    protected float indentationLeft;
    protected float indentationRight;
    private float firstLineIndent = 0.0f;
    protected float spacingBefore;
    protected float spacingAfter;
    private float extraParagraphSpace = 0.0f;
    protected boolean keeptogether = false;
    protected float paddingTop;
    protected PdfName role = PdfName.P;
    protected HashMap<PdfName, PdfObject> accessibleAttributes = null;
    private AccessibleElementId id = null;

    public Paragraph() {
    }

    public Paragraph(float leading) {
        super(leading);
    }

    public Paragraph(Chunk chunk) {
        super(chunk);
    }

    public Paragraph(float leading, Chunk chunk) {
        super(leading, chunk);
    }

    public Paragraph(String string) {
        super(string);
    }

    public Paragraph(String string, Font font) {
        super(string, font);
    }

    public Paragraph(float leading, String string) {
        super(leading, string);
    }

    public Paragraph(float leading, String string, Font font) {
        super(leading, string, font);
    }

    public Paragraph(Phrase phrase) {
        super(phrase);
        if (phrase instanceof Paragraph) {
            Paragraph p2 = (Paragraph)phrase;
            this.setAlignment(p2.alignment);
            this.setIndentationLeft(p2.getIndentationLeft());
            this.setIndentationRight(p2.getIndentationRight());
            this.setFirstLineIndent(p2.getFirstLineIndent());
            this.setSpacingAfter(p2.getSpacingAfter());
            this.setSpacingBefore(p2.getSpacingBefore());
            this.setExtraParagraphSpace(p2.getExtraParagraphSpace());
            this.setRole(p2.role);
            this.id = p2.getId();
            if (p2.accessibleAttributes != null) {
                this.accessibleAttributes = new HashMap<PdfName, PdfObject>(p2.accessibleAttributes);
            }
        }
    }

    public Paragraph cloneShallow(boolean spacingBefore) {
        Paragraph copy = new Paragraph();
        copy.setFont(this.getFont());
        copy.setAlignment(this.getAlignment());
        copy.setLeading(this.getLeading(), this.multipliedLeading);
        copy.setIndentationLeft(this.getIndentationLeft());
        copy.setIndentationRight(this.getIndentationRight());
        copy.setFirstLineIndent(this.getFirstLineIndent());
        copy.setSpacingAfter(this.getSpacingAfter());
        if (spacingBefore) {
            copy.setSpacingBefore(this.getSpacingBefore());
        }
        copy.setExtraParagraphSpace(this.getExtraParagraphSpace());
        copy.setRole(this.role);
        copy.id = this.getId();
        if (this.accessibleAttributes != null) {
            copy.accessibleAttributes = new HashMap<PdfName, PdfObject>(this.accessibleAttributes);
        }
        copy.setTabSettings(this.getTabSettings());
        copy.setKeepTogether(this.getKeepTogether());
        return copy;
    }

    public java.util.List<Element> breakUp() {
        ArrayList<Element> list = new ArrayList<Element>();
        ArrayList tmp = null;
        for (Element e2 : this) {
            if (e2.type() == 14 || e2.type() == 23 || e2.type() == 12) {
                if (tmp != null && tmp.size() > 0) {
                    ((Paragraph)tmp).setSpacingAfter(0.0f);
                    list.add((Element)((Object)tmp));
                    tmp = this.cloneShallow(false);
                }
                if (list.size() == 0) {
                    switch (e2.type()) {
                        case 23: {
                            ((PdfPTable)e2).setSpacingBefore(this.getSpacingBefore());
                            break;
                        }
                        case 12: {
                            ((Paragraph)e2).setSpacingBefore(this.getSpacingBefore());
                            break;
                        }
                        case 14: {
                            ListItem firstItem = ((List)e2).getFirstItem();
                            if (firstItem == null) break;
                            firstItem.setSpacingBefore(this.getSpacingBefore());
                            break;
                        }
                    }
                }
                list.add(e2);
                continue;
            }
            if (tmp == null) {
                tmp = this.cloneShallow(list.size() == 0);
            }
            ((Paragraph)tmp).add(e2);
        }
        if (tmp != null && tmp.size() > 0) {
            list.add((Element)((Object)tmp));
        }
        if (list.size() != 0) {
            Element lastElement = (Element)list.get(list.size() - 1);
            switch (lastElement.type()) {
                case 23: {
                    ((PdfPTable)lastElement).setSpacingAfter(this.getSpacingAfter());
                    break;
                }
                case 12: {
                    ((Paragraph)lastElement).setSpacingAfter(this.getSpacingAfter());
                    break;
                }
                case 14: {
                    ListItem lastItem = ((List)lastElement).getLastItem();
                    if (lastItem == null) break;
                    lastItem.setSpacingAfter(this.getSpacingAfter());
                    break;
                }
            }
        }
        return list;
    }

    @Override
    public int type() {
        return 12;
    }

    @Override
    public boolean add(Element o2) {
        if (o2 instanceof List) {
            List list = (List)o2;
            list.setIndentationLeft(list.getIndentationLeft() + this.indentationLeft);
            list.setIndentationRight(this.indentationRight);
            return super.add(list);
        }
        if (o2 instanceof Image) {
            super.addSpecial(o2);
            return true;
        }
        if (o2 instanceof Paragraph) {
            super.addSpecial(o2);
            return true;
        }
        return super.add(o2);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    @Override
    public void setIndentationLeft(float indentation) {
        this.indentationLeft = indentation;
    }

    @Override
    public void setIndentationRight(float indentation) {
        this.indentationRight = indentation;
    }

    public void setFirstLineIndent(float firstLineIndent) {
        this.firstLineIndent = firstLineIndent;
    }

    @Override
    public void setSpacingBefore(float spacing) {
        this.spacingBefore = spacing;
    }

    @Override
    public void setSpacingAfter(float spacing) {
        this.spacingAfter = spacing;
    }

    public void setKeepTogether(boolean keeptogether) {
        this.keeptogether = keeptogether;
    }

    public boolean getKeepTogether() {
        return this.keeptogether;
    }

    public int getAlignment() {
        return this.alignment;
    }

    @Override
    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    @Override
    public float getIndentationRight() {
        return this.indentationRight;
    }

    public float getFirstLineIndent() {
        return this.firstLineIndent;
    }

    @Override
    public float getSpacingBefore() {
        return this.spacingBefore;
    }

    @Override
    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float extraParagraphSpace) {
        this.extraParagraphSpace = extraParagraphSpace;
    }

    @Deprecated
    public float spacingBefore() {
        return this.getSpacingBefore();
    }

    @Deprecated
    public float spacingAfter() {
        return this.spacingAfter;
    }

    @Override
    public PdfObject getAccessibleAttribute(PdfName key) {
        if (this.accessibleAttributes != null) {
            return this.accessibleAttributes.get(key);
        }
        return null;
    }

    @Override
    public void setAccessibleAttribute(PdfName key, PdfObject value) {
        if (this.accessibleAttributes == null) {
            this.accessibleAttributes = new HashMap();
        }
        this.accessibleAttributes.put(key, value);
    }

    @Override
    public HashMap<PdfName, PdfObject> getAccessibleAttributes() {
        return this.accessibleAttributes;
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
    }

    @Override
    public AccessibleElementId getId() {
        if (this.id == null) {
            this.id = new AccessibleElementId();
        }
        return this.id;
    }

    @Override
    public void setId(AccessibleElementId id) {
        this.id = id;
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public float getPaddingTop() {
        return this.paddingTop;
    }

    @Override
    public void setPaddingTop(float paddingTop) {
        this.paddingTop = paddingTop;
    }
}

