/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.NullMask;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.UsageMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Table {
    private static final Log LOG = LogFactory.getLog(Table.class);
    public static final byte TYPE_SYSTEM = 83;
    public static final byte TYPE_USER = 78;
    private ByteBuffer _buffer;
    private byte _tableType;
    private int _currentRowInPage;
    private int _indexCount;
    private short _lastRowStart;
    private int _rowCount;
    private int _tableDefPageNumber;
    private short _rowsLeftOnPage = 0;
    private short _rowStart;
    private short _columnCount;
    private JetFormat _format;
    private List _columns = new ArrayList();
    private List _indexes = new ArrayList();
    private PageChannel _pageChannel;
    private UsageMap _ownedPages;
    private UsageMap _freeSpacePages;

    Table() throws IOException {
        this._pageChannel = new PageChannel(null, JetFormat.VERSION_4);
    }

    protected Table(ByteBuffer buffer, PageChannel pageChannel, JetFormat format, int pageNumber) throws IOException {
        int nextPage;
        this._buffer = buffer;
        this._pageChannel = pageChannel;
        this._format = format;
        this._tableDefPageNumber = pageNumber;
        do {
            this.readPage();
        } while ((nextPage = this._buffer.getInt(this._format.OFFSET_NEXT_TABLE_DEF_PAGE)) > 0);
    }

    public List getColumns() {
        return Collections.unmodifiableList(this._columns);
    }

    void setColumns(List columns) {
        this._columns = columns;
    }

    public List getIndexes() {
        return Collections.unmodifiableList(this._indexes);
    }

    public void reset() {
        this._rowsLeftOnPage = 0;
        this._ownedPages.reset();
    }

    public Map getNextRow() throws IOException {
        return this.getNextRow(null);
    }

    public Map getNextRow(Collection columnNames) throws IOException {
        short i2;
        if (!this.positionAtNextRow()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data block at position " + Integer.toHexString(this._buffer.position()) + ":\n" + ByteUtil.toHexString(this._buffer, this._buffer.position(), this._buffer.limit() - this._buffer.position()));
        }
        short columnCount = this._buffer.getShort();
        LinkedHashMap<String, Boolean> rtn = new LinkedHashMap<String, Boolean>(columnCount);
        NullMask nullMask = new NullMask(columnCount);
        this._buffer.position(this._buffer.limit() - nullMask.byteSize());
        nullMask.read(this._buffer);
        this._buffer.position(this._buffer.limit() - nullMask.byteSize() - 2);
        short varColumnCount = this._buffer.getShort();
        byte[][] varColumnData = new byte[varColumnCount][];
        short[] varColumnOffsets = new short[varColumnCount];
        this._buffer.position(this._buffer.position() - 2 - varColumnCount * 2 - 2);
        short lastVarColumnStart = this._buffer.getShort();
        for (i2 = 0; i2 < varColumnCount; i2 = (short)(i2 + 1)) {
            varColumnOffsets[i2] = this._buffer.getShort();
        }
        for (i2 = 0; i2 < varColumnCount; i2 = (short)(i2 + 1)) {
            this._buffer.position(this._rowStart + varColumnOffsets[i2]);
            varColumnData[i2] = new byte[lastVarColumnStart - varColumnOffsets[i2]];
            this._buffer.get(varColumnData[i2]);
            lastVarColumnStart = varColumnOffsets[i2];
        }
        int columnNumber = 0;
        int varColumnDataIndex = varColumnCount - 1;
        this._buffer.position(this._rowStart + 2);
        for (Column column : this._columns) {
            boolean isNull = nullMask.isNull(columnNumber);
            Object value = null;
            if (column.getType() == 1) {
                value = new Boolean(!isNull);
            } else if (!isNull) {
                byte[] columnData;
                if (!column.isVariableLength()) {
                    columnData = new byte[column.size()];
                    this._buffer.get(columnData);
                } else {
                    columnData = varColumnData[varColumnDataIndex--];
                }
                if (columnNames == null || columnNames.contains(column.getName())) {
                    value = column.read(columnData);
                }
            }
            rtn.put(column.getName(), (Boolean)value);
            ++columnNumber;
        }
        return rtn;
    }

    private boolean positionAtNextRow() throws IOException {
        if (this._rowsLeftOnPage == 0) {
            do {
                if (this._ownedPages.getNextPage(this._buffer)) continue;
                return false;
            } while (this._buffer.get() != 1);
            this._rowsLeftOnPage = this._buffer.getShort(this._format.OFFSET_NUM_ROWS_ON_DATA_PAGE);
            this._currentRowInPage = 0;
            this._lastRowStart = (short)this._format.PAGE_SIZE;
        }
        this._rowStart = this._buffer.getShort(this._format.OFFSET_DATA_ROW_LOCATION_BLOCK + this._currentRowInPage * this._format.SIZE_ROW_LOCATION);
        this._buffer.position(this._rowStart);
        this._buffer.limit(this._lastRowStart);
        this._rowsLeftOnPage = (short)(this._rowsLeftOnPage - 1);
        ++this._currentRowInPage;
        this._lastRowStart = this._rowStart;
        return true;
    }

    private void readPage() throws IOException {
        Column column;
        int i2;
        if (LOG.isDebugEnabled()) {
            this._buffer.rewind();
            LOG.debug("Table def block:\n" + ByteUtil.toHexString(this._buffer, this._format.SIZE_TDEF_BLOCK));
        }
        this._rowCount = this._buffer.getInt(this._format.OFFSET_NUM_ROWS);
        this._tableType = this._buffer.get(this._format.OFFSET_TABLE_TYPE);
        this._columnCount = this._buffer.getShort(this._format.OFFSET_NUM_COLS);
        this._indexCount = this._buffer.getInt(this._format.OFFSET_NUM_INDEXES);
        byte rowNum = this._buffer.get(this._format.OFFSET_OWNED_PAGES);
        int pageNum = ByteUtil.get3ByteInt(this._buffer, this._format.OFFSET_OWNED_PAGES + 1);
        this._ownedPages = UsageMap.read(this._pageChannel, pageNum, rowNum, this._format);
        rowNum = this._buffer.get(this._format.OFFSET_FREE_SPACE_PAGES);
        pageNum = ByteUtil.get3ByteInt(this._buffer, this._format.OFFSET_FREE_SPACE_PAGES + 1);
        this._freeSpacePages = UsageMap.read(this._pageChannel, pageNum, rowNum, this._format);
        for (int i3 = 0; i3 < this._indexCount; ++i3) {
            Index index = new Index(this._tableDefPageNumber, this._pageChannel, this._format);
            this._indexes.add(index);
            index.setRowCount(this._buffer.getInt(this._format.OFFSET_INDEX_DEF_BLOCK + i3 * this._format.SIZE_INDEX_DEFINITION + 4));
        }
        int offset = this._format.OFFSET_INDEX_DEF_BLOCK + this._indexCount * this._format.SIZE_INDEX_DEFINITION;
        for (i2 = 0; i2 < this._columnCount; ++i2) {
            column = new Column(this._buffer, offset + i2 * this._format.SIZE_COLUMN_HEADER, this._pageChannel, this._format);
            this._columns.add(column);
        }
        offset += this._columnCount * this._format.SIZE_COLUMN_HEADER;
        for (i2 = 0; i2 < this._columnCount; ++i2) {
            column = (Column)this._columns.get(i2);
            short nameLength = this._buffer.getShort(offset);
            byte[] nameBytes = new byte[nameLength];
            this._buffer.position(offset += 2);
            this._buffer.get(nameBytes, 0, nameLength);
            column.setName(this._format.CHARSET.decode(ByteBuffer.wrap(nameBytes)).toString());
            offset += nameLength;
        }
        Collections.sort(this._columns);
        for (i2 = 0; i2 < this._indexCount; ++i2) {
            this._buffer.getInt();
            ((Index)this._indexes.get(i2)).read(this._buffer, this._columns);
        }
        for (i2 = 0; i2 < this._indexCount; ++i2) {
            this._buffer.getInt();
            ((Index)this._indexes.get(i2)).setIndexNumber(this._buffer.getInt());
            this._buffer.position(this._buffer.position() + 20);
        }
        Collections.sort(this._indexes);
        for (i2 = 0; i2 < this._indexCount; ++i2) {
            byte[] nameBytes = new byte[this._buffer.getShort()];
            this._buffer.get(nameBytes);
            ((Index)this._indexes.get(i2)).setName(this._format.CHARSET.decode(ByteBuffer.wrap(nameBytes)).toString());
        }
    }

    public void addRow(Object[] row) throws IOException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(1);
        rows.add(row);
        this.addRows(rows);
    }

    public void addRows(List rows) throws IOException {
        int pageNumber;
        ByteBuffer dataPage = this._pageChannel.createPageBuffer();
        ByteBuffer[] rowData = new ByteBuffer[rows.size()];
        Iterator iter = rows.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            rowData[i2] = this.createRow((Object[])iter.next());
            ++i2;
        }
        List pageNumbers = this._ownedPages.getPageNumbers();
        if (pageNumbers.size() == 0) {
            pageNumber = this.newDataPage(dataPage, rowData[0]);
        } else {
            pageNumber = (Integer)pageNumbers.get(pageNumbers.size() - 1);
            this._pageChannel.readPage(dataPage, pageNumber);
        }
        for (int i3 = 0; i3 < rowData.length; ++i3) {
            int rowSize = rowData[i3].limit();
            short freeSpaceInPage = dataPage.getShort(this._format.OFFSET_FREE_SPACE);
            if (freeSpaceInPage < rowSize + this._format.SIZE_ROW_LOCATION) {
                if (rowSize + this._format.SIZE_ROW_LOCATION > this._format.MAX_ROW_SIZE) {
                    throw new IOException("Row size " + rowSize + " is too large");
                }
                this._pageChannel.writePage(dataPage, pageNumber);
                dataPage.clear();
                pageNumber = this.newDataPage(dataPage, rowData[i3]);
                this._freeSpacePages.removePageNumber(pageNumber);
                freeSpaceInPage = dataPage.getShort(this._format.OFFSET_FREE_SPACE);
            }
            dataPage.putShort(this._format.OFFSET_FREE_SPACE, (short)(freeSpaceInPage - rowSize - this._format.SIZE_ROW_LOCATION));
            short rowCount = dataPage.getShort(this._format.OFFSET_NUM_ROWS_ON_DATA_PAGE);
            dataPage.putShort(this._format.OFFSET_NUM_ROWS_ON_DATA_PAGE, (short)(rowCount + 1));
            short rowLocation = (short)this._format.PAGE_SIZE;
            if (rowCount > 0) {
                rowLocation = dataPage.getShort(this._format.OFFSET_DATA_ROW_LOCATION_BLOCK + (rowCount - 1) * this._format.SIZE_ROW_LOCATION);
            }
            rowLocation = (short)(rowLocation - rowSize);
            dataPage.putShort(this._format.OFFSET_DATA_ROW_LOCATION_BLOCK + rowCount * this._format.SIZE_ROW_LOCATION, rowLocation);
            dataPage.position(rowLocation);
            dataPage.put(rowData[i3]);
            for (Index index : this._indexes) {
                index.addRow((Object[])rows.get(i3), pageNumber, (byte)rowCount);
            }
        }
        this._pageChannel.writePage(dataPage, pageNumber);
        ByteBuffer tdefPage = this._pageChannel.createPageBuffer();
        this._pageChannel.readPage(tdefPage, this._tableDefPageNumber);
        tdefPage.putInt(this._format.OFFSET_NUM_ROWS, ++this._rowCount);
        iter = this._indexes.iterator();
        for (int i4 = 0; i4 < this._indexes.size(); ++i4) {
            tdefPage.putInt(this._format.OFFSET_INDEX_DEF_BLOCK + i4 * this._format.SIZE_INDEX_DEFINITION + 4, this._rowCount);
            Index index = (Index)iter.next();
            index.update();
        }
        this._pageChannel.writePage(tdefPage, this._tableDefPageNumber);
    }

    private int newDataPage(ByteBuffer dataPage, ByteBuffer rowData) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new data page");
        }
        dataPage.put((byte)1);
        dataPage.put((byte)1);
        dataPage.putShort((short)(this._format.PAGE_SIZE - this._format.OFFSET_DATA_ROW_LOCATION_BLOCK - (rowData.limit() - 1) - this._format.SIZE_ROW_LOCATION));
        dataPage.putInt(this._tableDefPageNumber);
        dataPage.putInt(0);
        dataPage.putInt(0);
        int pageNumber = this._pageChannel.writeNewPage(dataPage);
        this._ownedPages.addPageNumber(pageNumber);
        this._freeSpacePages.addPageNumber(pageNumber);
        return pageNumber;
    }

    ByteBuffer createRow(Object[] rowArray) throws IOException {
        Column col;
        ByteBuffer buffer = this._pageChannel.createPageBuffer();
        buffer.putShort((short)this._columns.size());
        NullMask nullMask = new NullMask(this._columns.size());
        int index = 0;
        ArrayList<Object> row = new ArrayList<Object>(Arrays.asList(rowArray));
        for (int i2 = rowArray.length; i2 < this._columnCount; ++i2) {
            row.add(null);
        }
        Iterator iter = this._columns.iterator();
        while (iter.hasNext() && index < row.size()) {
            col = (Column)iter.next();
            if (!col.isVariableLength() && row.get(index) != null) {
                buffer.put(col.write(row.get(index)));
            }
            if (col.getType() == 1) {
                if (row.get(index) != null && !((Boolean)row.get(index)).booleanValue()) {
                    nullMask.markNull(index);
                }
            } else if (row.get(index) == null) {
                nullMask.markNull(index);
            }
            ++index;
        }
        short varLengthCount = Column.countVariableLength(this._columns);
        short[] varColumnOffsets = new short[varLengthCount];
        int varColumnOffsetsIndex = 0;
        iter = this._columns.iterator();
        for (index = 0; iter.hasNext() && index < row.size(); ++index) {
            col = (Column)iter.next();
            short offset = (short)buffer.position();
            if (!col.isVariableLength()) continue;
            if (row.get(index) != null) {
                buffer.put(col.write(row.get(index)));
            }
            varColumnOffsets[varColumnOffsetsIndex++] = offset;
        }
        buffer.putShort((short)buffer.position());
        for (int i3 = varColumnOffsets.length - 1; i3 >= 0; --i3) {
            buffer.putShort(varColumnOffsets[i3]);
        }
        buffer.putShort(varLengthCount);
        buffer.put(nullMask.wrap());
        buffer.limit(buffer.position());
        buffer.flip();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new data block:\n" + ByteUtil.toHexString(buffer, buffer.limit()));
        }
        return buffer;
    }

    public String toString() {
        StringBuffer rtn = new StringBuffer();
        rtn.append("Type: " + this._tableType);
        rtn.append("\nRow count: " + this._rowCount);
        rtn.append("\nColumn count: " + this._columnCount);
        rtn.append("\nIndex count: " + this._indexCount);
        rtn.append("\nColumns:\n");
        Iterator iter = this._columns.iterator();
        while (iter.hasNext()) {
            rtn.append(iter.next().toString());
        }
        rtn.append("\nIndexes:\n");
        iter = this._indexes.iterator();
        while (iter.hasNext()) {
            rtn.append(iter.next().toString());
        }
        rtn.append("\nOwned pages: " + this._ownedPages + "\n");
        return rtn.toString();
    }

    public String display() throws IOException {
        return this.display(Long.MAX_VALUE);
    }

    public String display(long limit) throws IOException {
        Map row;
        this.reset();
        StringBuffer rtn = new StringBuffer();
        Iterator<Object> iter = this._columns.iterator();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            rtn.append(col.getName());
            if (!iter.hasNext()) continue;
            rtn.append("\t");
        }
        rtn.append("\n");
        int rowCount = 0;
        while ((long)rowCount++ < limit && (row = this.getNextRow()) != null) {
            iter = row.values().iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof byte[]) {
                    byte[] b2 = (byte[])obj;
                    rtn.append(ByteUtil.toHexString(ByteBuffer.wrap(b2), b2.length));
                } else {
                    rtn.append(String.valueOf(obj));
                }
                if (!iter.hasNext()) continue;
                rtn.append("\t");
            }
            rtn.append("\n");
        }
        return rtn.toString();
    }
}

