/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

import com.graphbuilder.math.FuncMap;
import com.graphbuilder.math.FuncNode;
import com.graphbuilder.math.OpNode;
import com.graphbuilder.math.TermNode;
import com.graphbuilder.math.ValNode;
import com.graphbuilder.math.VarMap;
import com.graphbuilder.math.VarNode;
import com.graphbuilder.struc.Bag;

public abstract class Expression {
    protected Expression parent = null;

    public abstract double eval(VarMap var1, FuncMap var2);

    public boolean isDescendent(Expression x) {
        Expression y = this;
        while (y != null) {
            if (y == x) {
                return true;
            }
            y = y.parent;
        }
        return false;
    }

    public Expression getParent() {
        return this.parent;
    }

    protected void checkBeforeAccept(Expression x) {
        if (x == null) {
            throw new IllegalArgumentException("expression cannot be null");
        }
        if (x.parent != null) {
            throw new IllegalArgumentException("expression must be removed parent");
        }
        if (this.isDescendent(x)) {
            throw new IllegalArgumentException("cyclic reference");
        }
    }

    public String[] getVariableNames() {
        return this.getTermNames(true);
    }

    public String[] getFunctionNames() {
        return this.getTermNames(false);
    }

    private String[] getTermNames(boolean varNames) {
        Bag b2 = new Bag();
        Expression.getTermNames(this, b2, varNames);
        String[] arr = new String[b2.size()];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            arr[i2] = (String)b2.get(i2);
        }
        return arr;
    }

    private static void getTermNames(Expression x, Bag b2, boolean varNames) {
        block4: {
            block5: {
                block3: {
                    if (!(x instanceof OpNode)) break block3;
                    OpNode o2 = (OpNode)x;
                    Expression.getTermNames(o2.leftChild, b2, varNames);
                    Expression.getTermNames(o2.rightChild, b2, varNames);
                    break block4;
                }
                if (!(x instanceof VarNode)) break block5;
                if (!varNames) break block4;
                VarNode v = (VarNode)x;
                if (b2.contains(v.name)) break block4;
                b2.add(v.name);
                break block4;
            }
            if (x instanceof FuncNode) {
                FuncNode f2 = (FuncNode)x;
                if (!varNames && !b2.contains(f2.name)) {
                    b2.add(f2.name);
                }
                for (int i2 = 0; i2 < f2.numChildren(); ++i2) {
                    Expression.getTermNames(f2.child(i2), b2, varNames);
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Expression.toString(this, sb);
        return sb.toString();
    }

    private static void toString(Expression x, StringBuffer sb) {
        if (x instanceof OpNode) {
            OpNode o2 = (OpNode)x;
            sb.append("(");
            Expression.toString(o2.leftChild, sb);
            sb.append(o2.getSymbol());
            Expression.toString(o2.rightChild, sb);
            sb.append(")");
        } else if (x instanceof TermNode) {
            TermNode t = (TermNode)x;
            if (t.getNegate()) {
                sb.append("(");
                sb.append("-");
            }
            sb.append(t.getName());
            if (t instanceof FuncNode) {
                FuncNode f2 = (FuncNode)t;
                sb.append("(");
                if (f2.numChildren() > 0) {
                    Expression.toString(f2.child(0), sb);
                }
                for (int i2 = 1; i2 < f2.numChildren(); ++i2) {
                    sb.append(", ");
                    Expression.toString(f2.child(i2), sb);
                }
                sb.append(")");
            }
            if (t.getNegate()) {
                sb.append(")");
            }
        } else if (x instanceof ValNode) {
            sb.append(((ValNode)x).val);
        }
    }
}

