/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;

public class CatmullRomSpline
extends ParametricCurve {
    private static final ThreadLocal<SharedData> SHARED_DATA = new ThreadLocal<SharedData>(){

        @Override
        protected SharedData initialValue() {
            return new SharedData();
        }
    };
    private final SharedData sharedData = SHARED_DATA.get();

    public CatmullRomSpline(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    protected void eval(double[] p2) {
        double t = p2[p2.length - 1];
        double t2 = t * t;
        double t3 = t2 * t;
        for (int i2 = 0; i2 < p2.length - 1; ++i2) {
            p2[i2] = 0.5 * ((this.sharedData.pt[3][i2] - this.sharedData.pt[0][i2] + 3.0 * (this.sharedData.pt[1][i2] - this.sharedData.pt[2][i2])) * t3 + (2.0 * (this.sharedData.pt[0][i2] + 2.0 * this.sharedData.pt[2][i2]) - 5.0 * this.sharedData.pt[1][i2] - this.sharedData.pt[3][i2]) * t2 + (this.sharedData.pt[2][i2] - this.sharedData.pt[0][i2]) * t) + this.sharedData.pt[1][i2];
        }
    }

    public int getSampleLimit() {
        return 1;
    }

    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        if (this.gi.getGroupSize() < 4) {
            throw new IllegalArgumentException("Group iterator size < 4");
        }
        this.gi.set(0, 0);
        for (int i2 = 0; i2 < 4; ++i2) {
            ((SharedData)this.sharedData).pt[i2] = this.cp.getPoint(this.gi.next()).getLocation();
        }
        double[] d2 = new double[mp.getDimension() + 1];
        this.eval(d2);
        if (this.connect) {
            mp.lineTo(d2);
        } else {
            mp.moveTo(d2);
        }
        this.gi.set(0, 0);
        while (true) {
            int index_i = this.gi.index_i();
            int count_j = this.gi.count_j();
            for (int i3 = 0; i3 < 4; ++i3) {
                if (!this.gi.hasNext()) {
                    return;
                }
                ((SharedData)this.sharedData).pt[i3] = this.cp.getPoint(this.gi.next()).getLocation();
            }
            this.gi.set(index_i, count_j);
            this.gi.next();
            BinaryCurveApproximationAlgorithm.genPts(this, 0.0, 1.0, mp);
        }
    }

    private static class SharedData {
        private double[][] pt = new double[4][];

        private SharedData() {
        }
    }
}

