/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.test;

import biz.elabor.prebilling.test.ColumnType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.homelinux.elabor.csv.CsvReader;
import org.homelinux.elabor.db.DbmsType;

public class TestDaoHelper {
    private static final String OPZIONI_CONTRATTUALI_GAS = "opzioni_contrattuali_gas";
    private static final String DTMISORA = "DTMISORA";

    public static void insert(String name, CsvReader reader, Connection connection, DbmsType dbType) throws SQLException, ParseException {
        Map<String, String> columnTypes = TestDaoHelper.getColumnTypes(name, connection);
        Object[] fields = reader.next();
        String extra = null;
        if (name.toLowerCase().equals(OPZIONI_CONTRATTUALI_GAS) && !Arrays.asList(fields).contains(DTMISORA)) {
            fields = (String[])ArrayUtils.add(fields, DTMISORA);
            extra = "1970-01-01";
        }
        List<String> columns = TestDaoHelper.filterColumns((String[])fields, columnTypes);
        String sql = TestDaoHelper.prepareInsertSql(name, columns);
        Throwable throwable = null;
        Object var10_11 = null;
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            while (reader.hasNext()) {
                Object[] values = reader.next();
                if (extra != null) {
                    values = (String[])ArrayUtils.add(values, extra);
                }
                if (values.length <= 1 && ((String)values[0]).isEmpty()) continue;
                TestDaoHelper.prepare(statement, (String[])values, (String[])fields, columnTypes, dbType);
                statement.addBatch();
            }
            statement.clearParameters();
            statement.executeBatch();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static List<String> filterColumns(String[] fields, Map<String, String> columnTypes) {
        ArrayList<String> columns = new ArrayList<String>();
        String[] stringArray = fields;
        int n2 = fields.length;
        int n3 = 0;
        while (n3 < n2) {
            String field = stringArray[n3];
            if (columnTypes.get(field.toUpperCase()) != null) {
                columns.add(field);
            }
            ++n3;
        }
        return columns;
    }

    private static void prepare(PreparedStatement statement, String[] values, String[] fields, Map<String, String> columnTypes, DbmsType dbType) throws SQLException, ParseException {
        int column = 1;
        int index = 0;
        while (index < values.length) {
            String name = fields[index];
            String typeName = columnTypes.get(name.toUpperCase());
            if (typeName != null) {
                ColumnType type = ColumnType.getColumnType(typeName.toUpperCase());
                String value = values[index];
                type.setFieldValue(statement, column, value, dbType);
                ++column;
            }
            ++index;
        }
    }

    private static String prepareInsertSql(String name, List<String> columns) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ");
        buffer.append(name);
        buffer.append(" (");
        TestDaoHelper.appendFieldNames(buffer, columns);
        buffer.append(") VALUES(");
        TestDaoHelper.appendPlaceHolders(buffer, columns);
        buffer.append(")");
        return buffer.toString();
    }

    private static void appendFieldNames(StringBuffer buffer, List<String> columns) {
        String cnj = "";
        for (String field : columns) {
            buffer.append(cnj);
            buffer.append(field);
            cnj = ", ";
        }
    }

    private static void appendPlaceHolders(StringBuffer buffer, List<String> columns) {
        String cnj = "";
        for (String field : columns) {
            buffer.append(cnj);
            buffer.append("?");
            cnj = ", ";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> getColumnTypes(String name, Connection connection) throws SQLException {
        Throwable throwable = null;
        Object var5_4 = null;
        try {
            LinkedHashMap<String, String> values;
            Statement statement = connection.createStatement();
            try {
                try (ResultSet rs = statement.executeQuery("SELECT * FROM " + name);){
                    ResultSetMetaData metadata = rs.getMetaData();
                    int columnCount = metadata.getColumnCount();
                    values = new LinkedHashMap<String, String>();
                    int index = 0;
                    while (index < columnCount) {
                        int column = index + 1;
                        String fieldName = metadata.getColumnName(column);
                        String type = metadata.getColumnTypeName(column);
                        values.put(fieldName.toUpperCase(), type);
                        ++index;
                    }
                }
                if (statement == null) return values;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
            return values;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void dumpFile(File dumpFolder, String name, Connection connection) throws FileNotFoundException, SQLException {
        Map<String, String> columnTypes = TestDaoHelper.getColumnTypes(name, connection);
        Set<String> columnNames = columnTypes.keySet();
        File file = new File(dumpFolder, String.valueOf(name) + ".csv");
        Throwable throwable = null;
        Object var7_8 = null;
        try (PrintWriter writer = new PrintWriter(file);){
            TestDaoHelper.dumpHeaders(columnNames, writer);
            TestDaoHelper.dumpLines(writer, name, columnNames, connection);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void clearTable(String name, Connection connection) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement statement = connection.createStatement();){
            String command = "DELETE FROM " + name;
            System.out.println(command);
            statement.execute(command);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void dumpLines(PrintWriter writer, String name, Set<String> columnNames, Connection connection) throws SQLException {
        StringBuffer query = new StringBuffer("SELECT * FROM ");
        query.append(name);
        query.append(" ORDER BY ");
        String cnj = "";
        for (String columnName : columnNames) {
            query.append(cnj);
            query.append(columnName);
            cnj = ",";
        }
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try {
            Statement statement = connection.createStatement();
            try {
                try (ResultSet rs = statement.executeQuery(query.toString());){
                    TestDaoHelper.dumpLines(writer, rs);
                }
                if (statement == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            statement.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void dumpHeaders(Set<String> columnNames, PrintWriter writer) {
        String cnj = "";
        for (String columnName : columnNames) {
            writer.print(cnj);
            writer.print(columnName.toUpperCase());
            cnj = ";";
        }
        writer.println();
    }

    private static void dumpLines(PrintWriter writer, ResultSet rs) throws SQLException {
        while (rs.next()) {
            TestDaoHelper.dumpLine(writer, rs);
        }
    }

    private static void dumpLine(PrintWriter writer, ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        int columnCount = metadata.getColumnCount();
        String cnj = "";
        int column = 1;
        while (column <= columnCount) {
            writer.print(cnj);
            String value = rs.getString(column);
            writer.print(value == null ? "" : value.trim());
            cnj = ";";
            ++column;
        }
        writer.println();
    }
}

