/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.test;

import biz.elabor.prebilling.test.TestDao;
import biz.elabor.prebilling.test.TestInvalidParameterValue;
import biz.elabor.test.TextTestHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.homelinux.elabor.csv.CsvReader;
import org.homelinux.elabor.csv.CsvReaderCloseable;
import org.homelinux.elabor.db.DbmsType;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.junit.Test;
import org.springframework.context.support.ResourceBundleMessageSource;

public abstract class AbstractPrebillingTest
extends TestCase {
    protected static File testFolder;
    private static boolean failed;

    protected abstract void openTest(List<File> var1) throws IOException, SQLException, ParseException;

    protected abstract String performTest() throws TestInvalidParameterValue;

    protected abstract void dumpDatabase(File var1) throws SQLException, FileNotFoundException;

    protected abstract void closeTest();

    private static void initRootLogger() {
        Logger rootLogger = Logger.getLogger("");
        Formatter formatter = new Formatter(){

            @Override
            public String format(LogRecord record) {
                StringBuilder builder = new StringBuilder();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                builder.append(dateFormat.format(new Date(record.getMillis())));
                builder.append("\t");
                builder.append(record.getLoggerName());
                builder.append("\t");
                builder.append(record.getLevel());
                builder.append("\t");
                builder.append(record.getMessage());
                builder.append("\n");
                return builder.toString();
            }
        };
        Handler[] handlerArray = rootLogger.getHandlers();
        int n2 = handlerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Handler handler = handlerArray[n3];
            handler.setFormatter(formatter);
            ++n3;
        }
    }

    public static void initTest(File folder) {
        testFolder = folder;
    }

    public boolean isFailed() {
        return failed;
    }

    @Test
    public void test() {
        try {
            try {
                AbstractPrebillingTest.initRootLogger();
                File checkFolder = new File(testFolder, "output");
                File outputFolder = new File("out-folder");
                this.prepareTest(outputFolder);
                String response = this.performTest();
                this.checkResults(response, outputFolder, checkFolder);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                AbstractPrebillingTest.fail();
                this.closeTest();
            }
        }
        finally {
            this.closeTest();
        }
    }

    private void checkResults(String response, File outputFolder, File checkFolder) throws UnsupportedEncodingException, IOException, SQLException, FileNotFoundException {
        this.dumpDatabase(outputFolder);
        AbstractPrebillingTest.checkResponse(response);
        TextTestHelper.checkFolder(checkFolder, outputFolder);
    }

    private void prepareTest(File outputFolder) throws IOException, SQLException, ParseException {
        AbstractPrebillingTest.clearOutputFolder(outputFolder);
        ArrayList<File> configFiles = new ArrayList<File>();
        File testConfigFile = new File(testFolder, "test.cfg");
        File parentFile = testFolder.getParentFile();
        File siteConfigFile = new File(parentFile, "test.cfg");
        if (siteConfigFile.exists()) {
            configFiles.add(siteConfigFile);
        }
        if (testConfigFile.exists()) {
            configFiles.add(testConfigFile);
        }
        this.openTest(configFiles);
    }

    private static void clearOutputFolder(File outputFolder) {
        TextTestHelper.clearFolder(outputFolder);
        outputFolder.delete();
    }

    public static String[] loadParams(File file) throws IOException {
        String[] row;
        Throwable throwable = null;
        Object var3_3 = null;
        try (CsvReaderCloseable reader = new CsvReaderCloseable(";");){
            reader.setFile(file);
            row = reader.getNextRow();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return row;
    }

    private static void checkResponse(String actual) throws UnsupportedEncodingException, IOException {
        TextTestHelper.checkJsonFile(testFolder, "response.json", actual);
    }

    public static void importFiles(File inputFolder, String[] names, TestDao dao, DbmsType dbType) throws IOException, SQLException, ParseException {
        String[] stringArray = names;
        int n2 = names.length;
        int n3 = 0;
        while (n3 < n2) {
            String name = stringArray[n3];
            AbstractPrebillingTest.importFile(inputFolder, name, dao, dbType);
            ++n3;
        }
    }

    private static void importFile(File inputFolder, String name, TestDao dao, DbmsType dbType) throws IOException, SQLException, ParseException {
        String fileName = String.valueOf(name) + ".csv";
        File file = new File(inputFolder, fileName);
        if (!file.exists()) {
            file = new File(inputFolder, fileName.toUpperCase());
        }
        if (file.exists()) {
            System.out.println(file.getName());
            try (CsvReader reader = new CsvReader(";");){
                reader.setFile(file);
                dao.insert(name, reader, dbType);
            }
        }
    }

    public static void dumpFiles(File dumpFolder, String[] names, TestDao dao) throws SQLException, FileNotFoundException {
        String[] stringArray = names;
        int n2 = names.length;
        int n3 = 0;
        while (n3 < n2) {
            String name = stringArray[n3];
            dao.dumpFile(dumpFolder, name);
            ++n3;
        }
    }

    public static void clearDatabase(String[] names, TestDao dao) throws SQLException {
        String[] stringArray = names;
        int n2 = names.length;
        int n3 = 0;
        while (n3 < n2) {
            String name = stringArray[n3];
            dao.clearTable(name);
            ++n3;
        }
    }

    protected static TalkManager buildTalkManager() {
        TalkManager talkManager = new TalkManager();
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("messages");
        talkManager.setMessageSource(messageSource);
        return talkManager;
    }
}

