/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.consumi;

import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.web.AbstractGasRequestHandler;
import biz.elabor.prebilling.gas.web.JsonGasRequestHandler;
import biz.elabor.prebilling.gas.web.consumi.ConsumiGasStrategiesHandler;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import java.util.LinkedHashMap;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ConsumiGasJsonPostHandler
extends AbstractGasRequestHandler
implements JsonGasRequestHandler {
    private final String annoTxt;
    private final String meseTxt;

    public ConsumiGasJsonPostHandler(String annoTxt, String meseTxt, TalkManager talkManager) {
        super("consumi", talkManager);
        this.annoTxt = annoTxt;
        this.meseTxt = meseTxt;
    }

    @Override
    public String handleRequest(ConfigurationGasInstance instance) throws InvalidParameterValue {
        int anno = ControllerHelper.checkInt("anno", this.annoTxt);
        Month mese = ControllerHelper.checkEnum("mese", this.meseTxt, Month.class);
        PrebillingGasConfiguration configuration = instance.getConfiguration();
        MisureGasDao misureDao = instance.getMisureDao();
        ConsumiGasStrategiesHandler consumiHandler = new ConsumiGasStrategiesHandler(anno, mese, instance, this.talkManager);
        Results results = this.handleRequest(consumiHandler, configuration, misureDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("anno", this.annoTxt);
        params.put("mese", this.meseTxt);
        return params;
    }

    @Override
    protected String getReseller() {
        return null;
    }
}

