/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.utils;

import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.ProfiloPrelievo;
import biz.elabor.prebilling.gas.utils.GasProfiler;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.DaysOfMonthIterable;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;

public class AnnualGasProfiler
implements GasProfiler {
    private final Map<Date, ProfiloPrelievo> profilo = new HashMap<Date, ProfiloPrelievo>();

    public AnnualGasProfiler(String cdProPre, int anno, Month mese, GiadaGasDao giadaDao) throws DataNotFoundException {
        for (Integer day : new DaysOfMonthIterable(anno, mese)) {
            Date date = CalendarTools.getDate(anno, mese, day);
            ProfiloPrelievo profiloPrelievo = giadaDao.getProfiloPrelievo(cdProPre, date);
            this.profilo.put(date, profiloPrelievo);
        }
    }

    @Override
    public double getConsumoGiorno(double consumoAnnuo, Date data) {
        ProfiloPrelievo profiloGiorno = this.profilo.get(data);
        double valore = profiloGiorno.getValore();
        return consumoAnnuo * valore / 100.0;
    }
}

