/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe.model;

import biz.elabor.prebilling.gas.services.tariffe.model.Consumo;
import java.util.Date;

public class DettaglioGiorno {
    private final Consumo consumo;
    private double consumoEfficace;
    private double prezzo;
    private double costo;

    public DettaglioGiorno(Consumo consumo) {
        this.consumo = DettaglioGiorno.cloneConsumo(consumo);
    }

    private static Consumo cloneConsumo(Consumo master) {
        Date data = master.getDataMisura();
        double valore = master.getValore();
        String flusso = master.getFlusso();
        return new Consumo(data, valore, flusso);
    }

    public Date getDataMisura() {
        return this.consumo.getDataMisura();
    }

    public double getConsumo() {
        return this.consumo.getValore();
    }

    public void addConsumo(double scarto) {
        this.consumo.addConsumo(scarto);
    }

    public double getConsumoEfficace() {
        return this.consumoEfficace;
    }

    public void setConsumoEfficace(double consumoEfficace) {
        this.consumoEfficace = consumoEfficace;
    }

    public double getPrezzo() {
        return this.prezzo;
    }

    public void setPrezzo(double prezzo) {
        this.prezzo = prezzo;
    }

    public double getCosto() {
        return this.costo;
    }

    public void setCosto(double costo) {
        this.costo = costo;
    }

    public void setSegnanteMis(double segnanteMis) {
        this.consumo.setSegnanteMis(segnanteMis);
    }

    public void setSegnanteConv(double segnanteConv) {
        this.consumo.setSegnanteConv(segnanteConv);
    }

    public DettaglioGiorno cloneDettaglio() {
        return new DettaglioGiorno(this.consumo);
    }
}

