/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.IncoherentEndDates;
import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.model.ContrattiHelper;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.common.utils.ListWriter;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.Igmg;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.PrezzoGas;
import biz.elabor.prebilling.gas.dao.misure.model.TipoLettura;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import biz.elabor.prebilling.gas.services.common.WriteLetstdGasService;
import biz.elabor.prebilling.gas.services.tariffe.AbstractCalcolaTariffeStrategy;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiGruppo;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiMesePdr;
import biz.elabor.prebilling.gas.services.tariffe.GlobalErrorHandler;
import biz.elabor.prebilling.gas.services.tariffe.InvalidInpcsException;
import biz.elabor.prebilling.gas.services.tariffe.InvalidSequenceException;
import biz.elabor.prebilling.gas.services.tariffe.MappaPrezziGas;
import biz.elabor.prebilling.gas.services.tariffe.MissingMisuraException;
import biz.elabor.prebilling.gas.services.tariffe.TariffaCalculator;
import biz.elabor.prebilling.gas.services.tariffe.TariffeContratto;
import biz.elabor.prebilling.gas.services.tariffe.TariffeGasHelper;
import biz.elabor.prebilling.gas.services.tariffe.model.Consumo;
import biz.elabor.prebilling.gas.services.tariffe.model.DettaglioGiorno;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.Sentence;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public class TariffaDirettoCalculator {
    private final int anno;
    private final Month mese;
    private final GasServiceStatus status;
    private final WriteLetstdGasService writer;
    private final GlobalErrorHandler globalErrorHandler;
    private final boolean esportaLetture;
    private final boolean esportaTariffe;
    private final DateFormat dateFormat;
    private final TalkManager talkManager;
    private final boolean bloccoIndice;
    private final MappaPrezziGas mappaPrezziGas;
    private final TariffaCalculator tariffaCalculator;
    private String lastPdr = null;
    private Date lastDataFineTariffa = null;

    public TariffaDirettoCalculator(int anno, Month mese, boolean esportaLetture, boolean esportaTariffe, boolean bloccoIndice, MappaPrezziGas mappaPrezziGas, GlobalErrorHandler globalErrorHandler, TariffaCalculator tariffaCalculator, DateFormat dateFormat, GasServiceStatus status, TalkManager talkManager, WriteLetstdGasService writer) {
        this.anno = anno;
        this.mese = mese;
        this.status = status;
        this.writer = writer;
        this.globalErrorHandler = globalErrorHandler;
        this.esportaLetture = esportaLetture;
        this.esportaTariffe = esportaTariffe;
        this.dateFormat = dateFormat;
        this.talkManager = talkManager;
        this.bloccoIndice = bloccoIndice;
        this.mappaPrezziGas = mappaPrezziGas;
        this.tariffaCalculator = tariffaCalculator;
        this.lastPdr = null;
        this.lastDataFineTariffa = null;
    }

    public boolean calcolaTariffa(ContrattoGas contratto, ConsumiGruppo consumiGruppo) throws InconsistentOptionException {
        Date dataInizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
        String codicePdr = contratto.getCodice();
        String azienda = contratto.getReseller();
        boolean exported = false;
        Date dataInizioTariffa = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
        Date dataFineTariffa = ContrattiHelper.getFineTariffa(this.anno, this.mese, contratto);
        List<Consumo> consumiComplessivi = consumiGruppo.getConsumiComplessivi(codicePdr, dataInizioTariffa, dataFineTariffa);
        ConsumiMesePdr consumiMesePdr = consumiGruppo.getConsumiPdr(codicePdr);
        List<Consumo> consumiPdr = consumiMesePdr.getConsumi(dataInizioTariffa, dataFineTariffa);
        double consumoTotalePdr = AbstractCalcolaTariffeStrategy.getTotale(consumiPdr);
        DateFormat formatter = StrategyCommonHelper.getMeseAnnoDateFormat();
        try {
            if (this.globalErrorHandler.isActive()) {
                this.globalErrorHandler.handleGlobalError(codicePdr);
            } else {
                Date checkConsumi;
                if (this.esportaTariffe) {
                    SafeListMap<String, PrezzoGas> prezziGas = this.mappaPrezziGas.getPrezziGasMese(this.anno, this.mese);
                    List<DettaglioGiorno> dettagli = TariffeGasHelper.buildDettagli(consumiComplessivi);
                    boolean multipunto = consumiGruppo.isMultipunto(codicePdr, dataInizioTariffa, dataFineTariffa);
                    TariffeContratto tariffeContratto = this.tariffaCalculator.calcolaTariffe(contratto, multipunto, dataFineTariffa, consumoTotalePdr, dettagli, prezziGas, consumiGruppo);
                    if (contratto.getTipoApplicazione() != 0) {
                        TariffeGasHelper.addTariffe(this.status, azienda, tariffeContratto);
                    }
                }
                if ((checkConsumi = TariffaDirettoCalculator.checkConsumi(consumiPdr, this.anno, this.mese, contratto)) == null) {
                    if (this.writer != null && this.esportaLetture && !consumiMesePdr.isScivolo() && !codicePdr.equals(this.lastPdr) && !dataFineTariffa.equals(this.lastDataFineTariffa)) {
                        this.lastPdr = codicePdr;
                        this.lastDataFineTariffa = dataFineTariffa;
                        ListWriter meseWriter = TariffeGasHelper.getListWriter(TipoLettura.EFFETTIVA, azienda, dataInizioMese, this.status);
                        this.writer.write(meseWriter, contratto, "", dataFineTariffa, consumoTotalePdr, 0.0, "rcd", false);
                        this.status.count(azienda, "lettura", 1);
                        exported = true;
                    }
                    this.status.addConsumiResult(consumiPdr, StatoMisure.ELABORATO, ErroreElaborazioneGas.OK, "");
                } else {
                    Sentence sentence = TariffeGasHelper.handleMessage(this.dateFormat, "missing.consumi", String.valueOf(codicePdr) + " / " + azienda, checkConsumi, "", this.talkManager);
                    String descrizione = this.talkManager.getMessage(sentence);
                    this.status.addConsumiResult(consumiPdr, StatoMisure.SOSPESO, ErroreElaborazioneGas.MISSING_CONSUMI, descrizione);
                }
            }
        }
        catch (DataNotFoundException exc) {
            ErroreElaborazioneGas errore = StrategyHelper.getErrore(exc);
            String codice = String.valueOf(codicePdr) + " / " + azienda;
            Date date = CalendarTools.getDate(this.anno, this.mese, 1);
            String key = String.valueOf(exc.getKey()) + " / " + formatter.format(date);
            String message = exc.getMessage();
            String descrizione = TariffeGasHelper.handleException(codice, key, message, this.talkManager);
            this.status.addConsumiResult(consumiPdr, StatoMisure.SOSPESO, errore, descrizione);
        }
        catch (InvalidSequenceException exc) {
            PrebillingError errore = exc.getErrore();
            String descrizione = TariffeGasHelper.handleException(this.dateFormat, exc, this.talkManager);
            this.status.addConsumiResult(consumiPdr, StatoMisure.SOSPESO, errore, descrizione);
        }
        catch (InvalidInpcsException | MissingMisuraException exc) {
            PrebillingError errore = exc.getErrore();
            String descrizione = TariffeGasHelper.handleException(this.dateFormat, exc, this.talkManager);
            this.status.addConsumiResult(consumiPdr, StatoMisure.SOSPESO, errore, descrizione);
        }
        catch (InconsistentOptionException exc) {
            PrebillingError errore = exc.getErrore();
            List<Sentence> sentences = this.talkManager.getSentencesNoFlush();
            Sentence sentence = sentences.get(sentences.size() - 1);
            String descrizione = this.talkManager.getMessage(sentence);
            this.status.addConsumiResult(consumiPdr, StatoMisure.SOSPESO, errore, descrizione);
            if (this.bloccoIndice) {
                throw exc;
            }
        }
        catch (IncoherentEndDates exc) {
            Date date = exc.getDate();
            String periodo = formatter.format(date);
            ErroreElaborazioneGas errore = ErroreElaborazioneGas.INCOHERENT_ENDDATES;
            Message sentence = new Message("tariffe", errore.getMessage());
            sentence.addParam(String.valueOf(codicePdr) + "/" + azienda);
            sentence.addParam(periodo);
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            List<MisuraGas> misure = consumiMesePdr.getMisure();
            this.status.addMisureResult(misure, dataFineTariffa, StatoMisure.SOSPESO, errore, descrizione);
            List<Igmg> igmg = consumiMesePdr.getIgmg();
            this.status.addIgmgResult(igmg, StatoMisure.SOSPESO, (PrebillingError)errore, descrizione);
        }
        return exported;
    }

    private static Date checkConsumi(List<? extends Consumo> consumi, int anno, Month mese, ContrattoGas contratto) {
        Date dataInizio = ContrattiHelper.getInizioTariffa(contratto, anno, mese);
        Date dataFine = ContrattiHelper.getFineTariffa(anno, mese, contratto);
        Date expected = dataInizio;
        for (Consumo consumo : consumi) {
            Date dataMisura = consumo.getDataMisura();
            if (dataMisura.before(expected)) continue;
            if (!dataMisura.equals(expected)) break;
            if (expected.equals(dataFine)) {
                expected = null;
                break;
            }
            expected = CalendarTools.nextDay(expected);
        }
        return expected;
    }
}

