/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.utils.ExportHelper;
import biz.elabor.prebilling.common.utils.ListWriter;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationHelper;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.model.TipoLettura;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javatuples.Pair;

public class ExportLettureStrategy
implements GasServiceStrategy {
    protected static final String HEADER = "#LT0000..............................................................................................";
    private final DateFormat monthYearFormatter;
    private final String headerMatr;
    private final PrebillingGasConfiguration configuration;
    private final Funzionalita funzionalita;

    public ExportLettureStrategy(PrebillingGasConfiguration configuration, Funzionalita funzionalita) {
        this.configuration = configuration;
        this.funzionalita = funzionalita;
        this.monthYearFormatter = StrategyHelper.getShortMonthYearFormatter();
        int lunghezzaMatricola = configuration.getLunghezzaMatricola();
        this.headerMatr = ExportHelper.fixedLength("", lunghezzaMatricola).replaceAll(" ", ".");
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        boolean ok;
        try {
            String idEsecuzione = status.getIdEsecuzione();
            DateFormat annoMeseDateFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
            DateFormat timestampFormat = StrategyHelper.getTimestampFormat();
            Map<Pair<TipoLettura, String>, Map<Date, ListWriter>> letstdWriterMap = status.getLetstdWriter();
            for (Map.Entry<Pair<TipoLettura, String>, Map<Date, ListWriter>> aziendaEntry : letstdWriterMap.entrySet()) {
                Pair<TipoLettura, String> key = aziendaEntry.getKey();
                String prefix = "gas-" + (key.getValue0() == TipoLettura.STIMA ? "stime" : "let-std");
                String azienda = key.getValue1();
                for (Map.Entry<Date, ListWriter> meseEntry : aziendaEntry.getValue().entrySet()) {
                    Date date = meseEntry.getKey();
                    File folder = ConfigurationHelper.getResellerTmpLettureFolder(this.configuration, idEsecuzione, azienda, this.funzionalita);
                    String annoMese = annoMeseDateFormat.format(date);
                    String timestamp = timestampFormat.format(new Date());
                    String fileName = String.valueOf(prefix) + "-" + azienda + "-" + annoMese + "-" + timestamp + ".txt";
                    File file = new File(folder, fileName);
                    Throwable throwable = null;
                    Object var21_23 = null;
                    try (PrintWriter writer = new PrintWriter(file);){
                        String lettura = this.monthYearFormatter.format(date);
                        writer.print(String.valueOf(HEADER.replace("0000", lettura)) + this.headerMatr + "\r\n");
                        for (String riga : meseEntry.getValue()) {
                            writer.print(riga);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Logger logger = status.getLogger();
            logger.log(Level.SEVERE, "export letture", exc);
            ok = false;
        }
        return ok;
    }
}

