/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.common.BasicServiceStatus;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.utils.MissingCodicePerseoException;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.Cliente;
import biz.elabor.prebilling.gas.dao.misure.model.ConsumoDiretto;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.common.DownloadPerseoHelper;
import biz.elabor.prebilling.gas.services.tariffe.ConsumoRemi;
import biz.elabor.prebilling.gas.services.tariffe.DataMisuraExtractor;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class DownloadDirettiGas
implements GasServiceStrategy {
    private final int anno;
    private final Month mese;
    private final MisureGasDao misureDao;
    private final String direttiBaseUrl;
    private final TalkManager talkManager;
    private final DateFormat plainDateFormat;

    public DownloadDirettiGas(int anno, Month mese, MisureGasDao misureDao, PrebillingGasConfiguration configuration, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.misureDao = misureDao;
        this.direttiBaseUrl = configuration.getDirettiBaseUrl();
        this.talkManager = talkManager;
        this.plainDateFormat = StrategyHelper.getPlainDateFormat();
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        boolean ok;
        try {
            if (this.direttiBaseUrl != null && !this.direttiBaseUrl.trim().isEmpty()) {
                List<Cliente> clientiDiretti = this.misureDao.getDiretti(this.anno, this.mese);
                HashSet<String> elencoRemi = new HashSet<String>();
                for (Cliente cliente : clientiDiretti) {
                    this.downloadDiretto(cliente, elencoRemi, status);
                }
            }
            ok = true;
        }
        catch (IOException exc) {
            ok = false;
            Message sentence = new Message("consumi", "dwnl.failed");
            sentence.addParam(exc.toString());
            this.talkManager.addSentence(sentence);
            String userMessage = this.talkManager.getMessage(sentence);
            Logger logger = status.getLogger();
            logger.log(Level.SEVERE, userMessage, exc);
        }
        return ok;
    }

    private void downloadDiretto(Cliente cliente, Set<String> elencoRemi, BasicServiceStatus status) throws IOException {
        ElaborCalendar calendar = new ElaborCalendar(this.anno, this.mese);
        Date startDate = calendar.getDate();
        calendar.addMesi(1);
        calendar.addGiorni(-1);
        Date endDate = calendar.getDate();
        String codiceRemi = cliente.getCodiceRemi();
        try {
            DownloadDirettiGas.checkMultipleRemi(elencoRemi, startDate, endDate, codiceRemi);
            elencoRemi.add(codiceRemi);
            if (this.checkConsumi(codiceRemi)) {
                Logger logger = status.getLogger();
                this.saveConsumi(cliente, startDate, endDate, logger);
            }
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("consumi", message);
            sentence.addParam(exc.getKey());
            this.talkManager.addSentence(sentence);
        }
        catch (MissingCodicePerseoException exc) {
            Message sentence = new Message("consumi", "perseo.error");
            sentence.addParam(cliente.getCodicePdr());
            sentence.addParam("");
            sentence.addParam(exc.getAmbito());
            this.talkManager.addSentence(sentence);
        }
    }

    private static void checkMultipleRemi(Set<String> elencoRemi, Date startDate, Date endDate, String codiceRemi) throws DataNotFoundException {
        if (elencoRemi.contains(codiceRemi)) {
            DateFormat standardDateFormat = StrategyCommonHelper.getStandardDateFormat();
            String startDateFmt = standardDateFormat.format(startDate);
            String endDateFmt = standardDateFormat.format(endDate);
            String key = String.valueOf(codiceRemi) + " - " + startDateFmt + " / " + endDateFmt;
            throw new DataNotFoundException("remi.non.unico", key, -1);
        }
    }

    private boolean checkConsumi(String codiceRemi) {
        DataMisuraExtractor extractor;
        List<ConsumoDiretto> consumi = this.misureDao.getConsumiDiretti(codiceRemi, this.anno, this.mese);
        return !StrategyHelper.checkComplete(consumi, this.anno, this.mese, extractor = new DataMisuraExtractor());
    }

    private void saveConsumi(Cliente cliente, Date startDate, Date endDate, Logger logger) throws IOException, DataNotFoundException, MissingCodicePerseoException {
        List<ConsumoRemi> consumiRemi = DownloadPerseoHelper.downloadConsumiRemi(cliente, startDate, endDate, this.direttiBaseUrl, logger);
        this.saveConsumi(cliente, consumiRemi);
    }

    private void saveConsumi(Cliente cliente, List<ConsumoRemi> consumiRemi) {
        Date dtFinCom;
        Date endDate;
        Date inizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
        Date fineMese = CalendarTools.getEndDate(this.anno, this.mese);
        Date dtIniCom = cliente.getDtIniCom();
        Date startDate = CalendarTools.max(inizioMese, dtIniCom);
        if (DownloadPerseoHelper.checkDates(startDate, endDate = CalendarTools.min(fineMese, dtFinCom = cliente.getDtFinCom()), consumiRemi)) {
            String codiceRemi = cliente.getCodiceRemi();
            String codicePdr = cliente.getCodicePdr();
            for (ConsumoRemi consumoRemi : consumiRemi) {
                Date dataMisura = consumoRemi.getDataMisura();
                double consumo = consumoRemi.getConsumo();
                this.misureDao.saveConsumo(dataMisura, consumo, codiceRemi, codicePdr);
            }
        } else {
            Message sentence = new Message("consumi", "consumi.incompleti");
            sentence.addParam(cliente.getCodicePdr());
            sentence.addParam(cliente.getCodiceRemi());
            sentence.addParam(this.plainDateFormat.format(startDate));
            sentence.addParam(this.plainDateFormat.format(endDate));
            this.talkManager.addSentence(sentence);
        }
    }
}

