/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.gas.dao.misure.model.Igmg;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.services.common.IgmgResult;
import biz.elabor.prebilling.gas.services.common.MisuraGasResult;
import biz.elabor.prebilling.gas.services.tariffe.model.Consumo;
import biz.elabor.prebilling.gas.services.tariffe.model.FlussoMisura;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ConsumiMesePdr {
    private final List<? extends Consumo> consumi;
    private final List<MisuraGas> misure;
    private final List<Igmg> igmg;
    private final List<IgmgResult> igmgResults;
    private final double coeffCorr;
    private final String matrConv;
    private final String matrLett;
    private final boolean trattate;
    private final boolean scivolo;
    private final List<MisuraGasResult> results;
    private final double qtconsum;
    private final List<MisuraGas> misureVoltura;

    public ConsumiMesePdr(List<? extends Consumo> consumi, List<MisuraGas> misure, List<MisuraGas> misureVoltura, List<Igmg> igmg, List<IgmgResult> igmgResults, String matrConv, String matrLett, double coeffCorr, boolean trattate, boolean scivolo, List<MisuraGasResult> results, double qtconsum) {
        this.consumi = consumi;
        this.misure = misure;
        this.misureVoltura = misureVoltura;
        this.igmg = igmg;
        this.igmgResults = igmgResults;
        this.coeffCorr = coeffCorr;
        this.matrConv = matrConv;
        this.matrLett = matrLett;
        this.trattate = trattate;
        this.scivolo = scivolo;
        this.results = results;
        this.qtconsum = qtconsum;
    }

    public List<MisuraGas> getMisure() {
        return this.misure;
    }

    public List<Igmg> getIgmg() {
        return this.igmg;
    }

    public List<IgmgResult> getIgmgResults() {
        return this.igmgResults;
    }

    public boolean isTrattate() {
        return this.trattate;
    }

    public List<Consumo> getConsumi(Date dataInizioTariffa, Date dataFineTariffa) {
        return ConsumiMesePdr.getItems(this.consumi, dataInizioTariffa, dataFineTariffa);
    }

    private static <T extends FlussoMisura> List<T> getItems(List<? extends T> values, Date inizio, Date fine) {
        ArrayList<FlussoMisura> items = new ArrayList<FlussoMisura>();
        for (FlussoMisura item : values) {
            Date date = item.getDataMisura();
            if (date.before(inizio) || date.after(fine)) continue;
            items.add(item);
        }
        return items;
    }

    public String getMatrLett() {
        return this.matrLett;
    }

    public String getMatrConv() {
        return this.matrConv;
    }

    public double getCoeffCorr() {
        return this.coeffCorr;
    }

    public boolean isScivolo() {
        return this.scivolo;
    }

    public List<MisuraGasResult> getResults() {
        return this.results;
    }

    public double getQtconsum() {
        return this.qtconsum;
    }

    public List<MisuraGas> getMisureVoltura() {
        return this.misureVoltura;
    }
}

