/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.pcs;

import biz.elabor.prebilling.common.FileCopyHelper;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationHelper;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.model.Cliente;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.pcs.PcsAzienda;
import biz.elabor.prebilling.gas.services.pcs.PcsRemi;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.text.Format;

public class ExportPcsStrategy
implements GasServiceStrategy {
    private final int anno;
    private final Month mese;
    private final String target;
    private final PrebillingGasConfiguration configuration;
    private final Funzionalita funzionalita;

    public ExportPcsStrategy(int annoRif, Month meseRif, String target, PrebillingGasConfiguration configuration, Funzionalita funzionalita) {
        this.anno = annoRif;
        this.mese = meseRif;
        this.target = target;
        this.configuration = configuration;
        this.funzionalita = funzionalita;
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        boolean ok;
        Map<String, PcsAzienda> pcsMap = status.getAziendaRemiMap();
        try {
            String idEsecuzione = status.getIdEsecuzione();
            for (Map.Entry<String, PcsAzienda> entry : pcsMap.entrySet()) {
                String azienda = entry.getKey();
                PcsAzienda pcsAzienda = entry.getValue();
                if (pcsAzienda.isEmpty()) continue;
                this.printPcsAzienda(idEsecuzione, azienda, pcsAzienda, status);
                this.printDettaglioPcs(idEsecuzione, azienda, pcsAzienda);
            }
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Logger logger = status.getLogger();
            logger.log(Level.SEVERE, "export pcs", exc);
            ok = false;
        }
        return ok;
    }

    private void printDettaglioPcs(String idEsecuzione, String azienda, PcsAzienda pcsAzienda) throws FileNotFoundException {
        File folder = ConfigurationHelper.getResellerTmpPcsFolder(this.configuration, idEsecuzione, azienda, this.funzionalita);
        DateFormat timestampFormat = StrategyHelper.getTimestampFormat();
        String timestamp = timestampFormat.format(new Date());
        for (PcsRemi pcsRemi : pcsAzienda.getPcsRemi()) {
            DateFormat annoMeseDateFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
            Date date = CalendarTools.getDate(this.anno, this.mese, 1);
            String annoMese = annoMeseDateFormat.format(date);
            Cliente cliente = pcsRemi.getCliente();
            String codiceRemi = cliente.getCodiceRemi();
            Date startDate = StrategyHelper.getStartDate(this.anno, this.mese, cliente);
            String fileName = "pcs-" + azienda + "-" + annoMese + "-" + codiceRemi + "-" + timestamp + ".csv";
            File folderAnnoMese = new File(folder, annoMese);
            folderAnnoMese.mkdirs();
            File outFile = new File(folderAnnoMese, fileName);
            DecimalFormat valueFormat = Format.newDecimalFormat(Locale.ITALIAN, "#####0.000000");
            Throwable throwable = null;
            Object var20_21 = null;
            try (PrintWriter writer = new PrintWriter(outFile);){
                writer.println("remi;" + codiceRemi);
                writer.println("mese;" + this.anno + "/" + this.mese.getIndex());
                writer.println("somma consumi;" + valueFormat.format(pcsRemi.getSommaConsumi()));
                writer.println("pcs medio;" + valueFormat.format(pcsRemi.getPcsMedio()));
                writer.println(";;giorno;consumo;pcs;valore");
                List<Double> consumi = pcsRemi.getConsumiMese();
                List<Double> pcsMese = pcsRemi.getPcsMese();
                Iterator<Double> pcsIterator = pcsMese.iterator();
                Iterator<Double> conIterator = consumi.iterator();
                int giorno = CalendarTools.getGiorno(startDate);
                while (pcsIterator.hasNext() && conIterator.hasNext()) {
                    double pcs = pcsIterator.next();
                    double consumo = conIterator.next();
                    writer.println(";;" + giorno + ";" + valueFormat.format(consumo) + ";" + valueFormat.format(pcs) + ";" + valueFormat.format(pcs * consumo));
                    ++giorno;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void printPcsAzienda(String idEsecuzione, String azienda, PcsAzienda pcsAzienda, GasServiceStatus status) throws FileNotFoundException {
        File folder = this.getFolder(idEsecuzione, azienda);
        DateFormat timestampFormat = StrategyHelper.getTimestampFormat();
        String timestamp = timestampFormat.format(new Date());
        DateFormat annoMeseDateFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
        Date date = CalendarTools.getDate(this.anno, this.mese, 1);
        String annoMese = annoMeseDateFormat.format(date);
        String fileName = "gas-pcs-" + azienda + "-" + annoMese + "-" + timestamp + ".csv";
        File outFile = new File(folder, fileName);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        DecimalFormat valueFormat = Format.newDecimalFormat(Locale.ITALIAN, "000.000");
        Throwable throwable = null;
        Object var16_17 = null;
        try (PrintWriter writer = new PrintWriter(outFile);){
            writer.println("PCSMensileGas");
            List<PcsRemi> pcsRemiList = pcsAzienda.getPcsRemi();
            for (PcsRemi pcsRemi : pcsRemiList) {
                Cliente cliente = pcsRemi.getCliente();
                String codiceRemi = cliente.getCodiceRemi();
                double pcsMedio = pcsRemi.getPcsMedio();
                Date startDate = StrategyHelper.getStartDate(this.anno, this.mese, cliente);
                String dateFmt = dateFormat.format(startDate);
                String pcsFmt = valueFormat.format(pcsMedio);
                writer.println(String.valueOf(codiceRemi) + ";" + dateFmt + ";" + pcsFmt);
            }
            status.count(azienda, "pcs", pcsRemiList.size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private File getFolder(String idEsecuzione, String azienda) {
        File folder = this.target.equalsIgnoreCase("file") ? ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, this.funzionalita) : FileCopyHelper.getResellerCodaTmpFolder(this.configuration, idEsecuzione, azienda);
        return folder;
    }
}

