/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services;

import biz.elabor.prebilling.gas.dao.misure.model.Cliente;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.exceptions.BasicKeyException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.text.Format;

public class StrategyHelper {
    public static DateFormat getPlainDateFormat() {
        return new SimpleDateFormat("dd-MM-yyyy");
    }

    public static DateFormat getLongDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static DateFormat getTimestampFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    public static DateFormat getShortDateFormat() {
        return new SimpleDateFormat("dd/MM/yy");
    }

    public static DateFormat getMediumDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public static DateFormat getShortMonthYearFormatter() {
        return new SimpleDateFormat("MMyy");
    }

    public static DecimalFormat getQuattroFormat() {
        return Format.newDecimalFormat(Locale.ITALIAN, "0000");
    }

    public static DecimalFormat getNoveFormat() {
        return Format.newDecimalFormat(Locale.ITALIAN, "000000000");
    }

    public static DecimalFormat getDodiciFormat() {
        return Format.newDecimalFormat(Locale.ITALIAN, "000000000.0+;000000000.0-");
    }

    public static DecimalFormat getSetteFormat() {
        return Format.newDecimalFormat(Locale.ITALIAN, "000.00+;000.00-");
    }

    public static DecimalFormat getImportoFormat() {
        return Format.newDecimalFormat(Locale.ITALIAN, "#####0.00000000");
    }

    public static DecimalFormat getConsumoFormat() {
        return Format.newDecimalFormat(Locale.ITALIAN, "#####0.000000");
    }

    public static DecimalFormat getPrezzoFormat() {
        return Format.newDecimalFormat(Locale.ITALIAN, "#####0.000000");
    }

    public static DecimalFormat getPcsFormat() {
        return Format.newDecimalFormat(Locale.ITALIAN, "#####0.000+");
    }

    public static boolean isNull(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static String getDescrizione(ErroreElaborazioneGas errore, List<String> params, TalkManager talkManager) {
        String messaggio = errore.getMessage();
        Message sentence = new Message("tariffe", messaggio);
        if (params != null) {
            sentence.setParams(params);
        }
        return talkManager.getMessage(sentence);
    }

    public static ErroreElaborazioneGas getErrore(BasicKeyException exc) {
        int ordinal = exc.getError();
        return ErroreElaborazioneGas.values()[ordinal];
    }

    public static <T> boolean checkComplete(List<T> consumi, int anno, Month mese, KeyExtractor<Date, T> extractor) {
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        Iterator<T> iterator = consumi.iterator();
        boolean complete = true;
        while (complete && iterator.hasNext()) {
            T consumo = iterator.next();
            Date data = extractor.getKey(consumo);
            complete = data.equals(calendar.getDate());
            calendar.addGiorni(1);
        }
        return complete &= mese != calendar.getMese() && calendar.getGiorno() == 1;
    }

    public static boolean checkEsportaLetture(String esportaLetture) {
        return esportaLetture.equals("SI");
    }

    public static Date getStartDate(int anno, Month mese, Cliente cliente) {
        Date inizioMese = CalendarTools.getDate(anno, mese, 1);
        Date dtIniCom = cliente.getDtIniCom();
        return CalendarTools.max(inizioMese, dtIniCom);
    }

    public static Date getEndDate(int anno, Month mese, Cliente cliente) {
        Date fineMese = CalendarTools.getEndDate(anno, mese);
        Date dtFinCom = cliente.getDtFinCom();
        return CalendarTools.min(fineMese, dtFinCom);
    }
}

