/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services;

import biz.elabor.prebilling.common.BasicServiceStatus;
import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.common.utils.ListWriter;
import biz.elabor.prebilling.gas.dao.misure.model.Igmg;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.TipoLettura;
import biz.elabor.prebilling.gas.services.common.ConsumoResult;
import biz.elabor.prebilling.gas.services.common.IgmgResult;
import biz.elabor.prebilling.gas.services.common.MisuraGasResult;
import biz.elabor.prebilling.gas.services.pcs.PcsAzienda;
import biz.elabor.prebilling.gas.services.tariffe.TariffePdr;
import biz.elabor.prebilling.gas.services.tariffe.model.Consumo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javatuples.Pair;

public class GasServiceStatus
extends BasicServiceStatus {
    private static final List<String> FLUSSI_PERIODICI = Arrays.asList("TGL", "TMV");
    private Map<String, Map<String, Map<String, TariffePdr>>> tariffe = new HashMap<String, Map<String, Map<String, TariffePdr>>>();
    private List<MisuraGasResult> misureResult = new ArrayList<MisuraGasResult>();
    private List<MisuraGasResult> rettificheResult = new ArrayList<MisuraGasResult>();
    private List<IgmgResult> igmgResult = new ArrayList<IgmgResult>();
    private List<ConsumoResult> consumiResult = new ArrayList<ConsumoResult>();
    private Map<Pair<TipoLettura, String>, Map<Date, ListWriter>> letstdWriter = new HashMap<Pair<TipoLettura, String>, Map<Date, ListWriter>>();
    private Map<String, PcsAzienda> aziendaRemiMap = new HashMap<String, PcsAzienda>();
    private File file;

    public GasServiceStatus(String idEsecuzione) {
        super(idEsecuzione);
    }

    public Map<String, Map<String, Map<String, TariffePdr>>> getTariffe() {
        return this.tariffe;
    }

    public void addMisuraResult(MisuraGas misura, StatoMisure stato, PrebillingError errore, String descrizione) {
        MisuraGasResult result = new MisuraGasResult(misura, stato, errore, descrizione);
        this.misureResult.add(result);
    }

    public void addIgmgResult(Igmg igmg, StatoMisure stato, PrebillingError errore, String descrizione) {
        IgmgResult result = new IgmgResult(igmg, stato, errore, descrizione);
        this.igmgResult.add(result);
    }

    private void addConsumoResult(Consumo consumo, StatoMisure stato, PrebillingError errore, String descrizione) {
        ConsumoResult result = new ConsumoResult(consumo, stato, errore, descrizione);
        this.consumiResult.add(result);
    }

    public List<ConsumoResult> getConsumiResult() {
        return this.consumiResult;
    }

    public List<MisuraGasResult> getMisureResult() {
        return this.misureResult;
    }

    public List<IgmgResult> getIgmgResult() {
        return this.igmgResult;
    }

    public void addRettificaResult(MisuraGas misura, StatoMisure stato, PrebillingError errore, String descrizione) {
        MisuraGasResult result = new MisuraGasResult(misura, stato, errore, descrizione);
        this.rettificheResult.add(result);
    }

    public List<MisuraGasResult> getRettificheResult() {
        return this.rettificheResult;
    }

    public void addMisureResult(List<MisuraGas> misure, Date endDate, StatoMisure stato, PrebillingError errore, String descrizione) {
        for (MisuraGas misura : misure) {
            Date dataMisura = misura.getDataMisura();
            boolean trattato = misura.getStatoMisura().isTrattato();
            if (dataMisura.after(endDate) || trattato) continue;
            if (FLUSSI_PERIODICI.contains(misura.getFlusso())) {
                this.addMisuraResult(misura, stato, errore, descrizione);
                continue;
            }
            this.addRettificaResult(misura, stato, errore, descrizione);
        }
    }

    public void addIgmgResult(List<Igmg> misure, StatoMisure stato, PrebillingError errore, String descrizione) {
        for (Igmg misura : misure) {
            this.addIgmgResult(misura, stato, errore, descrizione);
        }
    }

    public void addConsumiResult(List<? extends Consumo> consumi, StatoMisure stato, PrebillingError errore, String descrizione) {
        for (Consumo consumo : consumi) {
            this.addConsumoResult(consumo, stato, errore, descrizione);
        }
    }

    public Map<Pair<TipoLettura, String>, Map<Date, ListWriter>> getLetstdWriter() {
        return this.letstdWriter;
    }

    public void addIgmgResults(List<IgmgResult> result) {
        this.igmgResult.addAll(result);
    }

    public void addMisureResults(List<MisuraGasResult> misureResults) {
        for (MisuraGasResult result : misureResults) {
            this.addMisuraResult(result);
        }
    }

    public void addMisuraResult(MisuraGasResult result) {
        if (((MisuraGas)result.getRecord()).getFlusso().toLowerCase().equals("rgl")) {
            this.rettificheResult.add(result);
        } else {
            this.misureResult.add(result);
        }
    }

    public void setPcsAziende(Map<String, PcsAzienda> pcsMap) {
        this.aziendaRemiMap = pcsMap;
    }

    public Map<String, PcsAzienda> getAziendaRemiMap() {
        return this.aziendaRemiMap;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }
}

