/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.dao.misure.model;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.gas.dao.misure.model.TipoLettura;
import biz.elabor.prebilling.gas.services.tariffe.model.BasicIdFlussoGas;
import biz.elabor.prebilling.gas.services.tariffe.model.FlussoMisura;
import java.util.Date;

public class MisuraGas
extends BasicIdFlussoGas
implements FlussoMisura,
Comparable<MisuraGas> {
    private final String flusso;
    private final String codicePdr;
    private final Date dataMisura;
    private final TipoLettura tipoLettura;
    private final String matrMis;
    private final String matrConv;
    private double segnanteMisuratore;
    private double segnanteConvertitore;
    private final double coeffCorr;
    private final boolean ingresso;

    public MisuraGas(String id, String flusso, String codicePdr, Date dataMisura, TipoLettura tipoLettura, String matrMis, String matrConv, double segnanteMisuratore, double segnanteConvertitore, double coeffCorr, boolean ingresso, StatoMisure stato) {
        super(id, stato);
        this.flusso = flusso;
        this.codicePdr = codicePdr;
        this.dataMisura = dataMisura;
        this.tipoLettura = tipoLettura;
        this.matrMis = matrMis;
        this.matrConv = matrConv;
        this.segnanteMisuratore = segnanteMisuratore;
        this.segnanteConvertitore = segnanteConvertitore;
        this.coeffCorr = coeffCorr;
        this.ingresso = ingresso;
    }

    public String getFlusso() {
        return this.flusso;
    }

    public String getCodicePdr() {
        return this.codicePdr;
    }

    public TipoLettura getTipoLettura() {
        return this.tipoLettura;
    }

    public double getSegnante() {
        return this.hasConvertitore() ? this.segnanteConvertitore : this.segnanteMisuratore;
    }

    public double getSegnanteMisuratore() {
        return this.segnanteMisuratore;
    }

    public double getSegnanteConvertitore() {
        return this.segnanteConvertitore;
    }

    @Override
    public Date getDataMisura() {
        return this.dataMisura;
    }

    public String getMatrMis() {
        return this.matrMis;
    }

    public String getMatrConv() {
        return this.matrConv;
    }

    public double getCoeffCorr() {
        return this.hasConvertitore() ? 1.0 : this.coeffCorr;
    }

    public boolean hasIngresso() {
        return this.ingresso;
    }

    @Override
    public int compareTo(MisuraGas misuraGas) {
        return this.dataMisura.compareTo(misuraGas.getDataMisura()) * 10 - this.tipoLettura.compareTo(misuraGas.getTipoLettura());
    }

    public boolean hasConvertitore() {
        return this.matrConv != null && !this.matrConv.trim().isEmpty();
    }

    public boolean isStimata() {
        return this.tipoLettura.isStimata();
    }

    public void setSegnanteConvertitore(double segnante) {
        this.segnanteConvertitore = segnante;
    }

    public void setSegnanteMisuratore(double segnante) {
        this.segnanteMisuratore = segnante;
    }
}

