/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.dao.misure;

import biz.elabor.prebilling.gas.dao.misure.DeleteTariffeElaborateHandler;
import biz.elabor.prebilling.gas.dao.misure.InsertTariffeElaborateHandler;
import biz.elabor.prebilling.gas.dao.misure.UpsertTariffeHandler;
import biz.elabor.prebilling.gas.services.tariffe.TariffePdr;
import biz.elabor.prebilling.gas.services.tariffe.TariffePdrData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.homelinux.elabor.db.MultiUpdateHandler;
import org.homelinux.elabor.exceptions.UnrecoverableException;

class TariffeUpsertHandler
implements MultiUpdateHandler {
    private final Map<String, Map<String, Map<String, TariffePdr>>> tariffe;
    private final Connection connection;

    public TariffeUpsertHandler(Map<String, Map<String, Map<String, TariffePdr>>> tariffe, Connection connection) {
        this.connection = connection;
        this.tariffe = tariffe;
    }

    @Override
    public void executeMultiUpdate() throws SQLException, UnrecoverableException {
        this.upsertTariffeElaborate(new DeleteTariffeElaborateHandler());
        this.upsertTariffeElaborate(new InsertTariffeElaborateHandler());
    }

    private void upsertTariffeElaborate(UpsertTariffeHandler handler) throws SQLException, UnrecoverableException {
        String query = handler.getQuery();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PreparedStatement statement = this.connection.prepareStatement(query);){
                int count = 0;
                for (Map<String, Map<String, TariffePdr>> value : this.tariffe.values()) {
                    count += TariffeUpsertHandler.upsertTariffeElaborateAzienda(statement, handler, value);
                }
                if (count > 0) {
                    statement.clearParameters();
                    statement.executeBatch();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException exc) {
            throw new UnrecoverableException(exc);
        }
    }

    private static int upsertTariffeElaborateAzienda(PreparedStatement statement, UpsertTariffeHandler handler, Map<String, Map<String, TariffePdr>> tariffe) throws SQLException {
        int count = 0;
        for (Map<String, TariffePdr> value : tariffe.values()) {
            count += TariffeUpsertHandler.upsertTariffeElaborateMese(statement, handler, value);
        }
        return count;
    }

    private static int upsertTariffeElaborateMese(PreparedStatement statement, UpsertTariffeHandler handler, Map<String, TariffePdr> tariffe) throws SQLException {
        int count = 0;
        for (Map.Entry<String, TariffePdr> entry : tariffe.entrySet()) {
            TariffePdr value = entry.getValue();
            count += TariffeUpsertHandler.upsertTariffeElaboratePdr(statement, handler, value);
        }
        return count;
    }

    private static int upsertTariffeElaboratePdr(PreparedStatement statement, UpsertTariffeHandler handler, TariffePdr tariffe) throws SQLException {
        HashSet<Date> dates = new HashSet<Date>();
        for (Map.Entry<Date, TariffePdrData> entry : tariffe.entrySet()) {
            Date date = entry.getKey();
            TariffePdrData tariffa = entry.getValue();
            if (!dates.add(date)) continue;
            handler.prepare(statement, tariffa);
            statement.addBatch();
        }
        return dates.size();
    }
}

