/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.dao.giada;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.common.model.IdContratto;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.homelinux.elabor.db.RecordCreator;

public class ContrattoGasCreator
implements RecordCreator<ContrattoGas> {
    private final DateFormat dateFormat = BasicRecordCreatorHelper.getDateFormat();
    private final DecimalFormat doubleFormat = BasicRecordCreatorHelper.getDoubleFormat();

    @Override
    public ContrattoGas createRecord(ResultSet rs) throws SQLException {
        String codicePod = rs.getString("cdprerif").trim();
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
        String azienda = rs.getString("cdazirif").trim();
        Date dataValidita = BasicRecordCreatorHelper.getDate(rs, "dtvalidi", this.dateFormat);
        int numFasce = rs.getInt("nnfascia");
        String cdindene = BasicRecordCreatorHelper.getOptionalString(rs, "cdindene", "0");
        String cdindneg = BasicRecordCreatorHelper.getOptionalString(rs, "cdindneg", "0");
        int tipoApplicazione = rs.getInt("cctariff");
        Date dataSospensione = BasicRecordCreatorHelper.getDate(rs, "dtsospen", this.dateFormat);
        Date dataScadenza = BasicRecordCreatorHelper.getDate(rs, "dtscaden", this.dateFormat);
        Date dataRevoca = BasicRecordCreatorHelper.getDate(rs, "dtrevoca", this.dateFormat);
        Date dataInizio = BasicRecordCreatorHelper.getDate(rs, "inizio", this.dateFormat);
        Date dataFine = BasicRecordCreatorHelper.getDate(rs, "fine", this.dateFormat);
        IdContratto idContratto = ContrattoGasCreator.createId(rs);
        String cdUteRif = rs.getString("cduterif").trim();
        String cdProPre = rs.getString("cdpropre").trim();
        String codiceOfferta = rs.getString("codice_offerta");
        double aqconsum = BasicRecordCreatorHelper.getDouble(rs, "aqconsum", this.doubleFormat);
        double emtaruni = BasicRecordCreatorHelper.getDouble(rs, "emtaruni", this.doubleFormat);
        double emspread = BasicRecordCreatorHelper.getDouble(rs, "emspread", this.doubleFormat);
        double emspreneg = BasicRecordCreatorHelper.getDouble(rs, "emspreneg", this.doubleFormat);
        int numCifre = rs.getInt("nucifre");
        String matricola = rs.getString("matricola").trim();
        double segnanteLett = BasicRecordCreatorHelper.getDouble(rs, "nuletpre_cont", this.doubleFormat);
        double segnanteCorr = BasicRecordCreatorHelper.getDouble(rs, "nuletpre_corr", this.doubleFormat);
        double coeffCorr = BasicRecordCreatorHelper.getDouble(rs, "incoecor", this.doubleFormat);
        Date dataLetPre = BasicRecordCreatorHelper.getDate(rs, "dtletpre", this.dateFormat);
        boolean diretto = rs.getString("diretto").trim().equals("D");
        String codiceRemi = rs.getString("cdremi").trim();
        double inpcsAcquisto = BasicRecordCreatorHelper.getDouble(rs, "u85_inpcs", this.doubleFormat);
        double qtconfla = BasicRecordCreatorHelper.getDouble(rs, "qtconfla", this.doubleFormat);
        Date dtmisora = BasicRecordCreatorHelper.getDate(rs, "dtmisora", this.dateFormat);
        boolean fixing = BasicRecordCreatorHelper.getBoolean(rs, "flfixing");
        int tipoAppPenale = ContrattoGasCreator.getInt(rs, "cdapppen");
        double qtconsum = BasicRecordCreatorHelper.getDouble(rs, "qtconsum", this.doubleFormat);
        double qtindene = BasicRecordCreatorHelper.getDouble(rs, "qtindene", this.doubleFormat);
        Date dtindice = BasicRecordCreatorHelper.getDate(rs, "dtindice", this.dateFormat);
        return new ContrattoGas(codicePod, azienda, dataValidita, numFasce, idContratto, tipoApplicazione, cdindene, dataSospensione, dataRevoca, dataInizio, dataFine, dataScadenza, cdUteRif, cdProPre, codiceOfferta, aqconsum, numCifre, matricola, segnanteLett, segnanteCorr, dataLetPre, coeffCorr, diretto, codiceRemi, inpcsAcquisto, qtconfla, dtmisora, emtaruni, emspread, emspreneg, cdindneg, fixing, tipoAppPenale, qtconsum, qtindene, dtindice);
    }

    private static int getInt(ResultSet rs, String name) {
        int value;
        try {
            value = rs.getInt(name);
        }
        catch (Exception exc) {
            value = 0;
        }
        return value;
    }

    private static IdContratto createId(ResultSet rs) throws SQLException {
        int codAzienda = rs.getInt("cdaziend");
        int codZona = rs.getInt("cdzona");
        int codUtente = rs.getInt("cdutente");
        return new IdContratto(codAzienda, codZona, codUtente);
    }
}

