/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.homelinux.elabor.text.Format;
import org.homelinux.elabor.tools.StringUtils;

public class BasicRecordCreatorHelper {
    public static DecimalFormat getDoubleFormat() {
        return Format.newDecimalFormat(Locale.US, "###.###");
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static <E extends Enum<E>> E getEnum(ResultSet rs, Class<E> enumClass, String name) throws SQLException {
        E enumValue;
        String value = rs.getString(name);
        try {
            enumValue = Enum.valueOf(enumClass, value);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return enumValue;
    }

    public static Date getDate(ResultSet rs, String name, DateFormat format, Date defaultValue) throws SQLException {
        Date date;
        String value = rs.getString(name);
        try {
            date = value == null || value.trim().isEmpty() ? defaultValue : format.parse(value);
        }
        catch (ParseException e2) {
            throw new RuntimeException(e2);
        }
        return date;
    }

    public static Date getDate(ResultSet rs, String name, DateFormat format) throws SQLException {
        return BasicRecordCreatorHelper.getDate(rs, name, format, null);
    }

    public static boolean getBoolean(ResultSet rs, String name) throws SQLException {
        String value = rs.getString(name);
        return value == null ? false : "SYT1".contains(value.toUpperCase());
    }

    public static <E extends Enum<E>> E getEnum(ResultSet rs, Class<E> enumClass, String name, E defaultValue) throws SQLException {
        String value = rs.getString(name);
        return BasicRecordCreatorHelper.getEnum(value, enumClass, defaultValue);
    }

    public static <E extends Enum<E>> E getEnum(String value, Class<E> enumClass, E defaultValue) {
        E enumValue;
        try {
            enumValue = Enum.valueOf(enumClass, value);
        }
        catch (Exception exc) {
            enumValue = defaultValue;
        }
        return enumValue;
    }

    public static double getDouble(ResultSet rs, String name, DecimalFormat format) throws SQLException {
        double value;
        String strValue = rs.getString(name);
        try {
            value = format.parse(strValue).doubleValue();
        }
        catch (Exception exc) {
            value = 0.0;
        }
        return value;
    }

    public static String getOptionalString(ResultSet rs, String name, String defaultValue) throws SQLException {
        String value = rs.getString(name);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }
}

