/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common;

import biz.elabor.prebilling.common.PrebillingController;
import biz.elabor.prebilling.common.config.BasicPrebillingConfiguration;
import biz.elabor.prebilling.common.config.GenericConfigurationInstance;
import biz.elabor.prebilling.common.config.InvalidConfigurationException;
import biz.elabor.prebilling.util.GenericJsonRequestHandler;
import biz.elabor.prebilling.util.JsonHelper;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.ui.ModelMap;

public abstract class AbstractController<C extends GenericConfigurationInstance>
implements PrebillingController {
    protected final String messageId;
    @Autowired
    private MessageSource messageSource;

    protected abstract C loadConfigurationInstance(String var1) throws InvalidConfigurationException, IOException;

    public AbstractController(String messageId) {
        this.messageId = messageId;
    }

    protected TalkManager getTalkManager() {
        TalkManager talkManager = new TalkManager();
        talkManager.setMessageSource(this.messageSource);
        talkManager.setLocale(Locale.ITALIAN);
        return talkManager;
    }

    public String handleJsonRequest(String config, GenericJsonRequestHandler<C> handler, TalkManager talkManager) {
        String jsonMessage;
        try {
            ControllerHelper.checkEmpty("config", config);
            C confInstance = this.loadConfigurationInstance(config);
            try {
                jsonMessage = handler.handleRequest(confInstance);
            }
            finally {
                confInstance.closeConnections();
            }
        }
        catch (IOException exc) {
            Message sentence = new Message(this.messageId, "not.found.config");
            sentence.addParam(config);
            sentence.addParam(exc.toString());
            talkManager.addSentence(sentence);
            Logger logger = talkManager.getLogger();
            logger.log(Level.SEVERE, ExceptionUtils.getStackTrace(exc));
            jsonMessage = JsonHelper.buildMessage(null, null, talkManager);
        }
        catch (InvalidConfigurationException exc) {
            String message = exc.getMessage();
            Message sentence = new Message(this.messageId, message);
            String key = exc.getKey();
            sentence.addParam(key);
            talkManager.addSentence(sentence);
            Logger logger = talkManager.getLogger();
            logger.log(Level.SEVERE, ExceptionUtils.getStackTrace(exc));
            jsonMessage = JsonHelper.buildMessage(null, null, talkManager);
        }
        catch (InvalidParameterValue exc) {
            String message = exc.getMessage();
            Message sentence = new Message(this.messageId, message);
            sentence.addParam(exc.getName());
            sentence.addParam(exc.getValue());
            talkManager.addSentence(sentence);
            jsonMessage = JsonHelper.buildMessage(null, null, talkManager);
        }
        catch (RuntimeException exc) {
            String message = exc.getMessage();
            Message sentence = new Message(this.messageId, message);
            talkManager.addSentence(sentence);
            jsonMessage = JsonHelper.buildMessage(null, null, talkManager);
            Logger logger = talkManager.getLogger();
            logger.log(Level.SEVERE, ExceptionUtils.getStackTrace(exc));
        }
        Logger logger = talkManager.getLogger();
        logger.info(jsonMessage);
        return jsonMessage;
    }

    public static void handleVersion(ModelMap model, BasicPrebillingConfiguration configuration) {
        String version = configuration.getVersion();
        model.addAttribute("version", version);
    }
}

