/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.tools;

import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.tools.UnicodeChar;

public class UnicodeData {
    private UnicodeData() {
    }

    public static String getHexCode(int codePoint) {
        String unicode = Integer.toHexString(codePoint);
        while (unicode.length() < 4) {
            unicode = '0' + unicode;
        }
        return "U+" + unicode;
    }

    public static List<UnicodeChar> getDescriptions(String string) {
        ArrayList<UnicodeChar> descriptions = new ArrayList<UnicodeChar>();
        int length = string.length();
        for (int index = 0; index < length; ++index) {
            String uChar;
            String description = uChar = string.substring(index, index + 1);
            int code = string.codePointAt(index);
            description = description + " - " + UnicodeData.getHexCode(code);
            Character.UnicodeBlock block = Character.UnicodeBlock.of(code);
            String language = block == null ? "unknown" : block.toString();
            description = description + " (" + language + ")";
            UnicodeChar unicodeChar = new UnicodeChar(uChar, description);
            descriptions.add(unicodeChar);
        }
        return descriptions;
    }
}

