/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.structures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.arrays.Condition;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.ClassBuilder;
import org.homelinux.elabor.structures.DefaultMapHandler;
import org.homelinux.elabor.structures.DefaultMapXHandler;
import org.homelinux.elabor.structures.KeyRecord;
import org.homelinux.elabor.structures.MapHandler;
import org.homelinux.elabor.structures.MapXHandler;
import org.homelinux.elabor.structures.extractors.EntryExtractor;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.structures.extractors.KeyRecordExtractor;

public class StructuresHelper {
    private StructuresHelper() {
    }

    public static <K, T> T getOrCreate(K key, Map<K, T> map, Class<? extends T> typeClass) {
        DefaultMapXHandler handler = new DefaultMapXHandler(typeClass);
        return StructuresHelper.getOrCreate(key, map, handler);
    }

    private static <K, T> T getOrCreate(K key, Map<K, T> map, MapXHandler<K, T, Map<K, T>> handler) {
        T value = handler.get(key, map);
        if (value == null) {
            value = handler.create(key);
            map.put(key, value);
        }
        return value;
    }

    public static <T> T get(String key, Map<String, T> map, Class<T> typeClass) throws DataNotFoundException {
        DefaultMapHandler<T> mapHandler = new DefaultMapHandler<T>(typeClass);
        return StructuresHelper.get(key, map, mapHandler);
    }

    public static <T, S> T get(String key, S source, MapHandler<T, S> handler) throws DataNotFoundException {
        T value = handler.get(key, source);
        if (value == null) {
            value = handler.create(key);
            handler.put(key, value, source);
        }
        return value;
    }

    public static <K, V extends KeyRecord<K>> void buildMap(Map<K, V> map, Iterable<V> iterable) {
        KeyRecordExtractor extractor = new KeyRecordExtractor();
        StructuresHelper.buildMap(map, iterable, extractor);
    }

    public static <K, V> void buildMap(Map<K, V> map, Iterable<V> iterable, KeyExtractor<K, V> extractor) {
        for (V value : iterable) {
            K key = extractor.getKey(value);
            map.put(key, value);
        }
    }

    public static <K, V, T> void buildMap(Map<K, V> map, Iterable<T> iterable, EntryExtractor<K, V, T> extractor) {
        for (T item : iterable) {
            Object key = extractor.getKey(item);
            V value = extractor.getValue(item);
            if (value == null) continue;
            map.put(key, value);
        }
    }

    public static <T> void fillMap(Map<String, T> mappa, Iterable<Map.Entry<String, T>> entries) {
        for (Map.Entry<String, T> entry : entries) {
            String key = entry.getKey();
            T value = entry.getValue();
            if (value == null) continue;
            mappa.put(key, value);
        }
    }

    public static <K, V, C extends Collection<V>> void buildCollectionsMap(Map<K, C> map, Iterable<V> iterable, KeyExtractor<K, V> extractor, ClassBuilder<C> builder) {
        Iterator<V> iterator = iterable.iterator();
        StructuresHelper.buildCollectionsMap(map, iterator, extractor, builder);
    }

    public static <K, V, C extends Collection<V>> void buildCollectionsMap(Map<K, C> map, Iterator<V> iterator, KeyExtractor<K, V> extractor, ClassBuilder<C> builder) {
        while (iterator.hasNext()) {
            V element = iterator.next();
            K key = extractor.getKey(element);
            Collection elements = (Collection)map.get(key);
            if (elements == null) {
                elements = (Collection)builder.newInstance();
                map.put(key, elements);
            }
            elements.add(element);
        }
    }

    public static <K, V extends KeyRecord<K>, C extends Collection<V>> void buildCollectionsMap(Map<K, C> map, Iterable<V> iterable, ClassBuilder<C> builder) {
        KeyRecordExtractor extractor = new KeyRecordExtractor();
        StructuresHelper.buildCollectionsMap(map, iterable, extractor, builder);
    }

    public static <K, V> List<K> buildList(V[] array, KeyExtractor<K, V> extractor) {
        return StructuresHelper.buildList(Arrays.asList(array), extractor);
    }

    public static <K, V> List<K> buildList(Iterable<V> iterable, KeyExtractor<K, V> extractor) {
        ArrayList list = new ArrayList();
        StructuresHelper.buildCollection(list, iterable, extractor);
        return list;
    }

    public static <K, C extends Collection<K>, V extends KeyRecord<K>> void buildCollection(C collection, Iterable<V> iterable) {
        KeyRecordExtractor extractor = new KeyRecordExtractor();
        StructuresHelper.buildCollection(collection, iterable, extractor);
    }

    public static <K, C extends Collection<K>, V> C buildCollection(C collection, V[] array, KeyExtractor<K, V> extractor) {
        return StructuresHelper.buildCollection(collection, Arrays.asList(array), extractor);
    }

    public static <K, C extends Collection<K>, V> C buildCollection(C collection, Iterable<V> iterable, KeyExtractor<K, V> extractor) {
        Iterator<V> iterator = iterable.iterator();
        return StructuresHelper.buildCollection(collection, iterator, extractor);
    }

    private static <K, C extends Collection<K>, V> C buildCollection(C collection, Iterator<V> iterator, KeyExtractor<K, V> extractor) {
        while (iterator.hasNext()) {
            V element = iterator.next();
            K key = extractor.getKey(element);
            if (key == null) continue;
            collection.add(key);
        }
        return collection;
    }

    public static <V> double getSum(Iterable<V> items, KeyExtractor<Number, V> extractor) {
        double sum = 0.0;
        for (V item : items) {
            sum += extractor.getKey(item).doubleValue();
        }
        return sum;
    }

    public static <K, V> void addElements(Map<K, V> map, Iterable<V> values, KeyExtractor<K, V> extractor) {
        for (V value : values) {
            K key = extractor.getKey(value);
            map.put(key, value);
        }
    }

    public static <K, V extends KeyRecord<K>> void addElements(Map<K, V> map, Iterable<V> values) {
        KeyRecordExtractor extractor = new KeyRecordExtractor();
        StructuresHelper.addElements(map, values, extractor);
    }

    public static <V> V findFirst(Iterable<V> values, Condition<V> condition) {
        Iterator<V> iterator = values.iterator();
        return StructuresHelper.findFirst(iterator, condition);
    }

    private static <V> V findFirst(Iterator<V> iterator, Condition<V> condition) {
        V value = null;
        while (value == null && iterator.hasNext()) {
            V current = iterator.next();
            if (!condition.check(current)) continue;
            value = current;
        }
        return value;
    }
}

