/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractConicAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.homelinux.elabor.scriptorium.ndraft.actions.HyperbolaDefinition;
import org.homelinux.elabor.scriptorium.ndraft.actions.HyperbolaEquation;
import org.w3c.dom.Element;

public final class HyperbolaAction
extends AbstractConicAction<HyperbolaAction>
implements HyperbolaDefinition {
    private static final String NUM_BRANCHES = "num_branches";
    private static final String ASYMPTOTES = "asymptotes";
    private static final String START_POINT = "start_point";
    private static final String END_POINT = "end_point";

    public HyperbolaAction() {
    }

    public HyperbolaAction(Element element) {
        super(element);
    }

    public void setNumBranches(int numBranches) {
        this.setIntAttribute(NUM_BRANCHES, numBranches);
    }

    public void setAsymptotes(boolean asymptotes) {
        this.setBooleanAttribute(ASYMPTOTES, asymptotes);
    }

    @Override
    public int getNumBranches() {
        return this.getIntAttribute(NUM_BRANCHES);
    }

    public boolean hasAsymptotes() {
        return this.getBooleanAttribute(ASYMPTOTES, true);
    }

    public void setStartPoint(ScriptoriumPoint point) {
        this.setIntAttribute(START_POINT, point.getId());
    }

    public void setEndPoint(ScriptoriumPoint point) {
        this.setIntAttribute(END_POINT, point.getId());
    }

    public int getStartPoint() {
        return this.getIntAttribute(START_POINT);
    }

    public int getEndPoint() {
        return this.getIntAttribute(END_POINT);
    }

    @Override
    public String getElementName() {
        return "hyperbola";
    }

    @Override
    protected HyperbolaAction make(Element element) {
        return new HyperbolaAction(element);
    }

    @Override
    public String toString() {
        return "Hyperbola " + this.getVertex1() + " - " + this.getVertex2() + " - " + this.getPassingBy();
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    public ScriptoriumPoint getStartPoint(Iterable<ScriptoriumPoint> drawingPoints) {
        return ShapeAdapter.getReferredItem(this.getStartPoint(), drawingPoints);
    }

    public ScriptoriumPoint getEndPoint(Iterable<ScriptoriumPoint> drawingPoints) {
        return ShapeAdapter.getReferredItem(this.getEndPoint(), drawingPoints);
    }

    @Override
    protected void project(Iterable<ScriptoriumPoint> points, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        HyperbolaEquation equation = new HyperbolaEquation(this, drawingPoints);
        for (ScriptoriumPoint point : points) {
            equation.snap(point);
        }
    }

    @Override
    protected Shape computeShape(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        HyperbolaEquation equation = new HyperbolaEquation(this, drawingPoints);
        boolean asymptotes = this.hasAsymptotes();
        return equation.getShape(drawingPoints, asymptotes);
    }

    @Override
    protected boolean isTarget() {
        return true;
    }

    @Override
    protected DraftVector getTangent(ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints) {
        HyperbolaEquation equation = new HyperbolaEquation(this, drawingPoints);
        return equation.tangent(point);
    }

    @Override
    public boolean hasFixedPoints() {
        return !this.getFixedPointsAttribute().isEmpty();
    }

    @Override
    public Point2D getCenter2D(Iterable<ScriptoriumPoint> drawingPoints) {
        ScriptoriumPoint centerPoint = this.getCenterPoint(drawingPoints);
        return centerPoint == null ? null : centerPoint.getPoint2D();
    }

    @Override
    public Point2D getVertex12D(Iterable<ScriptoriumPoint> drawingPoints) {
        return this.getVertex1Point(drawingPoints).getPoint2D();
    }

    @Override
    public Point2D getVertex22D(Iterable<ScriptoriumPoint> drawingPoints) {
        return this.getVertex2Point(drawingPoints).getPoint2D();
    }

    @Override
    public Point2D getPassingBy2D(Iterable<ScriptoriumPoint> drawingPoints) {
        return this.getPassingByPoint(drawingPoints).getPoint2D();
    }

    @Override
    public Point2D getStart2D(Iterable<ScriptoriumPoint> drawingPoints) {
        return this.getStartPoint(drawingPoints).getPoint2D();
    }

    @Override
    public Point2D getEnd2D(Iterable<ScriptoriumPoint> drawingPoints) {
        return this.getEndPoint(drawingPoints).getPoint2D();
    }
}

