/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentIdentifier;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.IdentifiedComponent;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractBasicShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractStraightLineAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ActionPoint;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.w3c.dom.Element;

public abstract class AbstractAction<T extends EditionComponent<T>>
extends AbstractBasicShape<T> {
    private static final String FIXED_POINTS = "fixed_points";

    protected abstract void execute(Iterable<ScriptoriumPoint> var1, Iterable<ComputeAction> var2) throws InvalidValueException;

    protected abstract void project(DraftVector var1, ScriptoriumPoint var2, Iterable<ScriptoriumPoint> var3, Iterable<ComputeAction> var4) throws InvalidValueException;

    protected abstract Shape computeShape(Iterable<ScriptoriumPoint> var1, Iterable<ComputeAction> var2);

    public abstract boolean isConicBy(ScriptoriumPoint var1);

    protected abstract boolean isConic();

    protected abstract DraftVector getTangent(ScriptoriumPoint var1, Iterable<ScriptoriumPoint> var2);

    public AbstractAction() {
    }

    public AbstractAction(Element element) {
        super(element);
    }

    public AbstractAction(ComputeAction action) {
        super(action);
    }

    @Override
    protected boolean canAddPoint() {
        return true;
    }

    public void setActionPoints(List<ActionPoint> points) {
        for (ActionPoint point : points) {
            this.addChild(point);
        }
    }

    public void setFixedPoints(List<ScriptoriumPoint> fixedPoints) {
        String pointsString = "";
        for (ScriptoriumPoint point : fixedPoints) {
            pointsString = String.valueOf(pointsString) + (pointsString.isEmpty() ? "" : " ") + point.getId();
        }
        this.setStringAttribute(FIXED_POINTS, pointsString);
    }

    public String getFixedPointsAttribute() {
        return this.getStringAttribute(FIXED_POINTS);
    }

    public List<Integer> getFixedPointReferences() {
        ArrayList<Integer> fixedPoints = new ArrayList<Integer>();
        String fixedPointsAttribute = this.getFixedPointsAttribute();
        if (!fixedPointsAttribute.isEmpty()) {
            String[] split;
            String[] stringArray = split = fixedPointsAttribute.split(" ");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String idStr = stringArray[n2];
                Integer id = Integer.valueOf(idStr);
                fixedPoints.add(id);
                ++n2;
            }
        }
        return fixedPoints;
    }

    public List<ScriptoriumPoint> getFixedPoints(Iterable<ScriptoriumPoint> drawingPoints) {
        ArrayList<ScriptoriumPoint> fixedPoints = new ArrayList<ScriptoriumPoint>();
        String fixedPointsAttribute = this.getFixedPointsAttribute();
        if (!fixedPointsAttribute.isEmpty()) {
            String[] split;
            String[] stringArray = split = fixedPointsAttribute.split(" ");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String idStr = stringArray[n2];
                int id = Integer.parseInt(idStr);
                ScriptoriumPoint point = ShapeAdapter.getReferredItem(id, drawingPoints);
                fixedPoints.add(point);
                ++n2;
            }
        }
        return fixedPoints;
    }

    public void addShape(ScriptoriumShape shape) {
        IdentifiedComponent<?> reference = shape.getReference();
        this.addChild(reference);
    }

    public boolean isFixing(ComponentIdentifier point) {
        List<ActionPoint> actionPoints = this.getActionPoints();
        Iterator<ActionPoint> iterator = actionPoints.iterator();
        boolean fixed = false;
        while (!fixed && iterator.hasNext()) {
            ActionPoint actionPoint = iterator.next();
            boolean bl = fixed = actionPoint.getId() == point.getId();
        }
        return fixed;
    }

    public boolean isReferenced(ComputeAction action) {
        boolean referenced = false;
        String actionKey = action.getKey().toString();
        List<ActionPoint> actionPoints = this.getActionPoints();
        Iterator<ActionPoint> iterator = actionPoints.iterator();
        while (!referenced && iterator.hasNext()) {
            ActionPoint current = iterator.next();
            String projectionKey = current.getProjectionKey();
            referenced = actionKey.equals(projectionKey);
        }
        return referenced;
    }

    protected void project(ScriptoriumPoint point, AbstractStraightLineAction<?> straightLineAction, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
        throw new InvalidValueException("impossible to snap");
    }

    protected void project(Iterable<ScriptoriumPoint> points, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
    }

    protected boolean isTarget() {
        return false;
    }

    public ComputeAction getTargetConic(ScriptoriumPoint point, Iterable<ComputeAction> actions) {
        return null;
    }
}

