/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingPalette;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class NDraftDrawingPalette
extends JToolBar
implements DrawingPalette {
    private static final long serialVersionUID = 1L;
    private JButton selectButton;
    private DrawingDirector director;
    private String selectTooltip;

    public NDraftDrawingPalette() {
        super(0);
        this.initLocale();
        this.setFloatable(false);
        this.selectButton = NDraftDrawingPalette.createButton("select", this.selectTooltip, this);
        this.add(this.selectButton);
    }

    private static JButton createButton(String iconName, String toolTip, ActionListener listener) {
        EditionManager manager = EditionManager.getInstance();
        URL iconUrl = manager.getIconUrl(iconName);
        URL selIconUrl = manager.getIconUrl(String.valueOf(iconName) + "_sel");
        JButton button = UITools.createButton(iconUrl, selIconUrl, toolTip, listener);
        return button;
    }

    public void setup(DrawingDirector drawingDirector) {
        this.director = drawingDirector;
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.selectTooltip = catalog.translate("select_tooltip");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source;
        if (this.director != null && (source = event.getSource()) == this.selectButton) {
            this.director.setSelectMode(true);
        }
    }

    @Override
    public void setSelectMode(boolean select) {
        NDraftDrawingPalette.setSelected(this.selectButton, select);
    }

    private static void setSelected(JButton button, boolean selected) {
        button.setSelected(selected);
    }
}

