/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.works;

import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.OntologyRefererPanel;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.scriptorium.services.Highlighter;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class WorkPanel
extends OntologyRefererPanel<Work> {
    private static final long serialVersionUID = 1L;
    private String italicString;
    private JLabel workLabel;
    private JCheckBox italicBox;
    private Work work;
    private final Highlighter highlighter;

    public WorkPanel() {
        this.initLocale();
        JScrollPane scrollPane = this.createScrollPane(0);
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        this.workLabel = UITools.setupLabel("", fontSize);
        this.italicBox = new JCheckBox();
        JLabel italicLabel = UITools.setupLabel(this.italicString, fontSize);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.workLabel, 0, 0, 2, 1, 100, 1, 2, 2);
        UITools.addComponent(this, scrollPane, 0, 1, 2, 1, 100, 100, 1, 2);
        UITools.addComponent(this, italicLabel, 0, 2, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, this.italicBox, 1, 2, 1, 1, 100, 1, 0, 2);
        EditionManager editionManager = EditionManager.getInstance();
        Ontology ontology = editionManager.getWorksOntology();
        this.setOntology(ontology);
        this.highlighter = new Highlighter(OntologyInitialiser.WORKS);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.italicString = catalog.translate("italic");
    }

    public void setup(GenericSelectionModel<Work> works, int index) {
        this.work = (Work)works.get(index);
        this.setReferer(this.work);
        this.highlighter.visit(this.work);
        String text = this.highlighter.getText();
        this.workLabel.setText(text);
        boolean italic = this.work.isItalic();
        this.italicBox.setSelected(italic);
        this.selectIndices();
    }

    @Override
    public boolean okAction() {
        super.okAction();
        boolean italic = this.italicBox.isSelected();
        this.work.setItalic(italic);
        return true;
    }
}

