/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.variants;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.variants.VariantItemFrame;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class VariantPanel
extends ScriptoriumPanel<Variant>
implements ActionListener,
MouseListener,
ListSelectionListener {
    public static final long serialVersionUID = 1L;
    private Variant original_variant;
    private ScriptoriumDirector director;
    private JButton add_button;
    private JButton edit_button;
    private JButton remove_button;
    private Variant variant;
    private DefaultGenericSelectionModel<VariantItem> variant_items;
    private JList<VariantItem> variantItemsList;
    private VariantItemFrame variantItemFrame;
    private String add_tooltip;
    private String edit_tooltip;
    private String remove_tooltip;
    private String add_label;
    private String edit_label;
    private String remove_label;
    private String title_border_string;

    public VariantPanel() {
        this.initLocale();
        this.variantItemFrame = null;
        Preferences preferences = Preferences.getInstance();
        this.variantItemsList = new JList();
        Color color = preferences.getColor("lists_bg_color");
        this.variantItemsList.setBackground(color);
        this.variantItemsList.addMouseListener(this);
        this.variantItemsList.addListSelectionListener(this);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.NULL);
        this.variantItemsList.setCellRenderer(renderer);
        JScrollPane variantItemsScroll = new JScrollPane(this.variantItemsList);
        this.add_button = UITools.setupButton(this.add_label, this.add_tooltip, this);
        this.add_button.setEnabled(true);
        this.edit_button = UITools.setupButton(this.edit_label, this.edit_tooltip, this);
        this.remove_button = UITools.setupButton(this.remove_label, this.remove_tooltip, this);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, variantItemsScroll, 0, 0, 1, 3, 100, 100, 1, 5);
        UITools.addComponent(this, this.add_button, 1, 0, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.edit_button, 1, 1, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.remove_button, 1, 2, 1, 1, 1, 1, 2, 2);
        this.setBorder(new TitledBorder(new LineBorder(Color.black), this.title_border_string));
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.add_tooltip = catalog.translate("addsANewVariantItem");
        this.edit_tooltip = catalog.translate("editSelectedVariantItem");
        this.remove_tooltip = catalog.translate("removeSelectedVariantItem");
        this.add_label = catalog.translate("add");
        this.edit_label = catalog.translate("edit");
        this.remove_label = catalog.translate("remove");
        this.title_border_string = catalog.translate("titleBorder");
    }

    @Override
    public void setup(ScriptoriumDirector director, Variant variant) {
        this.director = director;
        this.original_variant = variant;
        this.variant = this.original_variant.makeCopy(new Variant());
        this.variant_items = new DefaultGenericSelectionModel<VariantItem>(this.variant.getVariantItems());
        this.variantItemsList.setModel(this.variant_items);
        this.setVisible(true);
    }

    @Override
    public boolean okAction() {
        EditionComposite<Variant> parent = this.original_variant.getParent();
        parent.replaceChild(this.original_variant, this.variant);
        this.director.valueChanged(this);
        return true;
    }

    private void openVariantItemFrame(int index) {
        if (this.variantItemFrame == null) {
            this.variantItemFrame = new VariantItemFrame();
        }
        Edition edition = this.director.getEdition();
        this.variantItemFrame.setup(edition, this.variant, this.variant_items, index);
    }

    private void removeSelectedVariantItem() {
        int index = this.variantItemsList.getSelectedIndex();
        VariantItem item = this.variant_items.get(index);
        this.variant.removeChild(item);
        this.variant_items.removeElementAt(index);
    }

    private void editSelectedVariantItem() {
        int index = this.variantItemsList.getSelectedIndex();
        this.openVariantItemFrame(index);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.add_button) {
            this.openVariantItemFrame(-1);
        } else if (source == this.edit_button) {
            this.editSelectedVariantItem();
        } else if (source == this.remove_button) {
            this.removeSelectedVariantItem();
        }
    }

    @Override
    public boolean closing() {
        if (this.variantItemFrame != null) {
            this.variantItemFrame.dispose();
        }
        return super.closing();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        int index;
        Object source = event.getSource();
        if (event.getClickCount() == 2 && source == this.variantItemsList && (index = this.variantItemsList.locationToIndex(event.getPoint())) >= 0) {
            this.openVariantItemFrame(index);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        int index = this.variantItemsList.getSelectedIndex();
        this.remove_button.setEnabled(index >= 1);
        this.edit_button.setEnabled(index >= 1);
    }
}

