/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.mathconcepts;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.mathconcepts.MathConceptFrame;
import org.homelinux.elabor.ui.GenericSelectionModel;

public class MathConceptsPanel
extends OldScriptoriumListArea<MathConcept> {
    private static final long serialVersionUID = 1L;
    private MathConceptFrame mathConceptFrame;

    public MathConceptsPanel() {
        super(false, true, true);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.MATH_CONCEPTS);
        this.setCellRenderer(renderer);
        LineBorder border = new LineBorder(Color.black);
        this.setBorder(border);
        this.mathConceptFrame = new MathConceptFrame();
    }

    @Override
    public void setup(ScriptoriumDirector director, MathConcept mathConcept) {
        Edition edition = director.getEdition();
        Content content = edition.getContent();
        List<MathConcept> mathConcepts = content.getMathConcepts();
        super.setup(director, mathConcepts, mathConcept);
    }

    private void openMathConceptFrame(int index) {
        GenericSelectionModel<MathConcept> model = this.getModel();
        this.mathConceptFrame.setup(model, index);
    }

    @Override
    public void addAction() {
    }

    @Override
    public void remAction(int index, MathConcept mathConcept) {
        GenericSelectionModel model = this.getModel();
        model.removeElementAt(index);
        this.getDirector().downgradeComponent(mathConcept);
    }

    @Override
    public void editAction(int index, MathConcept mathConcept) {
        this.openMathConceptFrame(index);
    }

    @Override
    public boolean closing() {
        if (this.mathConceptFrame != null) {
            this.mathConceptFrame.dispose();
        }
        return super.closing();
    }
}

