/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.transformations;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.itools.DefaultPanel;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Transform;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class DrawingTranslationPanel
extends ScriptoriumPanel<Transform> {
    private static final long serialVersionUID = 1L;
    private String xTranslationLabel;
    private String yTranslationLabel;
    private JTextField xTranslationField;
    private JTextField yTranslationField;
    private DrawingDirector director;

    public DrawingTranslationPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        JLabel xTranslation_label = new JLabel(this.xTranslationLabel, 4);
        this.xTranslationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel yTranslation_label = new JLabel(this.yTranslationLabel, 4);
        this.yTranslationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, xTranslation_label, 0, 0, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.xTranslationField, 1, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, yTranslation_label, 0, 1, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.yTranslationField, 1, 1, 1, 1, 100, 1, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.xTranslationLabel = catalog.translate("xTranslation");
        this.yTranslationLabel = catalog.translate("yTranslation");
    }

    public void setup(DrawingDirector drawingDirector) {
        this.director = drawingDirector;
        this.xTranslationField.setText("0");
        this.yTranslationField.setText("0");
    }

    @Override
    public boolean okAction() {
        boolean ok;
        String xText = this.xTranslationField.getText();
        DefaultPanel.CheckDoubleField checkX = this.checkDoubleField(xText, this.xTranslationLabel);
        String yText = this.yTranslationField.getText();
        DefaultPanel.CheckDoubleField checkY = this.checkDoubleField(yText, this.yTranslationLabel);
        boolean bl = ok = checkX.ok && checkY.ok;
        if (ok) {
            this.director.executeDrawingTranslation(checkX.value, checkY.value);
        }
        return ok;
    }
}

