/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.shapes;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.itools.DefaultPanel;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.CharRotation;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Arc;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Bezier;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.CircleByCenter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Ellipse;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.EllipseByPoints;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.LabelAnchorType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.LabelRotationType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Line;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.Style;
import org.homelinux.elabor.scriptorium.ecomponents.old.CircleByApproximation;
import org.homelinux.elabor.scriptorium.ecomponents.old.CircleByPoints;
import org.homelinux.elabor.scriptorium.ecomponents.old.Segment;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.CharRotationRenderer;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.labels.LabelField;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointReferencesArea;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ComputedValuesArea;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.LabelAnchorTypeRenderer;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.LabelRotationArea;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapeFieldsVisitor;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapeGUI;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.DefaultStyle;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.EnumComboBox;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class ShapePanel
extends ScriptoriumPanel<ScriptoriumShape>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DrawingDirector director;
    private int index;
    private LabelField labelField;
    private EnumComboBox<LabelAnchorType> anchorTypeMenu;
    private JTextField anchorXField;
    private JTextField anchorYField;
    private JTextField angleRotationField;
    private LabelRotationArea labelRotationArea;
    private EnumComboBox<CharRotation> charRotationMenu;
    private JTextField charInterspaceField;
    private JComboBox<?> shapeTypeMenu;
    private JCheckBox circleBox;
    private JCheckBox arcOnlyBox;
    private JComboBox<ScriptoriumStyle> styleMenu;
    private JCheckBox visibleBox;
    private JLabel circleLabel;
    private JLabel arcOnlyLabel;
    private Map<String, JCheckBox> attributes;
    private String labelString;
    private String anchorTypesString;
    private String anchorXFieldString;
    private String anchorYFieldString;
    private String labelRotationString;
    private String charRotationString;
    private String charInterspaceString;
    private String shapeTypeString;
    private String circleString;
    private String arcOnlyString;
    private String styleString;
    private String visibleString;
    private String pointsListString;
    private String computedValuesString;
    private List<ShapeGUI> shapeGUIs;
    private EditionNodeRenderer renderer;
    private PointReferencesArea pointsArea;
    private LabelAnchorType oldAnchorType;
    private JLabel charInterspaceLabel;
    private ComputedValuesArea computedValuesArea;
    private ScriptoriumFrame<?> frame;
    private boolean newShape;
    private double newShapeCharInterspace;
    private String labelPositionString;

    public ShapePanel(List<ShapeGUI> shapeGUIs, ScriptoriumFrame<?> frame) {
        this.frame = frame;
        this.initLocale();
        JLabel labelLabel = new JLabel(this.labelString, 4);
        JLabel charRotationLabel = new JLabel(this.charRotationString, 4);
        this.charInterspaceLabel = new JLabel(this.charInterspaceString, 4);
        JLabel typeLabel = new JLabel(this.shapeTypeString, 4);
        this.circleLabel = new JLabel(this.circleString, 4);
        this.arcOnlyLabel = new JLabel(this.arcOnlyString, 4);
        JLabel visibleLabel = new JLabel(this.visibleString, 4);
        JLabel styleLabel = new JLabel(this.styleString, 4);
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        this.labelField = new LabelField(this, fontSize, editableBgColor, frame);
        LabelAnchorTypeRenderer anchorRenderer = new LabelAnchorTypeRenderer();
        this.anchorTypeMenu = new EnumComboBox<LabelAnchorType>(LabelAnchorType.class, anchorRenderer);
        this.anchorTypeMenu.addActionListener(this);
        this.angleRotationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.labelRotationArea = new LabelRotationArea(this.angleRotationField);
        this.labelRotationArea.setBorder(new TitledBorder(new LineBorder(Color.BLACK), this.labelRotationString));
        this.anchorXField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.anchorYField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        CharRotationRenderer charRotationRenderer = new CharRotationRenderer();
        this.charRotationMenu = new EnumComboBox<CharRotation>(CharRotation.class, charRotationRenderer);
        this.charRotationMenu.addActionListener(this);
        this.charInterspaceField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.shapeGUIs = shapeGUIs;
        this.shapeTypeMenu = new JComboBox<ShapeGUI>(this.shapeGUIs.toArray(new ShapeGUI[this.shapeGUIs.size()]));
        this.shapeTypeMenu.addActionListener(this);
        this.circleBox = new JCheckBox();
        this.arcOnlyBox = new JCheckBox();
        this.visibleBox = new JCheckBox();
        this.styleMenu = new JComboBox();
        this.styleMenu.addActionListener(this);
        this.initPointsArea();
        this.initComputedValues();
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, labelLabel, 0, 0, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.labelField, 1, 0, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, typeLabel, 0, 1, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.shapeTypeMenu, 1, 1, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, this.circleLabel, 0, 2, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.circleBox, 1, 2, 1, 1, 100, 1, 0, 2);
        UITools.addComponent(this, this.arcOnlyLabel, 0, 3, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.arcOnlyBox, 1, 3, 1, 1, 100, 1, 0, 2);
        JPanel labelPositionPanel = this.buildLabelPositionPanel();
        UITools.addComponent(this, labelPositionPanel, 0, 4, 2, 1, 100, 100, 1, 2);
        UITools.addComponent(this, this.labelRotationArea, 0, 7, 2, 1, 100, 100, 1, 2);
        UITools.addComponent(this, charRotationLabel, 0, 11, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.charRotationMenu, 1, 11, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, this.charInterspaceLabel, 0, 12, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.charInterspaceField, 1, 12, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, styleLabel, 0, 13, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.styleMenu, 1, 13, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, visibleLabel, 0, 14, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.visibleBox, 1, 14, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, this.pointsArea, 0, 15, 2, 1, 100, 100, 1, 2);
        UITools.addComponent(this, this.computedValuesArea, 0, 16, 2, 1, 100, 100, 1, 2);
        this.initShapeAttributes();
    }

    private JPanel buildLabelPositionPanel() {
        JLabel anchorTypeMenuLabel = new JLabel(this.anchorTypesString, 4);
        JLabel anchorXLabel = new JLabel(this.anchorXFieldString, 4);
        JLabel anchorYLabel = new JLabel(this.anchorYFieldString, 4);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), this.labelPositionString));
        UITools.addComponent(panel, anchorTypeMenuLabel, 0, 4, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(panel, this.anchorTypeMenu, 1, 4, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(panel, anchorXLabel, 0, 5, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(panel, this.anchorXField, 1, 5, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(panel, anchorYLabel, 0, 6, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(panel, this.anchorYField, 1, 6, 1, 1, 100, 1, 2, 2);
        return panel;
    }

    private void initShapeAttributes() {
        int attrIndex;
        String name;
        this.attributes = new HashMap<String, JCheckBox>();
        Preferences preferences = Preferences.getInstance();
        while ((name = preferences.getString("shape_attribute_name_" + (attrIndex = this.attributes.size() + 1))) != null) {
            String labelLabelString = preferences.getString("shape_attribute_label_" + attrIndex);
            JLabel label = new JLabel(labelLabelString);
            JCheckBox attribute = new JCheckBox();
            UITools.addComponent(this, label, 0, 11 + attrIndex, 1, 1, 1, 1, 2, 2);
            UITools.addComponent(this, attribute, 1, 11 + attrIndex, 1, 1, 100, 1, 2, 2);
            this.attributes.put(name, attribute);
        }
    }

    private void initPointsArea() {
        this.pointsArea = new PointReferencesArea(this);
        this.renderer = new EditionNodeRenderer(OntologyInitialiser.NULL);
        this.pointsArea.setCellRenderer(this.renderer);
        AbstractBorder border = new LineBorder(Color.BLACK);
        border = new TitledBorder(border, this.pointsListString);
        this.pointsArea.setBorder(border);
    }

    private void initComputedValues() {
        this.computedValuesArea = new ComputedValuesArea();
        AbstractBorder border = new LineBorder(Color.BLACK);
        border = new TitledBorder(border, this.computedValuesString);
        this.computedValuesArea.setBorder(border);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        Preferences preferences = Preferences.getInstance();
        String locale = preferences.getProperty("locale");
        Class<?> panelClass = this.getClass();
        String className = panelClass.getName();
        catalog.loadCatalog(className, locale);
        this.labelString = catalog.translate("name");
        this.shapeTypeString = catalog.translate("shapeType");
        this.circleString = catalog.translate("circle");
        this.arcOnlyString = catalog.translate("arcOnly");
        this.labelPositionString = catalog.translate("labelPosition");
        this.anchorTypesString = catalog.translate("anchorTypesMenu");
        this.anchorXFieldString = catalog.translate("anchorXField");
        this.anchorYFieldString = catalog.translate("anchorYField");
        this.labelRotationString = catalog.translate("labelRotation");
        this.charRotationString = catalog.translate("charRotation");
        this.charInterspaceString = catalog.translate("charInterspace");
        this.styleString = catalog.translate("style");
        this.visibleString = catalog.translate("visible");
        this.pointsListString = catalog.translate("pointsList");
        this.computedValuesString = catalog.translate("computedValues");
    }

    public void setup(DrawingDirector director, int index) {
        List<PointReference> references;
        this.director = director;
        this.reloadStyles();
        this.index = index;
        if (index < 0) {
            references = this.setNewShape();
            this.newShape = true;
            this.newShapeCharInterspace = 0.0;
        } else {
            references = this.setExistingShape(index);
            this.newShape = false;
        }
        Iterable<ScriptoriumPoint> points = this.director.getPoints();
        this.renderer.setDrawingPoints(points);
        DefaultGenericSelectionModel<PointReference> pointsReferences = new DefaultGenericSelectionModel<PointReference>(references);
        this.pointsArea.setup((GenericSelectionModel<PointReference>)pointsReferences, this.director);
        this.updateFields();
    }

    private List<PointReference> setNewShape() {
        this.anchorTypeMenu.setSelectedIndex(0);
        this.anchorXField.setText("0");
        this.anchorYField.setText("0");
        this.angleRotationField.setText("0");
        this.labelRotationArea.setSelectedItem(null);
        this.charRotationMenu.setSelectedItem((Object)CharRotation.NORMAL);
        this.shapeTypeMenu.setEnabled(true);
        this.shapeTypeMenu.setSelectedIndex(0);
        for (JCheckBox entry : this.attributes.values()) {
            entry.setSelected(false);
        }
        this.circleBox.setSelected(false);
        this.arcOnlyBox.setSelected(false);
        this.visibleBox.setSelected(true);
        this.styleMenu.setEnabled(true);
        GenericSelectionModel<ScriptoriumStyle> styles = this.director.getStylesModel();
        if (styles.getSize() > 0) {
            this.styleMenu.setSelectedIndex(0);
        }
        String newShapeCharInterspaceString = String.valueOf(this.newShapeCharInterspace);
        this.charInterspaceField.setText(newShapeCharInterspaceString);
        ArrayList<PointReference> references = new ArrayList<PointReference>();
        return references;
    }

    private List<PointReference> setExistingShape(int index) {
        ScriptoriumShape shape = this.director.getShape(index);
        AbstractShape<?> innerShape = shape.getShape();
        this.labelField.setText(innerShape.getLabel());
        for (ShapeGUI shapeGUI : this.shapeGUIs) {
            String innerElementName;
            String elementName = shapeGUI.getElementName();
            if (!elementName.equals(innerElementName = innerShape.getElementName())) continue;
            this.shapeTypeMenu.setSelectedItem(shapeGUI);
        }
        this.shapeTypeMenu.setEnabled(false);
        Style style = new ScriptoriumStyle();
        String styleName = innerShape.getStyleName();
        if (styleName != null) {
            style = this.director.getStyle(styleName);
            this.styleMenu.setSelectedItem(style);
        } else {
            this.styleMenu.setSelectedIndex(0);
            style = this.director.getSelectedStyle();
        }
        this.oldAnchorType = innerShape.getLabelAnchorType();
        this.anchorTypeMenu.setSelectedItem((Object)this.oldAnchorType);
        Point2D relativeP = innerShape.getLabelPosition();
        double relativeX = relativeP.getX();
        this.anchorXField.setText(String.valueOf(relativeX));
        double relativeY = relativeP.getY();
        this.anchorYField.setText(String.valueOf(relativeY));
        int labelRotation = innerShape.getLabelRotation();
        this.angleRotationField.setText(String.valueOf(labelRotation));
        LabelRotationType rotationType = innerShape.getLabelRotationType();
        this.labelRotationArea.setSelectedItem(rotationType);
        CharRotation charRotation = innerShape.getCharRotation();
        this.charRotationMenu.setSelectedItem((Object)charRotation);
        double charInterspace = innerShape.getCharInterspace();
        this.charInterspaceField.setText(String.valueOf(charInterspace));
        this.visibleBox.setSelected(innerShape.isVisible());
        EllipseByPoints ellipse = shape.getEllipseByPoints();
        if (ellipse != null) {
            this.arcOnlyBox.setSelected(ellipse.isArcOnly());
            this.circleBox.setSelected(ellipse.isCircle());
        }
        for (String key : this.attributes.keySet()) {
            JCheckBox value = this.attributes.get(key);
            boolean innerValue = innerShape.getShapeAttributeValue(key);
            value.setSelected(innerValue);
        }
        List<PointReference> references = innerShape.getPointReferences();
        return references;
    }

    private void reloadStyles() {
        GenericSelectionModel<ScriptoriumStyle> styles = this.director.getStylesModel();
        this.styleMenu.setModel(styles);
    }

    private void updateFields() {
        boolean isEllipseByPoints = this.isEllipseByPointsItemSelected();
        this.setEllipseByPointsFieldsVisible(isEllipseByPoints);
        this.computedValuesArea.reset();
        ScriptoriumShape selectedShape = this.director.getSelectedShape();
        if (selectedShape != null) {
            Iterable<ScriptoriumPoint> points = this.director.getPoints();
            ShapeFieldsVisitor visitor = new ShapeFieldsVisitor(this, points);
            AbstractShape<?> shape = selectedShape.getShape();
            shape.accept(visitor);
        }
    }

    private boolean isEllipseByPointsItemSelected() {
        int shapeIndex = this.shapeTypeMenu.getSelectedIndex();
        ShapeGUI selectedShapeGUI = this.shapeGUIs.get(shapeIndex);
        String ellipseName = ComponentType.ELLIPSE_BY_POINTS.getName();
        String shapeName = selectedShapeGUI.getElementName();
        boolean isEllipseByPoints = shapeName.equals(ellipseName);
        return isEllipseByPoints;
    }

    private void setEllipseByPointsFieldsVisible(boolean visible) {
        this.circleBox.setVisible(visible);
        this.arcOnlyBox.setVisible(visible);
        this.circleLabel.setVisible(visible);
        this.arcOnlyLabel.setVisible(visible);
    }

    private void setVisibleCharInterspaceField() {
        boolean isOblique;
        int charRotationIndex = this.charRotationMenu.getSelectedIndex();
        CharRotation charRotation = CharRotation.values()[charRotationIndex];
        boolean bl = isOblique = charRotation == CharRotation.OBLIQUE;
        if (isOblique && this.newShape) {
            this.updateCharInterspaceField();
        }
        this.charInterspaceLabel.setVisible(isOblique);
        this.charInterspaceField.setVisible(isOblique);
    }

    private void updateCharInterspaceField() {
        this.newShapeCharInterspace = this.getNewShapeCharInterspace();
        String charInterspace = String.valueOf(this.newShapeCharInterspace);
        this.charInterspaceField.setText(charInterspace);
    }

    @Override
    public boolean okAction() {
        AbstractShape innerShape;
        boolean ok = true;
        if (this.index >= 0) {
            GenericSelectionModel<PointReference> points = this.pointsArea.getModel();
            ScriptoriumShape shape = this.director.getShape(this.index);
            innerShape = shape.getShape();
            innerShape.setPoints(points);
        } else {
            int selectedIndex = this.shapeTypeMenu.getSelectedIndex();
            ShapeGUI shapeGUI = this.shapeGUIs.get(selectedIndex);
            String selectedType = shapeGUI.getElementName();
            if (selectedType.equals(ComponentType.ARC.getName())) {
                innerShape = new Arc();
            } else if (selectedType.equals(ComponentType.BEZIER.getName())) {
                innerShape = new Bezier();
            } else if (selectedType.equals(ComponentType.CIRCLE_BY_CENTER.getName())) {
                innerShape = new CircleByCenter();
            } else if (selectedType.equals(ComponentType.CIRCLE_BY_POINTS.getName())) {
                innerShape = new CircleByPoints();
            } else if (selectedType.equals(ComponentType.CIRCLE_BY_APPROXIMATION.getName())) {
                innerShape = new CircleByApproximation();
            } else if (selectedType.equals(ComponentType.ELLIPSE.getName())) {
                innerShape = new Ellipse();
            } else if (selectedType.equals(ComponentType.ELLIPSE_BY_POINTS.getName())) {
                innerShape = new EllipseByPoints();
            } else if (selectedType.equals(ComponentType.LINE.getName())) {
                innerShape = new Line();
            } else if (selectedType.equals(ComponentType.SEGMENT.getName())) {
                innerShape = new Segment();
            } else {
                throw new RuntimeException("unknown shape type: " + selectedType);
            }
            this.director.addShape(innerShape);
            this.director.setSelectMode(false);
        }
        String name = this.labelField.getText();
        innerShape.setLabel(name);
        this.setLabelCoordinates(innerShape);
        this.setLabelRotationData(innerShape);
        this.setStyle(innerShape);
        innerShape.setVisible(this.visibleBox.isSelected());
        if (innerShape instanceof EllipseByPoints) {
            EllipseByPoints ellipse = (EllipseByPoints)innerShape;
            ellipse.setArcOnly(this.arcOnlyBox.isSelected());
            ellipse.setCircle(this.circleBox.isSelected());
        }
        for (Map.Entry<String, JCheckBox> entry : this.attributes.entrySet()) {
            String key = entry.getKey();
            JCheckBox value = entry.getValue();
            boolean selected = value.isSelected();
            innerShape.setShapeAttributeValue(key, selected);
        }
        return ok;
    }

    private boolean setLabelRotationData(AbstractShape<?> innerShape) {
        boolean ok;
        LabelRotationType rotationType = (LabelRotationType)((Object)this.labelRotationArea.getSelectedItem());
        boolean bl = ok = rotationType != null;
        if (ok) {
            innerShape.setLabelRotationType(rotationType);
        }
        if (LabelRotationType.EXPLICIT.equals((Object)rotationType)) {
            String labelRotationText = this.angleRotationField.getText();
            DefaultPanel.CheckIntField checkLabelRotation = this.checkIntField(labelRotationText, this.labelRotationString);
            ok = checkLabelRotation.ok;
            if (ok) {
                innerShape.setLabelRotation(checkLabelRotation.value);
            }
        } else {
            innerShape.setLabelRotation(0);
        }
        int selectedIndex = this.charRotationMenu.getSelectedIndex();
        CharRotation charRotation = CharRotation.values()[selectedIndex];
        innerShape.setCharRotation(charRotation);
        String charInterspaceText = this.charInterspaceField.getText();
        double charInterspace = Double.parseDouble(charInterspaceText);
        innerShape.setCharInterspace(charInterspace);
        return ok;
    }

    private void setStyle(AbstractShape<?> innerShape) {
        ScriptoriumStyle selectedStyle = this.director.getSelectedStyle();
        if (selectedStyle == null) {
            innerShape.setStyleName("");
        } else {
            String styleName = selectedStyle.getName();
            innerShape.setStyleName(styleName);
        }
    }

    private void setLabelCoordinates(AbstractShape<?> innerShape) {
        int anchorTypeIndex = this.anchorTypeMenu.getSelectedIndex();
        LabelAnchorType newAnchorType = LabelAnchorType.values()[anchorTypeIndex];
        innerShape.setLabelAnchorType(newAnchorType);
        String labelX = this.anchorXField.getText();
        double insertedX = Double.parseDouble(labelX);
        String labelY = this.anchorYField.getText();
        double insertedY = Double.parseDouble(labelY);
        Point2D.Double point = new Point2D.Double(insertedX, insertedY);
        innerShape.setLabelPosition(point);
    }

    private void switchLabelPosition() {
        int anchorTypeIndex = this.anchorTypeMenu.getSelectedIndex();
        LabelAnchorType newAnchorType = LabelAnchorType.values()[anchorTypeIndex];
        if (newAnchorType != this.oldAnchorType) {
            String anchorXText = this.anchorXField.getText();
            String labelX = !anchorXText.isEmpty() ? anchorXText : "0";
            String anchorYText = this.anchorYField.getText();
            String labelY = !anchorYText.isEmpty() ? anchorYText : "0";
            double oldX = Double.parseDouble(labelX);
            double oldY = Double.parseDouble(labelY);
            if (oldX != 0.0 || oldY != 0.0) {
                ScriptoriumShape shape = this.director.getShape(this.index);
                AbstractShape<?> innerShape = shape.getShape();
                Point2D oldAnchor = this.director.getAnchorPosition(this.oldAnchorType, innerShape);
                Point2D newAnchor = this.director.getAnchorPosition(newAnchorType, innerShape);
                Point2D relativePoint = ShapePanel.convertLabelCoordinates(oldAnchor, newAnchor, oldX, oldY);
                this.anchorXField.setText(String.valueOf(relativePoint.getX()));
                this.anchorYField.setText(String.valueOf(relativePoint.getY()));
                this.oldAnchorType = newAnchorType;
            }
        }
    }

    public static Point2D convertLabelCoordinates(Point2D oldAnchor, Point2D newAnchor, double oldX, double oldY) {
        double oldAnchorX = oldAnchor.getX();
        double oldAnchorY = oldAnchor.getY();
        double newAnchorX = newAnchor.getX();
        double newAnchorY = newAnchor.getY();
        double newX = oldX + oldAnchorX - newAnchorX;
        double newY = oldY + oldAnchorY - newAnchorY;
        Point2D.Double relativePoint = new Point2D.Double(newX, newY);
        return relativePoint;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.shapeTypeMenu) {
            this.updateFields();
        } else if (source == this.anchorTypeMenu) {
            this.switchLabelPosition();
        } else if (source == this.charRotationMenu) {
            this.setVisibleCharInterspaceField();
        } else if (source == this.styleMenu && this.newShape) {
            this.newShapeCharInterspace = this.getNewShapeCharInterspace();
            this.updateCharInterspaceField();
        }
    }

    private double getNewShapeCharInterspace() {
        int styleIndex = this.styleMenu.getSelectedIndex();
        this.styleMenu.setSelectedIndex(styleIndex);
        Style style = this.director.getSelectedStyle();
        if (style == null) {
            style = new DefaultStyle();
        }
        double fontSize = style.getLabelFontSize();
        this.newShapeCharInterspace = fontSize / 10.0;
        return this.newShapeCharInterspace;
    }

    public void addComputedValue(String firstFocus) {
        this.computedValuesArea.add(firstFocus);
    }

    public void closeWindow() {
        this.frame.setVisible(false);
    }

    @Override
    public boolean closing() {
        this.labelField.closing();
        return super.closing();
    }
}

