/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.operations;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.homelinux.elabor.file.InvalidFileFormat;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.gui.drawings.operations.DrawingConverterProcessor;
import org.homelinux.elabor.scriptorium.gui.drawings.operations.LabelConverter;

class LabelConverterProcessor
extends DrawingConverterProcessor {
    private LabelConverter converter;

    public LabelConverterProcessor(File table) throws IOException, InvalidFileFormat {
        this.converter = new LabelConverter(table);
    }

    public LabelConverterProcessor(String tableName, InputStream tableStream) throws IOException, InvalidFileFormat {
        this.converter = new LabelConverter(tableName, tableStream);
    }

    @Override
    protected void processDrawing(Drawing drawing) {
        List<ScriptoriumPoint> points = drawing.getPoints();
        for (ScriptoriumPoint point : points) {
            String oldLabel = point.getLabel();
            String newLabel = this.getNewLabel(oldLabel);
            point.setLabel(newLabel);
        }
        List<ScriptoriumShape> shapes = drawing.getShapes();
        for (ScriptoriumShape shape : shapes) {
            AbstractShape<?> innerShape = shape.getShape();
            String oldLabel = innerShape.getLabel();
            String newLabel = this.getNewLabel(oldLabel);
            innerShape.setLabel(newLabel);
        }
    }

    private String getNewLabel(String oldLabel) {
        String newLabel = "";
        int index = 0;
        while (index < oldLabel.length()) {
            String oldCharacter = oldLabel.substring(index, index + 1);
            String newCharacter = this.converter.convertCharacter(oldCharacter);
            newLabel = String.valueOf(newLabel) + newCharacter;
            ++index;
        }
        return newLabel;
    }
}

