/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.operations;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.operations.ApplyStylesetProcessor;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;

public class ApplyStylesetAction
implements ActionListener {
    private String chooseStylesetString;

    public ApplyStylesetAction() {
        Preferences preferences = Preferences.getInstance();
        MessageCatalog catalog = new MessageCatalog();
        String locale = preferences.getProperty("locale");
        Class<?> objClass = this.getClass();
        String className = objClass.getName();
        catalog.loadCatalog(className, locale);
        this.chooseStylesetString = catalog.translate("chooseStyleset");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        EditionManager manager = EditionManager.getInstance();
        File[] files = manager.chooseEditionFiles();
        Edition edition = new Edition();
        File defaultFolder = EditionManager.getStylesetDefaultFolder(edition);
        File stylesetFile = this.getStylesetFile(defaultFolder);
        ApplyStylesetProcessor processor = new ApplyStylesetProcessor(stylesetFile, defaultFolder);
        manager.processFiles(files, processor, true);
    }

    private File getStylesetFile(File defaultFolder) {
        JFileChooser chooser = new JFileChooser(defaultFolder);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(this.chooseStylesetString);
        int result = chooser.showOpenDialog(null);
        File stylesetFile = result == 0 ? chooser.getSelectedFile() : null;
        return stylesetFile;
    }
}

