/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JOptionPane;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.GlyphGroup;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingArea;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UIConstants;

public class DrawingAreaMouseListener
implements MouseListener,
MouseMotionListener {
    private DrawingArea area;
    protected DrawingDirector director;
    private boolean dragLabelArea;
    private int dragShortestDistance;
    private int minTime;
    private int minLabelDistance;
    private long startDragTime;
    private String pointNotAddedString;
    private boolean labelMovable;

    public DrawingAreaMouseListener() {
        Preferences preferences = Preferences.getInstance();
        this.dragShortestDistance = preferences.getInteger("drag_shortest_distance");
        this.minTime = preferences.getInteger("drag_shortest_time");
        this.minLabelDistance = preferences.getInteger("line_selection_distance");
    }

    public void setDrawingArea(DrawingArea area) {
        this.area = area;
        Preferences preferences = Preferences.getInstance();
        String locale = preferences.getProperty("locale");
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.area.getClass().getName(), locale);
        this.pointNotAddedString = catalog.translate("pointNotAdded");
    }

    public void setDrawingDirector(DrawingDirector director) {
        this.director = director;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.area.requestFocusInWindow();
        this.area.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.area.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.area.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point2D pClick = this.getPClick(e);
        this.dragLabelArea = false;
        if (this.area.isSelectMode() && e.getButton() == 1) {
            boolean controlDown = e.isControlDown();
            boolean shiftDown = e.isShiftDown();
            boolean altDown = e.isAltDown();
            if (altDown || shiftDown) {
                if (this.director.getSelectedPoint() != null) {
                    this.dragLabelArea = true;
                    this.area.setDragStartPoint(pClick);
                    this.startDragTime = System.currentTimeMillis();
                }
            } else if (!controlDown) {
                ScriptoriumPoint nearestPoint = this.director.getNearestPoint(pClick);
                this.setLabelMovable(pClick);
                this.simpleClick(pClick, nearestPoint);
            }
        }
    }

    public void simpleClick(Point2D pClick, ScriptoriumPoint nearestPoint) {
        if (nearestPoint == null) {
            this.area.setDragStartPoint(null);
        } else if (this.director.getSelectedPoints().isEmpty()) {
            this.director.setSelectedPoint(nearestPoint);
            this.area.setDragStartPoint(pClick);
            this.startDragTime = System.currentTimeMillis();
        } else {
            this.area.setDragStartPoint(null);
            this.director.selectedPoint(nearestPoint, false);
        }
    }

    private void setLabelMovable(Point2D pClick) {
        AbstractShape<?> innerShape;
        this.labelMovable = false;
        ScriptoriumShape shape = this.director.getSelectedShape();
        if (shape != null && (innerShape = shape.getShape()) != null) {
            double anchorY;
            double absolutePositionY;
            Point2D relativePosition = innerShape.getLabelPosition();
            double relativePositionX = relativePosition.getX();
            double relativePositionY = relativePosition.getY();
            Point2D anchor = this.director.getAnchorPosition(innerShape);
            double anchorX = anchor.getX();
            double absolutePositionX = anchorX + relativePositionX;
            Point2D.Double absolutePosition = new Point2D.Double(absolutePositionX, absolutePositionY = (anchorY = anchor.getY()) + relativePositionY);
            double labelDistance = pClick.distance(absolutePosition);
            if (labelDistance <= (double)this.minLabelDistance) {
                this.labelMovable = true;
            }
        }
    }

    private Point2D getPClick(MouseEvent e) {
        Point2D pClick = this.area.getPoint(e.getX(), e.getY());
        pClick = this.area.snapToGrid(pClick);
        return pClick;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.area.isSelectMode()) {
            int selectedPointsNumber;
            Point2D pClick = this.getPClick(e);
            List<ScriptoriumPoint> selectedPoints = this.director.getSelectedPoints();
            List<ScriptoriumShape> selectedShapes = this.director.getSelectedShapes();
            int selectedShapesNumber = selectedShapes == null ? 0 : selectedShapes.size();
            int n = selectedPointsNumber = selectedPoints == null ? 0 : selectedPoints.size();
            if (this.dragLabelArea) {
                if (selectedPointsNumber == 1 && selectedShapesNumber == 0) {
                    this.area.setDragEndPoint(pClick);
                }
            } else if (!(e.isShiftDown() || e.isControlDown() || e.isAltDown())) {
                if (selectedPointsNumber == 1 && selectedShapesNumber == 0) {
                    ScriptoriumPoint selectedPoint = this.director.getSelectedPoint();
                    this.movePoint(pClick, selectedPoint);
                } else if (selectedShapesNumber == 1 && selectedPointsNumber == 0) {
                    this.moveShapeLabel(pClick);
                }
            }
            this.area.repaint();
        }
    }

    private void movePoint(Point2D pClick, ScriptoriumPoint selectedPoint) {
        Point2D dragStartPoint = this.area.getDragStartPoint();
        if (dragStartPoint != null) {
            boolean timeOk;
            double distance = pClick.distance(dragStartPoint);
            boolean distanceOk = distance > (double)this.dragShortestDistance;
            long dragTime = System.currentTimeMillis() - this.startDragTime;
            boolean bl = timeOk = dragTime > (long)this.minTime;
            if (distanceOk || timeOk) {
                this.director.recordPointMove(selectedPoint, pClick);
                selectedPoint.set(pClick);
                this.area.changeLayout();
            }
        }
    }

    private void moveShapeLabel(Point2D pClick) {
        AbstractShape<?> innerShape;
        ScriptoriumShape selectedShape = this.director.getSelectedShape();
        if (selectedShape != null && (innerShape = selectedShape.getShape()) != null && this.labelMovable) {
            Point2D newLabelcenter = this.getNewLabelcenter(pClick, innerShape);
            innerShape.setLabelPosition(newLabelcenter);
        }
    }

    private Point2D getNewLabelcenter(Point2D pClick, AbstractShape<?> innerShape) {
        double absolNewX = pClick.getX();
        double absolNewY = pClick.getY();
        Point2D anchor = this.director.getAnchorPosition(innerShape);
        double anchorX = anchor.getX();
        double anchorY = anchor.getY();
        double relNewX = absolNewX - anchorX;
        double relNewY = absolNewY - anchorY;
        Point2D.Double newLabelcenter = new Point2D.Double(relNewX, relNewY);
        return newLabelcenter;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragLabelArea) {
            this.dragLabelArea = false;
            this.area.buildSelectedLabelRect();
        }
        this.area.setClickedPoint(null);
        this.area.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point2D pClick = this.area.getPoint(e.getX(), e.getY());
        GlyphGroup selectedGroup = this.director.getSelectedGroup();
        ScriptoriumShape selectedShape = this.director.getSelectedShape();
        switch (e.getClickCount()) {
            case 2: {
                this.director.setSelectedShape(null);
                this.director.setSelectMode(true);
                break;
            }
            default: {
                boolean leftClick = e.getButton() == 1;
                boolean shiftDown = e.isShiftDown();
                boolean altDown = e.isAltDown();
                boolean controlDown = e.isControlDown();
                boolean selectMode = this.area.isSelectMode();
                if (controlDown && !shiftDown && !altDown) {
                    this.ctrlClick(pClick, selectedShape, leftClick, selectMode);
                    break;
                }
                if (selectMode) {
                    this.justClickAndSelectMode(pClick, selectedGroup, selectedShape, leftClick, shiftDown);
                    break;
                }
                if (selectedShape != null) {
                    ScriptoriumPoint point = this.director.getNearestPoint(pClick);
                    if (point == null) break;
                    this.addPointToShape(point, selectedShape);
                    break;
                }
                ScriptoriumPoint point = this.area.addPoint(pClick);
                this.director.setSelectedPoint(point);
                this.director.setFocusToPointPanel();
            }
        }
    }

    public void ctrlClick(Point2D pClick, ScriptoriumShape selectedShape, boolean leftClick, boolean selectMode) {
        ScriptoriumPoint point = this.area.addPoint(pClick);
        if (selectedShape != null) {
            if (selectMode) {
                if (!leftClick) {
                    this.addPointToShape(point, selectedShape);
                }
            } else {
                this.addPointToShape(point, selectedShape);
            }
            this.director.updatePointPanel(point);
        } else {
            this.director.setSelectedShape(null);
            this.director.setSelectedPoint(point);
        }
        this.director.setFocusToPointPanel();
    }

    private void justClickAndSelectMode(Point2D pClick, GlyphGroup selectedGroup, ScriptoriumShape selectedShape, boolean leftClick, boolean isShiftDown) {
        ScriptoriumPoint nearestPoint = this.director.getNearestPoint(pClick);
        ScriptoriumShape nearestShape = this.area.getNearestShape(pClick);
        if (nearestPoint != null) {
            this.justClickPointSelected(selectedGroup, selectedShape, leftClick, nearestPoint);
        } else if (nearestShape != null) {
            this.justClickShapeSelected(selectedGroup, leftClick, isShiftDown, nearestShape);
        } else if (!isShiftDown) {
            this.director.unselectAll();
        }
    }

    private void justClickShapeSelected(GlyphGroup selectedGroup, boolean leftClick, boolean isShiftDown, ScriptoriumShape nearestShape) {
        if (!leftClick) {
            if (selectedGroup != null) {
                selectedGroup.addGlyph(nearestShape);
                this.director.selectedShape(nearestShape, false);
            }
        } else if (isShiftDown) {
            this.director.selectedShape(nearestShape, false);
        } else {
            this.director.setSelectedShape(nearestShape);
        }
    }

    private void justClickPointSelected(GlyphGroup selectedGroup, ScriptoriumShape selectedShape, boolean leftClick, ScriptoriumPoint point) {
        if (!leftClick) {
            if (selectedGroup != null) {
                selectedGroup.addGlyph(point);
                this.director.selectedPoint(point, false);
            } else if (selectedShape != null) {
                this.addPointToShape(point, selectedShape);
            }
        } else if (selectedGroup == null) {
            this.director.selectedPoint(point, false);
        }
    }

    private void addPointToShape(ScriptoriumPoint point, ScriptoriumShape shape) {
        if (!this.director.addPointToShape(point, shape)) {
            JOptionPane.showMessageDialog(null, this.pointNotAddedString, UIConstants.getInstance().errorString, 0);
        }
    }
}

