/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.gui.ComponentObserver;
import org.homelinux.elabor.scriptorium.gui.EditionComponentFrame;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.WindowsFactory;
import org.homelinux.elabor.scriptorium.gui.variants.VariantPanel;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class VariantsPanel
extends ScriptoriumPanel<Variant>
implements ListSelectionListener,
MouseListener,
ActionListener,
ComponentObserver {
    public static final long serialVersionUID = 1L;
    private ScriptoriumDirector director;
    private Edition edition;
    private Content content;
    private JList<Variant> variantsList;
    private EditionComponentFrame<Variant, VariantPanel> variantFrame;
    private JButton remove;
    private DefaultGenericSelectionModel<Variant> variants;
    private DefaultGenericSelectionModel<OntologyClass> ontoClasses;
    private JComboBox<OntologyClass> filterMenu;
    private String removeLabelString;
    private String removeTooltipString;
    private String filterLabelString;

    public VariantsPanel(ScriptoriumDirector director, Ontology ontology) {
        this.director = director;
        this.director.addComponentObserver(this);
        this.initLocale();
        this.edition = director.getEdition();
        this.content = this.edition.getContent();
        this.variants = new DefaultGenericSelectionModel<Variant>(this.content.getVariants());
        this.variantsList = new JList<Variant>(this.variants);
        this.variantFrame = null;
        Preferences preferences = Preferences.getInstance();
        this.remove = UITools.setupButton(this.removeLabelString, this.removeTooltipString, this);
        JLabel filter_label = new JLabel(this.filterLabelString, 4);
        List<OntologyClass> classes = ontology.getClasses();
        classes.add(0, null);
        this.ontoClasses = new DefaultGenericSelectionModel<OntologyClass>(classes);
        this.filterMenu = new JComboBox<OntologyClass>(this.ontoClasses);
        this.filterMenu.addActionListener(this);
        this.variantsList.setBackground(preferences.getColor("lists_bg_color"));
        this.variantsList.addMouseListener(this);
        this.variantsList.addListSelectionListener(this);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.NULL);
        this.variantsList.setCellRenderer(renderer);
        JScrollPane variantsScroll = new JScrollPane(this.variantsList);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, filter_label, 0, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, this.filterMenu, 1, 0, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, variantsScroll, 0, 1, 2, 1, 100, 100, 1, 0);
        UITools.addComponent(this, this.remove, 0, 2, 2, 1, 1, 1, 0, 0);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.filterLabelString = catalog.translate("ontologyFilter");
        this.removeLabelString = catalog.translate("removeButtonString");
        this.removeTooltipString = catalog.translate("removeTooltipString");
    }

    public void reload() {
        this.variants = new DefaultGenericSelectionModel<Variant>(this.filterVariants());
        this.variantsList.setModel(this.variants);
    }

    protected void openVariantFrame(Variant variant) {
        if (this.variantFrame == null) {
            this.variantFrame = WindowsFactory.getVariantFrame();
        }
        this.variantFrame.setup(this.director, variant);
    }

    protected void selectVariant(Variant variant) {
        this.variantsList.removeListSelectionListener(this);
        int index = this.variants.indexOf(variant);
        if (index > -1) {
            this.variantsList.setSelectedIndex(index);
            this.variantsList.ensureIndexIsVisible(index);
        }
        this.variantsList.addListSelectionListener(this);
    }

    protected Variant getSelectedVariant() {
        int index = this.variantsList.getSelectedIndex();
        return this.variants.get(index);
    }

    private void removeSelectedVariant() {
        int index = this.variantsList.getSelectedIndex();
        Variant variant = this.getSelectedVariant();
        this.variants.removeElementAt(index);
        this.director.downgradeComponent(variant);
    }

    private List<Variant> filterVariants() {
        OntologyClass selection = (OntologyClass)this.ontoClasses.getSelectedElement();
        List<Variant> all_variants = this.content.getVariants();
        ArrayList<Variant> candidates = new ArrayList();
        if (selection != null) {
            for (Variant variant : all_variants) {
                if (!variant.referOntology(selection)) continue;
                candidates.add(variant);
            }
        } else {
            candidates = all_variants;
        }
        return candidates;
    }

    @Override
    public boolean closing() {
        if (this.variantFrame != null) {
            this.variantFrame.dispose();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.remove) {
            this.removeSelectedVariant();
        } else if (source == this.filterMenu) {
            this.reload();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        int index = this.variantsList.getSelectedIndex();
        this.remove.setEnabled(index >= 0);
        if (index >= 0) {
            this.director.valueChanged(this);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Object source = event.getSource();
        if (event.getClickCount() == 2 && source == this.variantsList) {
            this.openVariantFrame(this.getSelectedVariant());
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void selectComponent(EditionComponent<?> component) {
        Variant variant = component instanceof Variant ? (Variant)component : null;
        this.selectVariant(variant);
    }
}

