/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes;

import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Glyph;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.IdentifiedComponent;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Arc;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Bezier;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.CircleByCenter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Ellipse;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.EllipseByPoints;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Line;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeReference;
import org.homelinux.elabor.scriptorium.ecomponents.old.CircleByApproximation;
import org.homelinux.elabor.scriptorium.ecomponents.old.CircleByPoints;
import org.homelinux.elabor.scriptorium.ecomponents.old.Segment;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.GlyphVisitor;
import org.w3c.dom.Element;

public class ScriptoriumShape
extends EditionComposite<ScriptoriumShape>
implements ComponentFactory<ScriptoriumShape>,
Glyph {
    private static final long serialVersionUID = 1L;
    private static final String ID = "id";

    public ScriptoriumShape() {
    }

    public ScriptoriumShape(Element element) {
        super(element);
    }

    public ScriptoriumShape(EditionComponent<?> parent) {
        super(parent);
    }

    @Override
    public String getElementName() {
        return ComponentType.SHAPE.getName();
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ScriptoriumShape make(Element element) {
        return new ScriptoriumShape(element);
    }

    public AbstractShape<?> getShape() {
        AbstractShape shape = this.getArc();
        if (shape == null) {
            shape = this.getCircleByCenter();
        }
        if (shape == null) {
            shape = this.getCircleByApproximation();
        }
        if (shape == null) {
            shape = this.getCircleByPoints();
        }
        if (shape == null) {
            shape = this.getSegment();
        }
        if (shape == null) {
            shape = this.getBezier();
        }
        if (shape == null) {
            shape = this.getEllipse();
        }
        if (shape == null) {
            shape = this.getEllipseByPoints();
        }
        if (shape == null) {
            shape = this.getLine();
        }
        return shape;
    }

    public Arc getArc() {
        return this.getFirstNodeByType(new Arc());
    }

    public Segment getSegment() {
        return this.getFirstNodeByType(new Segment());
    }

    public CircleByCenter getCircleByCenter() {
        return this.getFirstNodeByType(new CircleByCenter());
    }

    public CircleByApproximation getCircleByApproximation() {
        return this.getFirstNodeByType(new CircleByApproximation());
    }

    public CircleByPoints getCircleByPoints() {
        return this.getFirstNodeByType(new CircleByPoints());
    }

    public Bezier getBezier() {
        return this.getFirstNodeByType(new Bezier());
    }

    public Ellipse getEllipse() {
        return this.getFirstNodeByType(new Ellipse());
    }

    public EllipseByPoints getEllipseByPoints() {
        return this.getFirstNodeByType(new EllipseByPoints());
    }

    public Line getLine() {
        return this.getFirstNodeByType(new Line());
    }

    @Override
    public void setId(int id) {
        this.setIntAttribute(ID, id);
    }

    @Override
    public int getId() {
        return this.getIntAttribute(ID);
    }

    @Override
    public void accept(GlyphVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public IdentifiedComponent<?> getReference() {
        return new ShapeReference(this, this.getListener());
    }

    public void snapPoints(Iterable<ScriptoriumPoint> points) {
        AbstractShape<?> innerShape = this.getShape();
        List<ScriptoriumPoint> shapePoints = ShapeAdapter.getShapePoints(innerShape, points);
        double ySum = 0.0;
        for (ScriptoriumPoint point : shapePoints) {
            ySum += point.getY();
        }
        double yMean = ySum / (double)shapePoints.size();
        for (ScriptoriumPoint point : shapePoints) {
            double x = point.getX();
            point.setSnap(x, yMean);
        }
    }
}

